/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.mutable.MutableInt;
import org.confluence.terra_curio.capability.ability.PlayerAbility;
import org.confluence.terra_curio.effect.ModEffects;
import org.confluence.terra_curio.item.curio.BaseCurioItem;
import org.confluence.terra_curio.item.curio.CurioItems;
import org.confluence.terra_curio.item.curio.expert.RoyalGel;
import org.confluence.terra_curio.item.curio.miscellaneous.IFlowerBoots;
import org.confluence.terra_curio.misc.ModAttributes;
import org.confluence.terra_curio.misc.ModDamageTypes;
import org.confluence.terra_curio.util.CuriosUtils;
import org.confluence.terra_curio.util.IEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Unique
    private FluidState confluence$lastWalkableFluidState;

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Inject(method={"getJumpPower"}, at={@At(value="RETURN")}, cancellable=true)
    private void multiY(CallbackInfoReturnable<Float> cir) {
        PlayerAbility.of(this.c$getSelf()).ifPresent(playerAbility -> cir.setReturnValue((Object)Float.valueOf((float)((double)((Float)cir.getReturnValue()).floatValue() * playerAbility.getJumpBoost()))));
    }

    @ModifyConstant(method={"hurt"}, constant={@Constant(intValue=20)})
    private int invulnerable1(int constant) {
        return this.c$getInvulnerableTime(constant);
    }

    @ModifyConstant(method={"handleDamageEvent"}, constant={@Constant(intValue=20)})
    private int invulnerable2(int constant) {
        return this.c$getInvulnerableTime(constant);
    }

    @Unique
    private int c$getInvulnerableTime(int constant) {
        MutableInt time = new MutableInt(constant);
        PlayerAbility.of(this.c$getSelf()).ifPresent(playerAbility -> time.setValue(playerAbility.getInvulnerableTime()));
        return time.intValue();
    }

    @ModifyArg(method={"checkFallDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;sendParticles(Lnet/minecraft/core/particles/ParticleOptions;DDDIDDDD)I"), index=2)
    private double fall2(double pPosY) {
        ServerPlayer player;
        LivingEntity livingEntity = this.c$getSelf();
        if (livingEntity instanceof ServerPlayer && ((IEntity)(player = (ServerPlayer)livingEntity)).c$isShouldRot()) {
            return pPosY + (double)this.m_6972_((Pose)player.m_20089_()).f_20378_;
        }
        return pPosY;
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="RETURN")}, cancellable=true)
    private void standOnFluid(FluidState fluidState, CallbackInfoReturnable<Boolean> cir) {
        if (fluidState.m_76178_()) {
            return;
        }
        LivingEntity self = this.c$getSelf();
        if (self.m_6047_()) {
            cir.setReturnValue((Object)false);
        } else if (this.confluence$lastWalkableFluidState == fluidState) {
            cir.setReturnValue((Object)true);
        } else {
            PlayerAbility.of(self).ifPresent(playerAbility -> {
                if (playerAbility.canWalkOnFluid(fluidState)) {
                    this.confluence$lastWalkableFluidState = fluidState;
                    cir.setReturnValue((Object)true);
                }
            });
        }
    }

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;canStandOnFluid(Lnet/minecraft/world/level/material/FluidState;)Z"))
    private boolean onFluid(LivingEntity instance, FluidState fluidState) {
        return false;
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=0))
    private Vec3 waterWalk(Vec3 par1) {
        return this.c$getWalkVec(par1);
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=2))
    private Vec3 lavaJump(Vec3 par1) {
        return this.c$getWalkVec(par1);
    }

    @ModifyArg(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;setDeltaMovement(Lnet/minecraft/world/phys/Vec3;)V", ordinal=4))
    private Vec3 lavaWalk(Vec3 par1) {
        return this.c$getWalkVec(par1);
    }

    @Unique
    private Vec3 c$getWalkVec(Vec3 par1) {
        LivingEntity self = this.c$getSelf();
        if (self.getEyeInFluidType() == ForgeMod.EMPTY_TYPE.get() && self.m_203441_(self.m_9236_().m_6425_(self.m_20183_()))) {
            AttributeInstance instance = self.m_21051_(Attributes.f_22279_);
            if (instance == null) {
                return par1;
            }
            double horizon = Math.min(0.91 * (double)self.m_6113_() / instance.m_22115_(), 0.93);
            return self.m_20184_().m_82542_(horizon, 1.0, horizon);
        }
        return par1;
    }

    @Inject(method={"getFrictionInfluencedSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void speed(float friction, CallbackInfoReturnable<Float> cir) {
        if (CuriosUtils.hasCurio(this.c$getSelf(), (BaseCurioItem)((Object)CurioItems.MAGILUMINESCENCE.get()))) {
            cir.setReturnValue((Object)Float.valueOf(((Float)cir.getReturnValue()).floatValue() * 1.75f));
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="RETURN", ordinal=1)}, cancellable=true)
    private void checkFreeze(CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue()) {
            cir.setReturnValue((Object)CuriosUtils.noSameCurio(this.c$getSelf(), (BaseCurioItem)((Object)CurioItems.HAND_WARMER.get())));
        }
    }

    @WrapOperation(method={"getDamageAfterArmorAbsorb"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/damagesource/CombatRules;getDamageAfterAbsorb(FFF)F")})
    private float passArmor(float pDamage, float pTotalArmor, float pToughnessAttribute, Operation<Float> original, @Local(argsOnly=true) DamageSource pDamageSource) {
        Entity entity = pDamageSource.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            AttributeInstance attributeInstance = attacker.m_21051_(ModAttributes.getArmorPass());
            if (attributeInstance != null) {
                pTotalArmor -= (float)attributeInstance.m_22135_();
            }
            if (pDamageSource.m_276093_(ModDamageTypes.STAR_CLOAK)) {
                pTotalArmor -= 3.0f;
            }
        }
        return ((Float)original.call(new Object[]{Float.valueOf(pDamage), Float.valueOf(Math.max(pTotalArmor, 0.0f)), Float.valueOf(pToughnessAttribute)})).floatValue();
    }

    @ModifyVariable(method={"travel"}, at=@At(value="HEAD"), argsOnly=true)
    private Vec3 confused(Vec3 vec3) {
        return this.c$getSelf().m_21023_((MobEffect)ModEffects.CONFUSED.get()) ? vec3.m_82548_() : vec3;
    }

    @Inject(method={"onChangedBlock"}, at={@At(value="TAIL")})
    private void onMoved(BlockPos pPos, CallbackInfo ci) {
        IFlowerBoots.apply(this.c$getSelf());
    }

    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void notAttack(LivingEntity pTarget, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue() && RoyalGel.apply(this.c$getSelf(), pTarget)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private LivingEntity c$getSelf() {
        return (LivingEntity)this;
    }
}

