/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.c2s;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import org.confluence.terra_curio.entity.StepStoolEntity;
import org.confluence.terra_curio.item.curio.movement.StepStool;
import org.confluence.terra_curio.util.CuriosUtils;

public record StepStoolStepPacketC2S(int slot, int step, boolean increase) {
    public static void encode(StepStoolStepPacketC2S packet, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(packet.slot);
        friendlyByteBuf.writeInt(packet.step);
        friendlyByteBuf.writeBoolean(packet.increase);
    }

    public static StepStoolStepPacketC2S decode(FriendlyByteBuf friendlyByteBuf) {
        return new StepStoolStepPacketC2S(friendlyByteBuf.readInt(), friendlyByteBuf.readInt(), friendlyByteBuf.readBoolean());
    }

    public static void handle(StepStoolStepPacketC2S packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        context.enqueueWork(() -> {
            ServerPlayer serverPlayer = context.getSender();
            if (serverPlayer == null || packet.slot == -1) {
                return;
            }
            if (packet.step == 1 && packet.increase) {
                StepStoolEntity pEntity = new StepStoolEntity((Player)serverPlayer);
                serverPlayer.m_9236_().m_7967_((Entity)pEntity);
                serverPlayer.m_246847_(0.0, 1.001, 0.0);
                CuriosUtils.getSlot((LivingEntity)serverPlayer, "accessory", packet.slot).ifPresent(itemStack -> {
                    if (itemStack.m_41720_() instanceof StepStool) {
                        itemStack.m_41784_().m_128405_("id", pEntity.m_19879_());
                    }
                });
            } else {
                CuriosUtils.getSlot((LivingEntity)serverPlayer, "accessory", packet.slot).ifPresent(itemStack -> {
                    if (itemStack.m_41720_() instanceof StepStool) {
                        int id = itemStack.m_41784_().m_128451_("id");
                        Entity entity = serverPlayer.m_9236_().m_6815_(id);
                        if (entity instanceof StepStoolEntity) {
                            StepStoolEntity stepStool = (StepStoolEntity)entity;
                            if (packet.step == 0) {
                                stepStool.setOwner(null);
                            } else {
                                stepStool.setStep(packet.step);
                                if (packet.increase) {
                                    serverPlayer.m_246847_(0.0, 1.001, 0.0);
                                }
                            }
                        }
                    }
                });
            }
        });
        context.setPacketHandled(true);
    }
}

