/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.confluence.terra_curio.client.handler.PlayerJumpHandler;

public record PlayerFlyPacketS2C(int maxFlyTicks, double flySpeed) {
    public static void encode(PlayerFlyPacketS2C packet, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeInt(packet.maxFlyTicks);
        friendlyByteBuf.writeDouble(packet.flySpeed);
    }

    public static PlayerFlyPacketS2C decode(FriendlyByteBuf friendlyByteBuf) {
        return new PlayerFlyPacketS2C(friendlyByteBuf.readInt(), friendlyByteBuf.readDouble());
    }

    public static void handle(PlayerFlyPacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PlayerFlyPacketS2C.lambda$handle$1(packet, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handle$1(PlayerFlyPacketS2C packet, Supplier ctx) {
        return () -> PlayerFlyPacketS2C.lambda$handle$0(packet, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$0(PlayerFlyPacketS2C packet, Supplier ctx) {
        PlayerJumpHandler.handleFlyPacket(packet, ctx);
    }
}

