/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.network.s2c;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.confluence.terra_curio.client.handler.PlayerJumpHandler;

public record PlayerJumpPacketS2C(double fartSpeed, double sandstormSpeed, int sandstormTicks, double blizzardSpeed, int blizzardTicks, double tsunamiSpeed, double cloudSpeed) {
    public static void encode(PlayerJumpPacketS2C packet, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeDouble(packet.fartSpeed);
        friendlyByteBuf.writeDouble(packet.sandstormSpeed);
        friendlyByteBuf.writeInt(packet.sandstormTicks);
        friendlyByteBuf.writeDouble(packet.blizzardSpeed);
        friendlyByteBuf.writeInt(packet.blizzardTicks);
        friendlyByteBuf.writeDouble(packet.tsunamiSpeed);
        friendlyByteBuf.writeDouble(packet.cloudSpeed);
    }

    public static PlayerJumpPacketS2C decode(FriendlyByteBuf friendlyByteBuf) {
        return new PlayerJumpPacketS2C(friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble(), friendlyByteBuf.readInt(), friendlyByteBuf.readDouble(), friendlyByteBuf.readInt(), friendlyByteBuf.readDouble(), friendlyByteBuf.readDouble());
    }

    public static void handle(PlayerJumpPacketS2C packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> PlayerJumpPacketS2C.lambda$handle$1(packet, (Supplier)ctx)));
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ Runnable lambda$handle$1(PlayerJumpPacketS2C packet, Supplier ctx) {
        return () -> PlayerJumpPacketS2C.lambda$handle$0(packet, (Supplier)ctx);
    }

    private static /* synthetic */ void lambda$handle$0(PlayerJumpPacketS2C packet, Supplier ctx) {
        PlayerJumpHandler.handleJumpPacket(packet, ctx);
    }
}

