/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.confluence.terra_curio.recipe.AmountIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAmountRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final ItemStack result;
    protected final NonNullList<Ingredient> ingredients;

    protected AbstractAmountRecipe(ResourceLocation pId, ItemStack pResult, NonNullList<Ingredient> pIngredients) {
        this.id = pId;
        this.result = pResult;
        this.ingredients = pIngredients;
    }

    public boolean m_5818_(@NotNull Container pContainer, @NotNull Level pLevel) {
        block0: for (Ingredient ingredient : this.ingredients) {
            for (int index = 0; index < pContainer.m_6643_(); ++index) {
                ItemStack itemStack = pContainer.m_8020_(index);
                if (!itemStack.m_41619_() && ingredient.test(itemStack)) continue block0;
            }
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_5874_(@NotNull Container pContainer, @NotNull RegistryAccess pRegistryAccess) {
        AbstractAmountRecipe.extractIngredients(pContainer, this.ingredients);
        return this.m_8043_(pRegistryAccess).m_41777_();
    }

    public static void extractIngredients(Container pContainer, NonNullList<Ingredient> ingredients) {
        block0: for (Ingredient ingredient : ingredients) {
            for (int index = 0; index < pContainer.m_6643_(); ++index) {
                ItemStack itemStack = pContainer.m_8020_(index);
                if (itemStack.m_41619_() || !ingredient.test(itemStack)) continue;
                pContainer.m_7407_(index, ((AmountIngredient)ingredient).getCount());
                continue block0;
            }
        }
    }

    public ItemStack assemble(Container container, Level level) {
        return this.m_5874_(container, level.m_9598_());
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(@Nullable RegistryAccess registryAccess) {
        return this.result;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    protected abstract int maxIngredientSize();

    public static abstract class Serializer<R extends AbstractAmountRecipe>
    implements RecipeSerializer<R> {
        protected abstract R newInstance(ResourceLocation var1, ItemStack var2, NonNullList<Ingredient> var3);

        @NotNull
        public R fromJson(@NotNull ResourceLocation pRecipeId, @NotNull JsonObject pJson) {
            ItemStack result = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"), (boolean)true, (boolean)true);
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredients");
            NonNullList nonNullList = NonNullList.m_122780_((int)ingredients.size(), (Object)((Object)AmountIngredient.EMPTY));
            HashSet<Item> items = new HashSet<Item>();
            for (int i = 0; i < ingredients.size(); ++i) {
                JsonElement jsonElement = ingredients.get(i);
                JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement.getAsJsonObject(), (String)"terra_curio:amount");
                AmountIngredient ingredient = AmountIngredient.Serializer.INSTANCE.parse(json);
                Item item = ingredient.getItem();
                if (!items.add(item)) {
                    throw new IllegalArgumentException("Duplicate ingredient " + String.valueOf(item));
                }
                nonNullList.set(i, (Object)ingredient);
            }
            if (nonNullList.isEmpty()) {
                throw new JsonParseException("No ingredients for " + String.valueOf(pRecipeId));
            }
            R recipe = this.newInstance(pRecipeId, result, (NonNullList<Ingredient>)nonNullList);
            if (ingredients.size() > ((AbstractAmountRecipe)recipe).maxIngredientSize()) {
                throw new IndexOutOfBoundsException("The ingredient size of '" + String.valueOf(pRecipeId) + "' is out of 3");
            }
            return recipe;
        }

        @Nullable
        public R fromNetwork(@NotNull ResourceLocation pRecipeId, @NotNull FriendlyByteBuf pBuffer) {
            int size = pBuffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)size, (Object)((Object)AmountIngredient.EMPTY));
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            ItemStack result = pBuffer.m_130267_();
            return this.newInstance(pRecipeId, result, (NonNullList<Ingredient>)ingredients);
        }

        public void toNetwork(@NotNull FriendlyByteBuf pBuffer, @NotNull R pRecipe) {
            pBuffer.m_130130_(((AbstractAmountRecipe)pRecipe).ingredients.size());
            for (Ingredient ingredient : ((AbstractAmountRecipe)pRecipe).ingredients) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(((AbstractAmountRecipe)pRecipe).result);
        }
    }
}

