/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.terra_curio.recipe;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Stream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AmountIngredient
extends AbstractIngredient {
    public static final AmountIngredient EMPTY = new AmountIngredient();
    private final ItemStack itemStack;

    protected AmountIngredient(ItemStack itemStack) {
        super(Stream.of(new AmountItemValue(itemStack)));
        this.itemStack = itemStack;
    }

    AmountIngredient() {
        super(Stream.empty());
        this.itemStack = ItemStack.f_41583_;
    }

    public static AmountIngredient of(ItemStack itemStack) {
        return new AmountIngredient(itemStack);
    }

    public Item getItem() {
        return this.itemStack.m_41720_();
    }

    public int getCount() {
        return this.itemStack.m_41613_();
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public ItemStack @NotNull [] m_43908_() {
        return new ItemStack[]{this.itemStack};
    }

    public boolean test(@Nullable ItemStack pStack) {
        if (pStack == null) {
            return false;
        }
        if (pStack == this.itemStack) {
            return true;
        }
        return pStack.m_41613_() >= this.itemStack.m_41613_() && (this.itemStack.m_41782_() ? ItemStack.m_150942_((ItemStack)pStack, (ItemStack)this.itemStack) : ItemStack.m_41656_((ItemStack)pStack, (ItemStack)this.itemStack));
    }

    public boolean isSimple() {
        return false;
    }

    public boolean m_43947_() {
        return this.itemStack.m_41619_();
    }

    @NotNull
    public IIngredientSerializer<AmountIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("type", "terra_curio:amount");
        AmountIngredient.serialize(jsonObject, this.itemStack);
        return jsonObject;
    }

    public static void serialize(JsonObject jsonObject, ItemStack itemStack) {
        jsonObject.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_()).toString());
        jsonObject.addProperty("count", (Number)itemStack.m_41613_());
        if (itemStack.m_41783_() != null) {
            jsonObject.addProperty("nbt", itemStack.m_41783_().toString());
        }
    }

    public static class AmountItemValue
    implements Ingredient.Value {
        private final Collection<ItemStack> itemStacks;

        public AmountItemValue(ItemStack itemStack) {
            this.itemStacks = Collections.singleton(itemStack);
        }

        @NotNull
        public Collection<ItemStack> m_6223_() {
            return this.itemStacks;
        }

        @NotNull
        public JsonObject m_6544_() {
            JsonObject jsonObject = new JsonObject();
            ItemStack itemStack = this.itemStacks.iterator().next();
            AmountIngredient.serialize(jsonObject, itemStack);
            return jsonObject;
        }
    }

    public static class Serializer
    implements IIngredientSerializer<AmountIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @NotNull
        public AmountIngredient parse(FriendlyByteBuf buffer) {
            return new AmountIngredient(buffer.m_130267_());
        }

        @NotNull
        public AmountIngredient parse(@NotNull JsonObject json) {
            return new AmountIngredient(CraftingHelper.getItemStack((JsonObject)json, (boolean)true));
        }

        public void write(FriendlyByteBuf buffer, AmountIngredient ingredient) {
            buffer.m_130055_(ingredient.itemStack);
        }
    }
}

