/*
 * Decompiled with CFR 0.152.
 */
package com.beatofthedrum.alacdecoder;

import com.beatofthedrum.alacdecoder.AlacFile;
import com.beatofthedrum.alacdecoder.Defines;
import com.beatofthedrum.alacdecoder.LeadingZeros;

class AlacDecodeUtils {
    AlacDecodeUtils() {
    }

    public static void alac_set_info(AlacFile alac, int[] inputbuffer) {
        int ptrIndex = 0;
        ptrIndex += 4;
        ptrIndex += 4;
        ptrIndex += 4;
        ptrIndex += 4;
        ptrIndex += 4;
        alac.setinfo_max_samples_per_frame = (inputbuffer[ptrIndex += 4] << 24) + (inputbuffer[ptrIndex + 1] << 16) + (inputbuffer[ptrIndex + 2] << 8) + inputbuffer[ptrIndex + 3];
        alac.setinfo_7a = inputbuffer[ptrIndex += 4];
        alac.setinfo_sample_size = inputbuffer[++ptrIndex];
        alac.setinfo_rice_historymult = inputbuffer[++ptrIndex] & 0xFF;
        alac.setinfo_rice_initialhistory = inputbuffer[++ptrIndex] & 0xFF;
        alac.setinfo_rice_kmodifier = inputbuffer[++ptrIndex] & 0xFF;
        alac.setinfo_7f = inputbuffer[++ptrIndex];
        alac.setinfo_80 = (inputbuffer[++ptrIndex] << 8) + inputbuffer[ptrIndex + 1];
        alac.setinfo_82 = (inputbuffer[ptrIndex += 2] << 24) + (inputbuffer[ptrIndex + 1] << 16) + (inputbuffer[ptrIndex + 2] << 8) + inputbuffer[ptrIndex + 3];
        alac.setinfo_86 = (inputbuffer[ptrIndex += 4] << 24) + (inputbuffer[ptrIndex + 1] << 16) + (inputbuffer[ptrIndex + 2] << 8) + inputbuffer[ptrIndex + 3];
        alac.setinfo_8a_rate = (inputbuffer[ptrIndex += 4] << 24) + (inputbuffer[ptrIndex + 1] << 16) + (inputbuffer[ptrIndex + 2] << 8) + inputbuffer[ptrIndex + 3];
        ptrIndex += 4;
    }

    static int readbits_16(AlacFile alac, int bits) {
        int result = 0;
        int new_accumulator = 0;
        int part1 = 0;
        int part2 = 0;
        int part3 = 0;
        part1 = alac.input_buffer[alac.ibIdx] & 0xFF;
        part2 = alac.input_buffer[alac.ibIdx + 1] & 0xFF;
        part3 = alac.input_buffer[alac.ibIdx + 2] & 0xFF;
        result = part1 << 16 | part2 << 8 | part3;
        result <<= alac.input_buffer_bitaccumulator;
        result &= 0xFFFFFF;
        new_accumulator = alac.input_buffer_bitaccumulator + bits;
        alac.ibIdx += new_accumulator >> 3;
        alac.input_buffer_bitaccumulator = new_accumulator & 7;
        return result >>= 24 - bits;
    }

    static int readbits(AlacFile alac, int bits) {
        int result = 0;
        if (bits > 16) {
            result = AlacDecodeUtils.readbits_16(alac, 16) << (bits -= 16);
        }
        return result |= AlacDecodeUtils.readbits_16(alac, bits);
    }

    static int readbit(AlacFile alac) {
        int result = 0;
        int new_accumulator = 0;
        int part1 = 0;
        result = part1 = alac.input_buffer[alac.ibIdx] & 0xFF;
        result <<= alac.input_buffer_bitaccumulator;
        result = result >> 7 & 1;
        new_accumulator = alac.input_buffer_bitaccumulator + 1;
        alac.ibIdx += new_accumulator / 8;
        alac.input_buffer_bitaccumulator = new_accumulator % 8;
        return result;
    }

    static void unreadbits(AlacFile alac, int bits) {
        int new_accumulator = alac.input_buffer_bitaccumulator - bits;
        alac.ibIdx += new_accumulator >> 3;
        alac.input_buffer_bitaccumulator = new_accumulator & 7;
        if (alac.input_buffer_bitaccumulator < 0) {
            alac.input_buffer_bitaccumulator *= -1;
        }
    }

    static LeadingZeros count_leading_zeros_extra(int curbyte, int output, LeadingZeros lz) {
        if ((curbyte & 0xF0) == 0) {
            output += 4;
        } else {
            curbyte >>= 4;
        }
        if ((curbyte & 8) != 0) {
            lz.output = output;
            lz.curbyte = curbyte;
            return lz;
        }
        if ((curbyte & 4) != 0) {
            lz.output = output + 1;
            lz.curbyte = curbyte;
            return lz;
        }
        if ((curbyte & 2) != 0) {
            lz.output = output + 2;
            lz.curbyte = curbyte;
            return lz;
        }
        if ((curbyte & 1) != 0) {
            lz.output = output + 3;
            lz.curbyte = curbyte;
            return lz;
        }
        lz.output = output + 4;
        lz.curbyte = curbyte;
        return lz;
    }

    static int count_leading_zeros(int input, LeadingZeros lz) {
        int output = 0;
        int curbyte = 0;
        curbyte = input >> 24;
        if (curbyte != 0) {
            AlacDecodeUtils.count_leading_zeros_extra(curbyte, output, lz);
            output = lz.output;
            curbyte = lz.curbyte;
            return output;
        }
        output += 8;
        curbyte = input >> 16;
        if ((curbyte & 0xFF) != 0) {
            AlacDecodeUtils.count_leading_zeros_extra(curbyte, output, lz);
            output = lz.output;
            curbyte = lz.curbyte;
            return output;
        }
        output += 8;
        curbyte = input >> 8;
        if ((curbyte & 0xFF) != 0) {
            AlacDecodeUtils.count_leading_zeros_extra(curbyte, output, lz);
            output = lz.output;
            curbyte = lz.curbyte;
            return output;
        }
        output += 8;
        curbyte = input;
        if ((curbyte & 0xFF) != 0) {
            AlacDecodeUtils.count_leading_zeros_extra(curbyte, output, lz);
            output = lz.output;
            curbyte = lz.curbyte;
            return output;
        }
        return output += 8;
    }

    public static int entropy_decode_value(AlacFile alac, int readSampleSize, int k, int rice_kmodifier_mask) {
        int x;
        for (x = 0; x <= Defines.RICE_THRESHOLD && AlacDecodeUtils.readbit(alac) != 0; ++x) {
        }
        if (x > Defines.RICE_THRESHOLD) {
            int value = 0;
            value = AlacDecodeUtils.readbits(alac, readSampleSize);
            x = value &= -1 >> 32 - readSampleSize;
        } else if (k != 1) {
            int extraBits = AlacDecodeUtils.readbits(alac, k);
            x *= (1 << k) - 1 & rice_kmodifier_mask;
            if (extraBits > 1) {
                x += extraBits - 1;
            } else {
                AlacDecodeUtils.unreadbits(alac, 1);
            }
        }
        return x;
    }

    public static void entropy_rice_decode(AlacFile alac, int[] outputBuffer, int outputSize, int readSampleSize, int rice_initialhistory, int rice_kmodifier, int rice_historymult, int rice_kmodifier_mask) {
        int history = rice_initialhistory;
        int signModifier = 0;
        for (int outputCount = 0; outputCount < outputSize; ++outputCount) {
            int decodedValue = 0;
            int finalValue = 0;
            int k = 0;
            k = 31 - rice_kmodifier - AlacDecodeUtils.count_leading_zeros((history >> 9) + 3, alac.lz);
            k = k < 0 ? (k += rice_kmodifier) : rice_kmodifier;
            decodedValue = AlacDecodeUtils.entropy_decode_value(alac, readSampleSize, k, -1);
            finalValue = ((decodedValue += signModifier) + 1) / 2;
            if ((decodedValue & 1) != 0) {
                finalValue *= -1;
            }
            outputBuffer[outputCount] = finalValue;
            signModifier = 0;
            history += decodedValue * rice_historymult - (history * rice_historymult >> 9);
            if (decodedValue > 65535) {
                history = 65535;
            }
            if (history >= 128 || outputCount + 1 >= outputSize) continue;
            int blockSize = 0;
            signModifier = 1;
            k = AlacDecodeUtils.count_leading_zeros(history, alac.lz) + (history + 16) / 64 - 24;
            blockSize = AlacDecodeUtils.entropy_decode_value(alac, 16, k, rice_kmodifier_mask);
            if (blockSize > 0) {
                int countSize = 0;
                countSize = blockSize;
                for (int j = 0; j < countSize; ++j) {
                    outputBuffer[outputCount + 1 + j] = 0;
                }
                outputCount += blockSize;
            }
            if (blockSize > 65535) {
                signModifier = 0;
            }
            history = 0;
        }
    }

    static int[] predictor_decompress_fir_adapt(int[] error_buffer, int output_size, int readsamplesize, int[] predictor_coef_table, int predictor_coef_num, int predictor_quantitization) {
        int i;
        int buffer_out_idx = 0;
        int bitsmove = 0;
        int[] buffer_out = error_buffer;
        if (predictor_coef_num == 0) {
            if (output_size <= 1) {
                return buffer_out;
            }
            int sizeToCopy = 0;
            sizeToCopy = (output_size - 1) * 4;
            System.arraycopy(error_buffer, 1, buffer_out, 1, sizeToCopy);
            return buffer_out;
        }
        if (predictor_coef_num == 31) {
            if (output_size <= 1) {
                return buffer_out;
            }
            for (int i2 = 0; i2 < output_size - 1; ++i2) {
                int prev_value = 0;
                int error_value = 0;
                prev_value = buffer_out[i2];
                error_value = error_buffer[i2 + 1];
                bitsmove = 32 - readsamplesize;
                buffer_out[i2 + 1] = prev_value + error_value << bitsmove >> bitsmove;
            }
            return buffer_out;
        }
        if (predictor_coef_num > 0) {
            for (i = 0; i < predictor_coef_num; ++i) {
                int val = 0;
                val = buffer_out[i] + error_buffer[i + 1];
                bitsmove = 32 - readsamplesize;
                buffer_out[i + 1] = val = val << bitsmove >> bitsmove;
            }
        }
        if (predictor_coef_num > 0) {
            buffer_out_idx = 0;
            for (i = predictor_coef_num + 1; i < output_size; ++i) {
                int val;
                int predictor_num;
                int sign;
                int sum = 0;
                int error_val = error_buffer[i];
                for (int j = 0; j < predictor_coef_num; ++j) {
                    sum += (buffer_out[buffer_out_idx + predictor_coef_num - j] - buffer_out[buffer_out_idx]) * predictor_coef_table[j];
                }
                int outval = (1 << predictor_quantitization - 1) + sum;
                outval >>= predictor_quantitization;
                outval = outval + buffer_out[buffer_out_idx] + error_val;
                bitsmove = 32 - readsamplesize;
                buffer_out[buffer_out_idx + predictor_coef_num + 1] = outval = outval << bitsmove >> bitsmove;
                if (error_val > 0) {
                    for (predictor_num = predictor_coef_num - 1; predictor_num >= 0 && error_val > 0; error_val -= ((val *= sign) >> predictor_quantitization) * (predictor_coef_num - predictor_num), --predictor_num) {
                        val = buffer_out[buffer_out_idx] - buffer_out[buffer_out_idx + predictor_coef_num - predictor_num];
                        sign = val < 0 ? -1 : (val > 0 ? 1 : 0);
                        int n = predictor_num;
                        predictor_coef_table[n] = predictor_coef_table[n] - sign;
                    }
                } else if (error_val < 0) {
                    for (predictor_num = predictor_coef_num - 1; predictor_num >= 0 && error_val < 0; error_val -= ((val *= sign) >> predictor_quantitization) * (predictor_coef_num - predictor_num), --predictor_num) {
                        val = buffer_out[buffer_out_idx] - buffer_out[buffer_out_idx + predictor_coef_num - predictor_num];
                        sign = -(val < 0 ? -1 : (val > 0 ? 1 : 0));
                        int n = predictor_num;
                        predictor_coef_table[n] = predictor_coef_table[n] - sign;
                    }
                }
                ++buffer_out_idx;
            }
        }
        return buffer_out;
    }

    public static void deinterlace_16(int[] buffer_a, int[] buffer_b, int[] buffer_out, int numchannels, int numsamples, int interlacing_shift, int interlacing_leftweight) {
        if (numsamples <= 0) {
            return;
        }
        if (0 != interlacing_leftweight) {
            for (int i = 0; i < numsamples; ++i) {
                int difference = 0;
                int midright = 0;
                int left = 0;
                int right = 0;
                midright = buffer_a[i];
                difference = buffer_b[i];
                right = midright - (difference * interlacing_leftweight >> interlacing_shift);
                buffer_out[i * numchannels] = left = right + difference;
                buffer_out[i * numchannels + 1] = right;
            }
            return;
        }
        for (int i = 0; i < numsamples; ++i) {
            int left = 0;
            int right = 0;
            left = buffer_a[i];
            right = buffer_b[i];
            buffer_out[i * numchannels] = left;
            buffer_out[i * numchannels + 1] = right;
        }
    }

    public static void deinterlace_24(int[] buffer_a, int[] buffer_b, int uncompressed_bytes, int[] uncompressed_bytes_buffer_a, int[] uncompressed_bytes_buffer_b, int[] buffer_out, int numchannels, int numsamples, int interlacing_shift, int interlacing_leftweight) {
        if (numsamples <= 0) {
            return;
        }
        if (interlacing_leftweight != 0) {
            for (int i = 0; i < numsamples; ++i) {
                int difference = 0;
                int midright = 0;
                int left = 0;
                int right = 0;
                midright = buffer_a[i];
                difference = buffer_b[i];
                right = midright - (difference * interlacing_leftweight >> interlacing_shift);
                left = right + difference;
                if (uncompressed_bytes != 0) {
                    int mask = ~(-1 << uncompressed_bytes * 8);
                    left <<= uncompressed_bytes * 8;
                    right <<= uncompressed_bytes * 8;
                    left |= uncompressed_bytes_buffer_a[i] & mask;
                    right |= uncompressed_bytes_buffer_b[i] & mask;
                }
                buffer_out[i * numchannels * 3] = left & 0xFF;
                buffer_out[i * numchannels * 3 + 1] = left >> 8 & 0xFF;
                buffer_out[i * numchannels * 3 + 2] = left >> 16 & 0xFF;
                buffer_out[i * numchannels * 3 + 3] = right & 0xFF;
                buffer_out[i * numchannels * 3 + 4] = right >> 8 & 0xFF;
                buffer_out[i * numchannels * 3 + 5] = right >> 16 & 0xFF;
            }
            return;
        }
        for (int i = 0; i < numsamples; ++i) {
            int left = 0;
            int right = 0;
            left = buffer_a[i];
            right = buffer_b[i];
            if (uncompressed_bytes != 0) {
                int mask = ~(-1 << uncompressed_bytes * 8);
                left <<= uncompressed_bytes * 8;
                right <<= uncompressed_bytes * 8;
                left |= uncompressed_bytes_buffer_a[i] & mask;
                right |= uncompressed_bytes_buffer_b[i] & mask;
            }
            buffer_out[i * numchannels * 3] = left & 0xFF;
            buffer_out[i * numchannels * 3 + 1] = left >> 8 & 0xFF;
            buffer_out[i * numchannels * 3 + 2] = left >> 16 & 0xFF;
            buffer_out[i * numchannels * 3 + 3] = right & 0xFF;
            buffer_out[i * numchannels * 3 + 4] = right >> 8 & 0xFF;
            buffer_out[i * numchannels * 3 + 5] = right >> 16 & 0xFF;
        }
    }

    public static int decode_frame(AlacFile alac, byte[] inbuffer, int[] outbuffer, int outputsize) {
        block45: {
            int channels;
            int outputsamples;
            block44: {
                outputsamples = alac.setinfo_max_samples_per_frame;
                alac.input_buffer = inbuffer;
                alac.input_buffer_bitaccumulator = 0;
                alac.ibIdx = 0;
                channels = AlacDecodeUtils.readbits(alac, 3);
                outputsize = outputsamples * alac.bytespersample;
                if (channels != 0) break block44;
                int tempPred = 0;
                AlacDecodeUtils.readbits(alac, 4);
                AlacDecodeUtils.readbits(alac, 12);
                int hassize = AlacDecodeUtils.readbits(alac, 1);
                int uncompressed_bytes = AlacDecodeUtils.readbits(alac, 2);
                int isnotcompressed = AlacDecodeUtils.readbits(alac, 1);
                if (hassize != 0) {
                    outputsamples = AlacDecodeUtils.readbits(alac, 32);
                    outputsize = outputsamples * alac.bytespersample;
                }
                int readsamplesize = alac.setinfo_sample_size - uncompressed_bytes * 8;
                if (isnotcompressed == 0) {
                    int i;
                    int[] predictor_coef_table = alac.predictor_coef_table;
                    AlacDecodeUtils.readbits(alac, 8);
                    AlacDecodeUtils.readbits(alac, 8);
                    int prediction_type = AlacDecodeUtils.readbits(alac, 4);
                    int prediction_quantitization = AlacDecodeUtils.readbits(alac, 4);
                    int ricemodifier = AlacDecodeUtils.readbits(alac, 3);
                    int predictor_coef_num = AlacDecodeUtils.readbits(alac, 5);
                    for (i = 0; i < predictor_coef_num; ++i) {
                        tempPred = AlacDecodeUtils.readbits(alac, 16);
                        if (tempPred > Short.MAX_VALUE) {
                            tempPred -= 65536;
                        }
                        predictor_coef_table[i] = tempPred;
                    }
                    if (uncompressed_bytes != 0) {
                        for (i = 0; i < outputsamples; ++i) {
                            alac.uncompressed_bytes_buffer_a[i] = AlacDecodeUtils.readbits(alac, uncompressed_bytes * 8);
                        }
                    }
                    AlacDecodeUtils.entropy_rice_decode(alac, alac.predicterror_buffer_a, outputsamples, readsamplesize, alac.setinfo_rice_initialhistory, alac.setinfo_rice_kmodifier, ricemodifier * (alac.setinfo_rice_historymult / 4), (1 << alac.setinfo_rice_kmodifier) - 1);
                    if (prediction_type == 0) {
                        alac.outputsamples_buffer_a = AlacDecodeUtils.predictor_decompress_fir_adapt(alac.predicterror_buffer_a, outputsamples, readsamplesize, predictor_coef_table, predictor_coef_num, prediction_quantitization);
                    } else {
                        System.err.println("FIXME: unhandled predicition type: " + prediction_type);
                    }
                } else {
                    if (alac.setinfo_sample_size <= 16) {
                        int bitsmove = 0;
                        for (int i = 0; i < outputsamples; ++i) {
                            int audiobits = AlacDecodeUtils.readbits(alac, alac.setinfo_sample_size);
                            bitsmove = 32 - alac.setinfo_sample_size;
                            alac.outputsamples_buffer_a[i] = audiobits = audiobits << bitsmove >> bitsmove;
                        }
                    } else {
                        int m = 0x800000;
                        for (int i = 0; i < outputsamples; ++i) {
                            int audiobits = AlacDecodeUtils.readbits(alac, 16);
                            audiobits <<= alac.setinfo_sample_size - 16;
                            int x = (audiobits |= AlacDecodeUtils.readbits(alac, alac.setinfo_sample_size - 16)) & 0xFFFFFF;
                            alac.outputsamples_buffer_a[i] = audiobits = (x ^ m) - m;
                        }
                    }
                    uncompressed_bytes = 0;
                }
                switch (alac.setinfo_sample_size) {
                    case 16: {
                        int sample;
                        for (int i = 0; i < outputsamples; ++i) {
                            outbuffer[i * alac.numchannels] = sample = alac.outputsamples_buffer_a[i];
                            outbuffer[i * alac.numchannels + 1] = 0;
                        }
                        break block45;
                    }
                    case 24: {
                        int sample;
                        for (int i = 0; i < outputsamples; ++i) {
                            sample = alac.outputsamples_buffer_a[i];
                            if (uncompressed_bytes != 0) {
                                int mask = 0;
                                sample <<= uncompressed_bytes * 8;
                                mask = ~(-1 << uncompressed_bytes * 8);
                                sample |= alac.uncompressed_bytes_buffer_a[i] & mask;
                            }
                            outbuffer[i * alac.numchannels * 3] = sample & 0xFF;
                            outbuffer[i * alac.numchannels * 3 + 1] = sample >> 8 & 0xFF;
                            outbuffer[i * alac.numchannels * 3 + 2] = sample >> 16 & 0xFF;
                            outbuffer[i * alac.numchannels * 3 + 3] = 0;
                            outbuffer[i * alac.numchannels * 3 + 4] = 0;
                            outbuffer[i * alac.numchannels * 3 + 5] = 0;
                        }
                        break block45;
                    }
                    case 20: 
                    case 32: {
                        System.err.println("FIXME: unimplemented sample size " + alac.setinfo_sample_size);
                    }
                }
                break block45;
            }
            if (channels == 1) {
                int interlacing_leftweight;
                int interlacing_shift;
                AlacDecodeUtils.readbits(alac, 4);
                AlacDecodeUtils.readbits(alac, 12);
                int hassize = AlacDecodeUtils.readbits(alac, 1);
                int uncompressed_bytes = AlacDecodeUtils.readbits(alac, 2);
                int isnotcompressed = AlacDecodeUtils.readbits(alac, 1);
                if (hassize != 0) {
                    outputsamples = AlacDecodeUtils.readbits(alac, 32);
                    outputsize = outputsamples * alac.bytespersample;
                }
                int readsamplesize = alac.setinfo_sample_size - uncompressed_bytes * 8 + 1;
                if (isnotcompressed == 0) {
                    int i;
                    int[] predictor_coef_table_a = alac.predictor_coef_table_a;
                    int[] predictor_coef_table_b = alac.predictor_coef_table_b;
                    int tempPred = 0;
                    interlacing_shift = AlacDecodeUtils.readbits(alac, 8);
                    interlacing_leftweight = AlacDecodeUtils.readbits(alac, 8);
                    int prediction_type_a = AlacDecodeUtils.readbits(alac, 4);
                    int prediction_quantitization_a = AlacDecodeUtils.readbits(alac, 4);
                    int ricemodifier_a = AlacDecodeUtils.readbits(alac, 3);
                    int predictor_coef_num_a = AlacDecodeUtils.readbits(alac, 5);
                    for (i = 0; i < predictor_coef_num_a; ++i) {
                        tempPred = AlacDecodeUtils.readbits(alac, 16);
                        if (tempPred > Short.MAX_VALUE) {
                            tempPred -= 65536;
                        }
                        predictor_coef_table_a[i] = tempPred;
                    }
                    int prediction_type_b = AlacDecodeUtils.readbits(alac, 4);
                    int prediction_quantitization_b = AlacDecodeUtils.readbits(alac, 4);
                    int ricemodifier_b = AlacDecodeUtils.readbits(alac, 3);
                    int predictor_coef_num_b = AlacDecodeUtils.readbits(alac, 5);
                    for (i = 0; i < predictor_coef_num_b; ++i) {
                        tempPred = AlacDecodeUtils.readbits(alac, 16);
                        if (tempPred > Short.MAX_VALUE) {
                            tempPred -= 65536;
                        }
                        predictor_coef_table_b[i] = tempPred;
                    }
                    if (uncompressed_bytes != 0) {
                        for (i = 0; i < outputsamples; ++i) {
                            alac.uncompressed_bytes_buffer_a[i] = AlacDecodeUtils.readbits(alac, uncompressed_bytes * 8);
                            alac.uncompressed_bytes_buffer_b[i] = AlacDecodeUtils.readbits(alac, uncompressed_bytes * 8);
                        }
                    }
                    AlacDecodeUtils.entropy_rice_decode(alac, alac.predicterror_buffer_a, outputsamples, readsamplesize, alac.setinfo_rice_initialhistory, alac.setinfo_rice_kmodifier, ricemodifier_a * (alac.setinfo_rice_historymult / 4), (1 << alac.setinfo_rice_kmodifier) - 1);
                    if (prediction_type_a == 0) {
                        alac.outputsamples_buffer_a = AlacDecodeUtils.predictor_decompress_fir_adapt(alac.predicterror_buffer_a, outputsamples, readsamplesize, predictor_coef_table_a, predictor_coef_num_a, prediction_quantitization_a);
                    } else {
                        System.err.println("FIXME: unhandled predicition type: " + prediction_type_a);
                    }
                    AlacDecodeUtils.entropy_rice_decode(alac, alac.predicterror_buffer_b, outputsamples, readsamplesize, alac.setinfo_rice_initialhistory, alac.setinfo_rice_kmodifier, ricemodifier_b * (alac.setinfo_rice_historymult / 4), (1 << alac.setinfo_rice_kmodifier) - 1);
                    if (prediction_type_b == 0) {
                        alac.outputsamples_buffer_b = AlacDecodeUtils.predictor_decompress_fir_adapt(alac.predicterror_buffer_b, outputsamples, readsamplesize, predictor_coef_table_b, predictor_coef_num_b, prediction_quantitization_b);
                    } else {
                        System.err.println("FIXME: unhandled predicition type: " + prediction_type_b);
                    }
                } else {
                    if (alac.setinfo_sample_size <= 16) {
                        for (int i = 0; i < outputsamples; ++i) {
                            int audiobits_a = AlacDecodeUtils.readbits(alac, alac.setinfo_sample_size);
                            int audiobits_b = AlacDecodeUtils.readbits(alac, alac.setinfo_sample_size);
                            int bitsmove = 32 - alac.setinfo_sample_size;
                            audiobits_a = audiobits_a << bitsmove >> bitsmove;
                            audiobits_b = audiobits_b << bitsmove >> bitsmove;
                            alac.outputsamples_buffer_a[i] = audiobits_a;
                            alac.outputsamples_buffer_b[i] = audiobits_b;
                        }
                    } else {
                        int m = 0x800000;
                        for (int i = 0; i < outputsamples; ++i) {
                            int audiobits_a = AlacDecodeUtils.readbits(alac, 16);
                            audiobits_a <<= alac.setinfo_sample_size - 16;
                            int x = (audiobits_a |= AlacDecodeUtils.readbits(alac, alac.setinfo_sample_size - 16)) & 0xFFFFFF;
                            audiobits_a = (x ^ m) - m;
                            int audiobits_b = AlacDecodeUtils.readbits(alac, 16);
                            audiobits_b <<= alac.setinfo_sample_size - 16;
                            x = (audiobits_b |= AlacDecodeUtils.readbits(alac, alac.setinfo_sample_size - 16)) & 0xFFFFFF;
                            audiobits_b = (x ^ m) - m;
                            alac.outputsamples_buffer_a[i] = audiobits_a;
                            alac.outputsamples_buffer_b[i] = audiobits_b;
                        }
                    }
                    uncompressed_bytes = 0;
                    interlacing_shift = 0;
                    interlacing_leftweight = 0;
                }
                switch (alac.setinfo_sample_size) {
                    case 16: {
                        AlacDecodeUtils.deinterlace_16(alac.outputsamples_buffer_a, alac.outputsamples_buffer_b, outbuffer, alac.numchannels, outputsamples, interlacing_shift, interlacing_leftweight);
                        break;
                    }
                    case 24: {
                        AlacDecodeUtils.deinterlace_24(alac.outputsamples_buffer_a, alac.outputsamples_buffer_b, uncompressed_bytes, alac.uncompressed_bytes_buffer_a, alac.uncompressed_bytes_buffer_b, outbuffer, alac.numchannels, outputsamples, interlacing_shift, interlacing_leftweight);
                        break;
                    }
                    case 20: 
                    case 32: {
                        System.err.println("FIXME: unimplemented sample size " + alac.setinfo_sample_size);
                    }
                }
            }
        }
        return outputsize;
    }

    public static AlacFile create_alac(int samplesize, int numchannels) {
        AlacFile newfile = new AlacFile();
        newfile.samplesize = samplesize;
        newfile.numchannels = numchannels;
        newfile.bytespersample = samplesize / 8 * numchannels;
        return newfile;
    }
}

