/*
 * Decompiled with CFR 0.152.
 */
package com.beatofthedrum.alacdecoder;

import com.beatofthedrum.alacdecoder.AlacContext;
import com.beatofthedrum.alacdecoder.AlacDecodeUtils;
import com.beatofthedrum.alacdecoder.AlacFile;
import com.beatofthedrum.alacdecoder.AlacInputStream;
import com.beatofthedrum.alacdecoder.ChunkInfo;
import com.beatofthedrum.alacdecoder.DemuxResT;
import com.beatofthedrum.alacdecoder.DemuxUtils;
import com.beatofthedrum.alacdecoder.MyStream;
import com.beatofthedrum.alacdecoder.QTMovieT;
import com.beatofthedrum.alacdecoder.SampleDuration;
import com.beatofthedrum.alacdecoder.StreamUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class AlacUtils {
    public static AlacContext AlacOpenFileInput(String inputfilename) {
        AlacInputStream input_stream;
        FileInputStream fistream;
        QTMovieT qtmovie = new QTMovieT();
        DemuxResT demux_res = new DemuxResT();
        AlacContext ac = new AlacContext();
        ac.error = false;
        try {
            fistream = new FileInputStream(inputfilename);
            input_stream = new AlacInputStream(fistream);
        }
        catch (FileNotFoundException fe) {
            ac.error_message = "Input file not found";
            ac.error = true;
            return ac;
        }
        ac.input_stream = input_stream;
        int headerRead = DemuxUtils.qtmovie_read(input_stream, qtmovie, demux_res);
        if (headerRead == 0) {
            ac.error = true;
            if (demux_res.format_read == 0) {
                ac.error_message = "Failed to load the QuickTime movie headers.";
                if (demux_res.format_read != 0) {
                    ac.error_message = ac.error_message + " File type: " + DemuxUtils.SplitFourCC(demux_res.format);
                }
            } else {
                ac.error_message = "Error while loading the QuickTime movie headers.";
            }
            return ac;
        }
        if (headerRead == 3) {
            try {
                ac.input_stream.close();
            }
            catch (IOException ioe) {
                ac.error_message = "Error when seeking to start of music data";
                ac.error = true;
                return ac;
            }
            try {
                fistream = new FileInputStream(inputfilename);
                ac.input_stream = input_stream = new AlacInputStream(fistream);
                qtmovie.qtstream.stream = input_stream;
                qtmovie.qtstream.currentPos = 0;
                StreamUtils.stream_skip(qtmovie.qtstream, qtmovie.saved_mdat_pos);
            }
            catch (FileNotFoundException fe) {
                ac.error_message = "Input file not found";
                ac.error = true;
                return ac;
            }
        }
        AlacFile alac = AlacDecodeUtils.create_alac(demux_res.sample_size, demux_res.num_channels);
        AlacDecodeUtils.alac_set_info(alac, demux_res.codecdata);
        ac.demux_res = demux_res;
        ac.alac = alac;
        return ac;
    }

    public static void AlacCloseFile(AlacContext ac) {
        if (null != ac.input_stream) {
            try {
                ac.input_stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int AlacUnpackSamples(AlacContext ac, int[] pDestBuffer) {
        SampleDuration sampleinfo = new SampleDuration();
        byte[] read_buffer = ac.read_buffer;
        int destBufferSize = 73728;
        MyStream inputStream = new MyStream();
        inputStream.stream = ac.input_stream;
        if (ac.current_sample_block >= ac.demux_res.sample_byte_size.length) {
            return 0;
        }
        if (AlacUtils.get_sample_info(ac.demux_res, ac.current_sample_block, sampleinfo) == 0) {
            return 0;
        }
        int sample_byte_size = sampleinfo.sample_byte_size;
        StreamUtils.stream_read(inputStream, sample_byte_size, read_buffer, 0);
        int outputBytes = destBufferSize;
        outputBytes = AlacDecodeUtils.decode_frame(ac.alac, read_buffer, pDestBuffer, outputBytes);
        ++ac.current_sample_block;
        System.arraycopy(pDestBuffer, ac.offset, pDestBuffer, 0, outputBytes -= ac.offset * AlacUtils.AlacGetBytesPerSample(ac));
        ac.offset = 0;
        return outputBytes;
    }

    public static int AlacGetSampleRate(AlacContext ac) {
        if (null != ac && ac.demux_res.sample_rate != 0) {
            return ac.demux_res.sample_rate;
        }
        return 44100;
    }

    public static int AlacGetNumChannels(AlacContext ac) {
        if (null != ac && ac.demux_res.num_channels != 0) {
            return ac.demux_res.num_channels;
        }
        return 2;
    }

    public static int AlacGetBitsPerSample(AlacContext ac) {
        if (null != ac && ac.demux_res.sample_size != 0) {
            return ac.demux_res.sample_size;
        }
        return 16;
    }

    public static int AlacGetBytesPerSample(AlacContext ac) {
        if (null != ac && ac.demux_res.sample_size != 0) {
            return (int)Math.ceil(ac.demux_res.sample_size / 8);
        }
        return 2;
    }

    public static int AlacGetNumSamples(AlacContext ac) {
        int num_samples = 0;
        int thissample_bytesize = 0;
        SampleDuration sampleinfo = new SampleDuration();
        boolean error_found = false;
        int retval = 0;
        for (int i = 0; i < ac.demux_res.sample_byte_size.length; ++i) {
            int thissample_duration = 0;
            thissample_bytesize = 0;
            retval = AlacUtils.get_sample_info(ac.demux_res, i, sampleinfo);
            if (retval == 0) {
                return -1;
            }
            thissample_duration = sampleinfo.sample_duration;
            thissample_bytesize = sampleinfo.sample_byte_size;
            num_samples += thissample_duration;
        }
        return num_samples;
    }

    static int get_sample_info(DemuxResT demux_res, int samplenum, SampleDuration sampleinfo) {
        int duration_index_accum = 0;
        int duration_cur_index = 0;
        if (samplenum >= demux_res.sample_byte_size.length) {
            System.err.println("sample " + samplenum + " does not exist ");
            return 0;
        }
        if (demux_res.num_time_to_samples == 0) {
            System.err.println("no time to samples");
            return 0;
        }
        while (demux_res.time_to_sample[duration_cur_index].sample_count + duration_index_accum <= samplenum) {
            duration_index_accum += demux_res.time_to_sample[duration_cur_index].sample_count;
            if (++duration_cur_index < demux_res.num_time_to_samples) continue;
            System.err.println("sample " + samplenum + " does not have a duration");
            return 0;
        }
        sampleinfo.sample_duration = demux_res.time_to_sample[duration_cur_index].sample_duration;
        sampleinfo.sample_byte_size = demux_res.sample_byte_size[samplenum];
        return 1;
    }

    public static void AlacSetPosition(AlacContext ac, long position) {
        DemuxResT res = ac.demux_res;
        int current_position = 0;
        int current_sample = 0;
        SampleDuration sample_info = new SampleDuration();
        for (int i = 0; i < res.stsc.length; ++i) {
            ChunkInfo chunkInfo = res.stsc[i];
            int last_chunk = i < res.stsc.length - 1 ? res.stsc[i + 1].first_chunk : res.stco.length;
            for (int chunk = chunkInfo.first_chunk; chunk <= last_chunk; ++chunk) {
                int pos = res.stco[chunk - 1];
                for (int sample_count = chunkInfo.samples_per_chunk; sample_count > 0; --sample_count) {
                    int ret = AlacUtils.get_sample_info(res, current_sample, sample_info);
                    if (ret == 0) {
                        return;
                    }
                    if (position < (long)(current_position += sample_info.sample_duration)) {
                        ac.input_stream.seek(pos);
                        ac.current_sample_block = current_sample;
                        ac.offset = (int)(position - (long)(current_position - sample_info.sample_duration)) * AlacUtils.AlacGetNumChannels(ac);
                        return;
                    }
                    pos += sample_info.sample_byte_size;
                    ++current_sample;
                }
            }
        }
    }
}

