/*
 * Decompiled with CFR 0.152.
 */
package com.beatofthedrum.alacdecoder;

import com.beatofthedrum.alacdecoder.ChunkInfo;
import com.beatofthedrum.alacdecoder.DemuxResT;
import com.beatofthedrum.alacdecoder.MyStream;
import com.beatofthedrum.alacdecoder.QTMovieT;
import com.beatofthedrum.alacdecoder.StreamUtils;
import java.io.DataInputStream;

class DemuxUtils {
    DemuxUtils() {
    }

    public static int MakeFourCC(int ch0, int ch1, int ch2, int ch3) {
        return ch0 << 24 | ch1 << 16 | ch2 << 8 | ch3;
    }

    public static int MakeFourCC32(int ch0, int ch1, int ch2, int ch3) {
        int retval = 0;
        int tmp = ch0;
        retval = tmp << 24;
        tmp = ch1;
        retval |= tmp << 16;
        tmp = ch2;
        retval |= tmp << 8;
        tmp = ch3;
        return retval |= tmp;
    }

    public static String SplitFourCC(int code) {
        char c1 = (char)(code >> 24 & 0xFF);
        char c2 = (char)(code >> 16 & 0xFF);
        char c3 = (char)(code >> 8 & 0xFF);
        char c4 = (char)(code & 0xFF);
        String retstr = c1 + " " + c2 + " " + c3 + " " + c4;
        return retstr;
    }

    public static int qtmovie_read(DataInputStream file, QTMovieT qtmovie, DemuxResT demux_res) {
        int chunk_id;
        boolean found_moov = false;
        boolean found_mdat = false;
        qtmovie.qtstream.stream = file;
        qtmovie.res = demux_res;
        while (true) {
            int chunk_len;
            chunk_id = 0;
            try {
                chunk_len = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            }
            catch (Exception e) {
                System.err.println("(top) error reading chunk_len - possibly number too large");
                chunk_len = 1;
            }
            if (StreamUtils.stream_eof(qtmovie.qtstream) != 0) {
                return 0;
            }
            if (chunk_len == 1) {
                System.err.println("need 64bit support");
                return 0;
            }
            chunk_id = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            if (chunk_id == DemuxUtils.MakeFourCC32(102, 116, 121, 112)) {
                DemuxUtils.read_chunk_ftyp(qtmovie, chunk_len);
                continue;
            }
            if (chunk_id == DemuxUtils.MakeFourCC32(109, 111, 111, 118)) {
                if (DemuxUtils.read_chunk_moov(qtmovie, chunk_len) == 0) {
                    return 0;
                }
                if (found_mdat) {
                    return DemuxUtils.set_saved_mdat(qtmovie);
                }
                found_moov = true;
                continue;
            }
            if (chunk_id == DemuxUtils.MakeFourCC32(109, 100, 97, 116)) {
                int not_found_moov = 0;
                if (!found_moov) {
                    not_found_moov = 1;
                }
                DemuxUtils.read_chunk_mdat(qtmovie, chunk_len, not_found_moov);
                if (found_moov) {
                    return 1;
                }
                found_mdat = true;
                continue;
            }
            if (chunk_id == DemuxUtils.MakeFourCC32(102, 114, 101, 101)) {
                StreamUtils.stream_skip(qtmovie.qtstream, chunk_len - 8);
                continue;
            }
            if (chunk_id != DemuxUtils.MakeFourCC32(106, 117, 110, 107)) break;
            StreamUtils.stream_skip(qtmovie.qtstream, chunk_len - 8);
        }
        System.err.println("(top) unknown chunk id: " + DemuxUtils.SplitFourCC(chunk_id));
        return 0;
    }

    static void read_chunk_ftyp(QTMovieT qtmovie, int chunk_len) {
        int type = 0;
        int minor_ver = 0;
        int size_remaining = chunk_len - 8;
        type = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        size_remaining -= 4;
        if (type != DemuxUtils.MakeFourCC32(77, 52, 65, 32)) {
            System.err.println("not M4A file");
            return;
        }
        minor_ver = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        size_remaining -= 4;
        while (size_remaining != 0) {
            StreamUtils.stream_read_uint32(qtmovie.qtstream);
            size_remaining -= 4;
        }
    }

    static void read_chunk_tkhd(QTMovieT qtmovie, int chunk_len) {
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
    }

    static void read_chunk_mdhd(QTMovieT qtmovie, int chunk_len) {
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
    }

    static void read_chunk_edts(QTMovieT qtmovie, int chunk_len) {
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
    }

    static void read_chunk_elst(QTMovieT qtmovie, int chunk_len) {
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
    }

    static void read_chunk_hdlr(QTMovieT qtmovie, int chunk_len) {
        int comptype = 0;
        int compsubtype = 0;
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        --size_remaining;
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        size_remaining -= 3;
        comptype = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        compsubtype = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        size_remaining -= 8;
        StreamUtils.stream_read_uint32(qtmovie.qtstream);
        size_remaining -= 4;
        StreamUtils.stream_read_uint32(qtmovie.qtstream);
        StreamUtils.stream_read_uint32(qtmovie.qtstream);
        size_remaining -= 8;
        int strlen = StreamUtils.stream_read_uint8(qtmovie.qtstream);
        StreamUtils.stream_skip(qtmovie.qtstream, --size_remaining);
    }

    static int read_chunk_stsd(QTMovieT qtmovie, int chunk_len) {
        int numentries = 0;
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        --size_remaining;
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        size_remaining -= 3;
        try {
            numentries = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        }
        catch (Exception e) {
            System.err.println("(read_chunk_stsd) error reading numentries - possibly number too large");
            numentries = 0;
        }
        size_remaining -= 4;
        if (numentries != 1) {
            System.err.println("only expecting one entry in sample description atom!");
            return 0;
        }
        for (int i = 0; i < numentries; ++i) {
            int entry_size = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            qtmovie.res.format = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            int entry_remaining = entry_size;
            entry_remaining -= 8;
            if (qtmovie.res.format != DemuxUtils.MakeFourCC32(97, 108, 97, 99)) {
                System.err.println("(read_chunk_stsd) error reading description atom - expecting alac, got " + DemuxUtils.SplitFourCC(qtmovie.res.format));
                return 0;
            }
            StreamUtils.stream_skip(qtmovie.qtstream, 6);
            entry_remaining -= 6;
            int version = StreamUtils.stream_read_uint16(qtmovie.qtstream);
            if (version != 1) {
                System.err.println("unknown version??");
            }
            entry_remaining -= 2;
            StreamUtils.stream_read_uint16(qtmovie.qtstream);
            StreamUtils.stream_read_uint32(qtmovie.qtstream);
            entry_remaining -= 6;
            StreamUtils.stream_read_uint16(qtmovie.qtstream);
            entry_remaining -= 2;
            StreamUtils.stream_skip(qtmovie.qtstream, 4);
            entry_remaining -= 4;
            StreamUtils.stream_read_uint16(qtmovie.qtstream);
            StreamUtils.stream_read_uint16(qtmovie.qtstream);
            entry_remaining -= 4;
            StreamUtils.stream_skip(qtmovie.qtstream, 4);
            qtmovie.res.codecdata_len = (entry_remaining -= 4) + 12 + 8;
            if (qtmovie.res.codecdata_len > qtmovie.res.codecdata.length) {
                System.err.println("(read_chunk_stsd) unexpected codec data length read from atom " + qtmovie.res.codecdata_len);
                return 0;
            }
            for (int count = 0; count < qtmovie.res.codecdata_len; ++count) {
                qtmovie.res.codecdata[count] = 0;
            }
            qtmovie.res.codecdata[0] = 0xC000000;
            qtmovie.res.codecdata[1] = DemuxUtils.MakeFourCC(97, 109, 114, 102);
            qtmovie.res.codecdata[2] = DemuxUtils.MakeFourCC(99, 97, 108, 97);
            StreamUtils.stream_read(qtmovie.qtstream, entry_remaining, qtmovie.res.codecdata, 12);
            entry_remaining -= entry_remaining;
            int ptrIndex = 29;
            qtmovie.res.sample_size = qtmovie.res.codecdata[ptrIndex] & 0xFF;
            ptrIndex = 33;
            qtmovie.res.num_channels = qtmovie.res.codecdata[ptrIndex] & 0xFF;
            ptrIndex = 44;
            qtmovie.res.sample_rate = (qtmovie.res.codecdata[ptrIndex] & 0xFF) << 24 | (qtmovie.res.codecdata[ptrIndex + 1] & 0xFF) << 16 | (qtmovie.res.codecdata[ptrIndex + 2] & 0xFF) << 8 | qtmovie.res.codecdata[ptrIndex + 3] & 0xFF;
            if (entry_remaining != 0) {
                StreamUtils.stream_skip(qtmovie.qtstream, entry_remaining);
            }
            qtmovie.res.format_read = 1;
            if (qtmovie.res.format == DemuxUtils.MakeFourCC32(97, 108, 97, 99)) continue;
            return 0;
        }
        return 1;
    }

    static void read_chunk_stts(QTMovieT qtmovie, int chunk_len) {
        int numentries = 0;
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        --size_remaining;
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        size_remaining -= 3;
        try {
            numentries = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        }
        catch (Exception e) {
            System.err.println("(read_chunk_stts) error reading numentries - possibly number too large");
            numentries = 0;
        }
        size_remaining -= 4;
        qtmovie.res.num_time_to_samples = numentries;
        for (int i = 0; i < numentries; ++i) {
            qtmovie.res.time_to_sample[i].sample_count = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            qtmovie.res.time_to_sample[i].sample_duration = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            size_remaining -= 8;
        }
        if (size_remaining != 0) {
            System.err.println("(read_chunk_stts) size remaining?");
            StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
        }
    }

    static void read_chunk_stsz(QTMovieT qtmovie, int chunk_len) {
        int numentries = 0;
        int uniform_size = 0;
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        --size_remaining;
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        StreamUtils.stream_read_uint8(qtmovie.qtstream);
        size_remaining -= 3;
        uniform_size = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        if (uniform_size != 0) {
            int uniform_num = 0;
            uniform_num = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            qtmovie.res.sample_byte_size = new int[uniform_num];
            for (int i = 0; i < uniform_num; ++i) {
                qtmovie.res.sample_byte_size[i] = uniform_size;
            }
            size_remaining -= 4;
            return;
        }
        size_remaining -= 4;
        try {
            numentries = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        }
        catch (Exception e) {
            System.err.println("(read_chunk_stsz) error reading numentries - possibly number too large");
            numentries = 0;
        }
        size_remaining -= 4;
        qtmovie.res.sample_byte_size = new int[numentries];
        for (int i = 0; i < numentries; ++i) {
            qtmovie.res.sample_byte_size[i] = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            size_remaining -= 4;
        }
        if (size_remaining != 0) {
            System.err.println("(read_chunk_stsz) size remaining?");
            StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
        }
    }

    static int read_chunk_stbl(QTMovieT qtmovie, int chunk_len) {
        int sub_chunk_len;
        for (int size_remaining = chunk_len - 8; size_remaining != 0; size_remaining -= sub_chunk_len) {
            int sub_chunk_id = 0;
            try {
                sub_chunk_len = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            }
            catch (Exception e) {
                System.err.println("(read_chunk_stbl) error reading sub_chunk_len - possibly number too large");
                sub_chunk_len = 0;
            }
            if (sub_chunk_len <= 1 || sub_chunk_len > size_remaining) {
                System.err.println("strange size for chunk inside stbl " + sub_chunk_len + " (remaining: " + size_remaining + ")");
                return 0;
            }
            sub_chunk_id = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(115, 116, 115, 100)) {
                if (DemuxUtils.read_chunk_stsd(qtmovie, sub_chunk_len) != 0) continue;
                return 0;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(115, 116, 116, 115)) {
                DemuxUtils.read_chunk_stts(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(115, 116, 115, 122)) {
                DemuxUtils.read_chunk_stsz(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(115, 116, 115, 99)) {
                DemuxUtils.read_chunk_stsc(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(115, 116, 99, 111)) {
                DemuxUtils.read_chunk_stco(qtmovie, sub_chunk_len);
                continue;
            }
            System.err.println("(stbl) unknown chunk id: " + DemuxUtils.SplitFourCC(sub_chunk_id));
            return 0;
        }
        return 1;
    }

    private static void read_chunk_stco(QTMovieT qtmovie, int sub_chunk_len) {
        MyStream stream = qtmovie.qtstream;
        StreamUtils.stream_skip(stream, 4);
        int num_entries = StreamUtils.stream_read_uint32(stream);
        qtmovie.res.stco = new int[num_entries];
        for (int i = 0; i < num_entries; ++i) {
            qtmovie.res.stco[i] = StreamUtils.stream_read_uint32(stream);
        }
    }

    private static void read_chunk_stsc(QTMovieT qtmovie, int sub_chunk_len) {
        MyStream stream = qtmovie.qtstream;
        StreamUtils.stream_skip(stream, 4);
        int num_entries = StreamUtils.stream_read_uint32(stream);
        qtmovie.res.stsc = new ChunkInfo[num_entries];
        for (int i = 0; i < num_entries; ++i) {
            ChunkInfo entry = new ChunkInfo();
            entry.first_chunk = StreamUtils.stream_read_uint32(stream);
            entry.samples_per_chunk = StreamUtils.stream_read_uint32(stream);
            entry.sample_desc_index = StreamUtils.stream_read_uint32(stream);
            qtmovie.res.stsc[i] = entry;
        }
    }

    static int read_chunk_minf(QTMovieT qtmovie, int chunk_len) {
        int stbl_size;
        int dinf_size;
        int media_info_size;
        int size_remaining = chunk_len - 8;
        try {
            media_info_size = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        }
        catch (Exception e) {
            System.err.println("(read_chunk_minf) error reading media_info_size - possibly number too large");
            media_info_size = 0;
        }
        if (media_info_size != 16) {
            System.err.println("unexpected size in media info\n");
            return 0;
        }
        if (StreamUtils.stream_read_uint32(qtmovie.qtstream) != DemuxUtils.MakeFourCC32(115, 109, 104, 100)) {
            System.err.println("not a sound header! can't handle this.");
            return 0;
        }
        StreamUtils.stream_skip(qtmovie.qtstream, 8);
        size_remaining -= 16;
        try {
            dinf_size = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        }
        catch (Exception e) {
            System.err.println("(read_chunk_minf) error reading dinf_size - possibly number too large");
            dinf_size = 0;
        }
        if (StreamUtils.stream_read_uint32(qtmovie.qtstream) != DemuxUtils.MakeFourCC32(100, 105, 110, 102)) {
            System.err.println("expected dinf, didn't get it.");
            return 0;
        }
        StreamUtils.stream_skip(qtmovie.qtstream, dinf_size - 8);
        size_remaining -= dinf_size;
        try {
            stbl_size = StreamUtils.stream_read_uint32(qtmovie.qtstream);
        }
        catch (Exception e) {
            System.err.println("(read_chunk_minf) error reading stbl_size - possibly number too large");
            stbl_size = 0;
        }
        if (StreamUtils.stream_read_uint32(qtmovie.qtstream) != DemuxUtils.MakeFourCC32(115, 116, 98, 108)) {
            System.err.println("expected stbl, didn't get it.");
            return 0;
        }
        if (DemuxUtils.read_chunk_stbl(qtmovie, stbl_size) == 0) {
            return 0;
        }
        if ((size_remaining -= stbl_size) != 0) {
            System.err.println("(read_chunk_minf) - size remaining?");
            StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
        }
        return 1;
    }

    static int read_chunk_mdia(QTMovieT qtmovie, int chunk_len) {
        int sub_chunk_len;
        for (int size_remaining = chunk_len - 8; size_remaining != 0; size_remaining -= sub_chunk_len) {
            int sub_chunk_id = 0;
            try {
                sub_chunk_len = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            }
            catch (Exception e) {
                System.err.println("(read_chunk_mdia) error reading sub_chunk_len - possibly number too large");
                sub_chunk_len = 0;
            }
            if (sub_chunk_len <= 1 || sub_chunk_len > size_remaining) {
                System.err.println("strange size for chunk inside mdia\n");
                return 0;
            }
            sub_chunk_id = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(109, 100, 104, 100)) {
                DemuxUtils.read_chunk_mdhd(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(104, 100, 108, 114)) {
                DemuxUtils.read_chunk_hdlr(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(109, 105, 110, 102)) {
                if (DemuxUtils.read_chunk_minf(qtmovie, sub_chunk_len) != 0) continue;
                return 0;
            }
            System.err.println("(mdia) unknown chunk id: " + DemuxUtils.SplitFourCC(sub_chunk_id));
            return 0;
        }
        return 1;
    }

    static int read_chunk_trak(QTMovieT qtmovie, int chunk_len) {
        int sub_chunk_len;
        for (int size_remaining = chunk_len - 8; size_remaining != 0; size_remaining -= sub_chunk_len) {
            int sub_chunk_id = 0;
            try {
                sub_chunk_len = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            }
            catch (Exception e) {
                System.err.println("(read_chunk_trak) error reading sub_chunk_len - possibly number too large");
                sub_chunk_len = 0;
            }
            if (sub_chunk_len <= 1 || sub_chunk_len > size_remaining) {
                System.err.println("strange size for chunk inside trak");
                return 0;
            }
            sub_chunk_id = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(116, 107, 104, 100)) {
                DemuxUtils.read_chunk_tkhd(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(109, 100, 105, 97)) {
                if (DemuxUtils.read_chunk_mdia(qtmovie, sub_chunk_len) != 0) continue;
                return 0;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(101, 100, 116, 115)) {
                DemuxUtils.read_chunk_edts(qtmovie, sub_chunk_len);
                continue;
            }
            System.err.println("(trak) unknown chunk id: " + DemuxUtils.SplitFourCC(sub_chunk_id));
            return 0;
        }
        return 1;
    }

    static void read_chunk_mvhd(QTMovieT qtmovie, int chunk_len) {
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
    }

    static void read_chunk_udta(QTMovieT qtmovie, int chunk_len) {
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
    }

    static void read_chunk_iods(QTMovieT qtmovie, int chunk_len) {
        int size_remaining = chunk_len - 8;
        StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
    }

    static int read_chunk_moov(QTMovieT qtmovie, int chunk_len) {
        int sub_chunk_len;
        for (int size_remaining = chunk_len - 8; size_remaining != 0; size_remaining -= sub_chunk_len) {
            int sub_chunk_id = 0;
            try {
                sub_chunk_len = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            }
            catch (Exception e) {
                System.err.println("(read_chunk_moov) error reading sub_chunk_len - possibly number too large");
                sub_chunk_len = 0;
            }
            if (sub_chunk_len <= 1 || sub_chunk_len > size_remaining) {
                System.err.println("strange size for chunk inside moov");
                return 0;
            }
            sub_chunk_id = StreamUtils.stream_read_uint32(qtmovie.qtstream);
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(109, 118, 104, 100)) {
                DemuxUtils.read_chunk_mvhd(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(116, 114, 97, 107)) {
                if (DemuxUtils.read_chunk_trak(qtmovie, sub_chunk_len) != 0) continue;
                return 0;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(117, 100, 116, 97)) {
                DemuxUtils.read_chunk_udta(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(101, 108, 115, 116)) {
                DemuxUtils.read_chunk_elst(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(105, 111, 100, 115)) {
                DemuxUtils.read_chunk_iods(qtmovie, sub_chunk_len);
                continue;
            }
            if (sub_chunk_id == DemuxUtils.MakeFourCC32(102, 114, 101, 101)) {
                StreamUtils.stream_skip(qtmovie.qtstream, sub_chunk_len - 8);
                continue;
            }
            System.err.println("(moov) unknown chunk id: " + DemuxUtils.SplitFourCC(sub_chunk_id));
            return 0;
        }
        return 1;
    }

    static void read_chunk_mdat(QTMovieT qtmovie, int chunk_len, int skip_mdat) {
        int size_remaining = chunk_len - 8;
        if (size_remaining == 0) {
            return;
        }
        qtmovie.res.mdat_len = size_remaining;
        if (skip_mdat != 0) {
            qtmovie.saved_mdat_pos = StreamUtils.stream_tell(qtmovie.qtstream);
            StreamUtils.stream_skip(qtmovie.qtstream, size_remaining);
        }
    }

    static int set_saved_mdat(QTMovieT qtmovie) {
        if (qtmovie.saved_mdat_pos == -1) {
            System.err.println("stream contains mdat before moov but is not seekable");
            return 2;
        }
        if (StreamUtils.stream_setpos(qtmovie.qtstream, qtmovie.saved_mdat_pos) != 0) {
            return 3;
        }
        return 1;
    }
}

