/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox;

import java.io.File;

public class FilesystemObject {
    private FilesystemObject parent;
    private File file;
    private boolean isDirectory;
    private boolean isPlaylist = false;
    private String name;
    private String path;
    private String icon;

    public FilesystemObject(FilesystemObject parent, File file) {
        this.parent = parent;
        this.file = file;
        this.isDirectory = file.isDirectory();
        this.name = file.getName();
        this.path = file.getPath();
        if (this.name.equals("")) {
            this.name = file.getPath();
        }
        if (file.isDirectory()) {
            this.icon = "textures/item/book.png";
        } else if (this.name.toLowerCase().endsWith(".mp3") || this.name.toLowerCase().endsWith(".ogg") || this.name.toLowerCase().endsWith(".wav") || this.name.toLowerCase().endsWith(".m4a") || this.name.toLowerCase().endsWith(".flac") || this.name.toLowerCase().endsWith(".mid") || this.name.toLowerCase().endsWith(".midi")) {
            this.icon = "textures/item/music_disc_chirp.png";
        } else {
            this.icon = "textures/item/writable_book.png";
            this.isPlaylist = true;
        }
    }

    public FilesystemObject(String name, String icon) {
        this.name = name;
        this.path = name;
        this.icon = icon;
        this.isDirectory = true;
        this.file = new File("");
    }

    public FilesystemObject getParent() {
        return this.parent;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isPlaylist() {
        return this.isPlaylist;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getIcon() {
        return this.icon;
    }
}

