/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mamiyaotaru.jukebox.FilesystemObject;
import com.mamiyaotaru.jukebox.ModConfigJukebox;
import com.mamiyaotaru.jukebox.core.IJukeboxCore;
import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.Player;
import com.mamiyaotaru.jukebox.ui.GuiJukebox;
import com.mamiyaotaru.jukebox.utils.I18nUtils;
import com.mamiyaotaru.jukebox.utils.ReflectionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_437;

public class Jukebox
implements Observer,
IJukeboxCore {
    private class_310 mc;
    public Player player;
    private Notifier notifier;
    private Message message;
    public ModConfigJukebox options;
    private HashSet<File> rootFiles;
    public FilesystemObject root;
    public ArrayList<FilesystemObject> roots = new ArrayList();
    public FilesystemObject currentDirectory;
    private ArrayList<FilesystemObject> currentDirContents;
    private ArrayList<FilesystemObject> playableDirContents;
    public FilesystemObject currentlyPlaying;
    public int currentlyPlayingIndex;
    private int volume = 100;
    private int progress = 0;
    private String osdMessage = null;
    private boolean showHidden;
    private HashSet<String> supportedExtensions;
    private boolean debug = false;

    public Jukebox(ModConfigJukebox options) {
        this.mc = class_310.method_1551();
        this.notifier = new Notifier();
        this.message = new Message(0, "", 0);
        this.player = new Player(this, this.notifier, this.message);
        this.notifier.addObserver(this);
        this.options = options;
        this.supportedExtensions = new HashSet();
        this.supportedExtensions.add("mp3");
        this.supportedExtensions.add("ogg");
        this.supportedExtensions.add("wav");
        this.supportedExtensions.add("m4a");
        this.supportedExtensions.add("flac");
        MidiDevice.Info[] devices = MidiSystem.getMidiDeviceInfo();
        if (devices.length == 0) {
            System.out.println("No MIDI devices found");
        } else {
            this.supportedExtensions.add("mid");
            this.supportedExtensions.add("midi");
        }
        ArrayList<class_304> tempBindings = new ArrayList<class_304>();
        tempBindings.addAll(Arrays.asList(this.mc.field_1690.field_1839));
        tempBindings.addAll(Arrays.asList(options.keyBindings));
        Field f = ReflectionUtils.getFieldByType(this.mc.field_1690, class_315.class, class_304[].class, 1);
        try {
            f.set(this.mc.field_1690, tempBindings.toArray(new class_304[tempBindings.size()]));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        Map categoryOrder = (Map)ReflectionUtils.getPrivateFieldValueByType(null, class_304.class, Map.class, 1);
        System.out.println("CATEGORY ORDER IS " + categoryOrder.size());
        Integer categoryPlace = (Integer)categoryOrder.get("jukebox.root");
        if (categoryPlace == null) {
            int currentSize = categoryOrder.size();
            categoryOrder.put("jukebox.title", currentSize + 1);
        }
        this.root = new FilesystemObject(I18nUtils.getString("jukebox.root"), "textures/item/chest_minecart.png");
        this.rootFiles = new HashSet();
        String userHomeFolder = System.getProperty("user.home");
        File homeDir = new File(userHomeFolder);
        File desktopDir = new File(homeDir, "/Desktop");
        this.rootFiles.add(desktopDir);
        FilesystemObject desktopObject = new FilesystemObject(this.root, desktopDir);
        desktopObject.setIcon("textures/item/filled_map.png");
        desktopObject.setName(I18nUtils.getString("jukebox.desktop"));
        this.roots.add(desktopObject);
        this.rootFiles.add(homeDir);
        FilesystemObject homeObject = new FilesystemObject(this.root, homeDir);
        homeObject.setName(homeObject.getName() + " - " + I18nUtils.getString("jukebox.home"));
        this.roots.add(homeObject);
        String version = "1.14";
        File indexDir = new File(class_310.method_1551().field_1697.getAbsoluteFile(), "/assets/indexes/");
        File mcPlaylist = null;
        if (indexDir.exists() && indexDir.isDirectory() && indexDir.canRead()) {
            File[] contents = indexDir.listFiles();
            for (File entry : contents) {
                if (!entry.getName().startsWith(version) || !entry.getName().endsWith(".json")) continue;
                mcPlaylist = entry;
            }
        }
        if (mcPlaylist != null) {
            FilesystemObject mcPlaylistObject = new FilesystemObject(this.root, mcPlaylist);
            mcPlaylistObject.setName(I18nUtils.getString("jukebox.minecraftmusic"));
            this.roots.add(mcPlaylistObject);
        }
        ArrayList<File> drives = new ArrayList<File>(Arrays.asList(File.listRoots()));
        for (File drive : drives) {
            if (!drive.isDirectory()) continue;
            System.out.println("drive: " + drive.getPath());
            if (!this.rootFiles.add(drive)) continue;
            FilesystemObject rootObject = new FilesystemObject(this.root, drive);
            rootObject.setIcon("textures/item/minecart.png");
            this.roots.add(rootObject);
        }
        if (options.directory == null || options.directory.equals(this.root.getPath())) {
            this.currentDirectory = this.root;
        } else {
            File target = new File(options.directory);
            FilesystemObject targetObject = null;
            if (target.exists()) {
                for (FilesystemObject rootObject : this.roots) {
                    if (!target.equals(rootObject.getFile())) continue;
                    targetObject = rootObject;
                }
                if (targetObject == null) {
                    targetObject = this.createTargetObject(target);
                }
            }
            this.currentDirectory = targetObject != null ? targetObject : this.root;
        }
        this.openFile(this.currentDirectory);
    }

    private FilesystemObject createTargetObject(File target) {
        File parent;
        if (this.debug) {
            System.out.println("getting object for file: " + target.getPath());
        }
        if ((parent = target.getParentFile()) != null && parent.exists() && parent.canRead()) {
            if (this.debug) {
                System.out.println("parent is file: " + parent.getPath());
            }
            for (FilesystemObject rootObject : this.roots) {
                if (this.debug) {
                    System.out.println("checking root: " + rootObject.getFile().getPath());
                }
                if (!parent.equals(rootObject.getFile())) continue;
                if (this.debug) {
                    System.out.println("match!!");
                }
                return new FilesystemObject(rootObject, target);
            }
            if (this.debug) {
                System.out.println("no match, recursing upwards");
            }
            FilesystemObject parentObject = this.createTargetObject(parent);
            return new FilesystemObject(parentObject, target);
        }
        if (this.debug) {
            System.out.println("no parent! bailing!!");
        }
        return null;
    }

    public void onTick() {
        if (this.volume != this.options.volume) {
            this.player.setVolume(this.options.volume);
        }
        this.volume = this.options.volume;
        if (this.progress != this.options.progress) {
            this.player.setPosition(this.options.progress);
        }
        this.progress = this.options.progress;
        if (this.showHidden != this.options.showHidden) {
            this.openDir(this.currentDirectory);
        }
        this.showHidden = this.options.showHidden;
        if (this.options.keyBindMenu.method_1436() && this.mc.field_1755 == null) {
            this.options.realScale = this.mc.field_1690.field_1868;
            this.options.saveAll();
            this.mc.method_1507((class_437)new GuiJukebox(this.mc.field_1755, this));
        }
        if (this.options.keyBindPlayPause.method_1436()) {
            this.action(113);
        }
        if (this.options.keyBindNext.method_1436()) {
            this.action(115);
        }
        if (this.options.keyBindPrevious.method_1436()) {
            this.action(114);
        }
        if (this.options.keyBindVolumeUp.method_1436()) {
            this.options.volume = Math.min(100, this.options.volume + 10);
            if (this.options.osd) {
                this.mc.field_1724.method_7353((class_2561)new class_2585("\u266c " + I18nUtils.getString("jukebox.volume") + ": " + this.options.volume + "%"), true);
            }
        }
        if (this.options.keyBindVolumeDown.method_1436()) {
            this.options.volume = Math.max(0, this.options.volume - 10);
            if (this.options.osd) {
                this.mc.field_1724.method_7353((class_2561)new class_2585("\u266c " + I18nUtils.getString("jukebox.volume") + ": " + this.options.volume + "%"), true);
            }
        }
        if (this.osdMessage != null) {
            this.mc.field_1724.method_7353((class_2561)new class_2585(this.osdMessage), true);
            this.osdMessage = null;
        }
    }

    public void openFile(FilesystemObject filesystemObject) {
        if (filesystemObject.isDirectory()) {
            this.openDir(filesystemObject);
            this.setPlayableContents();
            this.options.directory = this.currentDirectory.getPath();
            if (this.currentlyPlaying != null && this.currentlyPlaying.getParent().getFile().equals(this.currentDirectory.getFile())) {
                for (FilesystemObject object : this.currentDirContents) {
                    if (this.currentlyPlaying == null || !object.getFile().equals(this.currentlyPlaying.getFile())) continue;
                    this.currentlyPlaying = object;
                }
                this.currentlyPlayingIndex = this.getSelectedIndex();
            } else {
                this.currentlyPlayingIndex = -1;
            }
        } else if (filesystemObject.isPlaylist()) {
            this.openPlaylist(filesystemObject);
            this.setPlayableContents();
            this.options.directory = this.currentDirectory.getPath();
            if (this.currentlyPlaying != null && this.currentlyPlaying.getParent().getFile().equals(this.currentDirectory.getFile())) {
                for (FilesystemObject object : this.currentDirContents) {
                    if (this.currentlyPlaying == null || !object.getFile().equals(this.currentlyPlaying.getFile())) continue;
                    this.currentlyPlaying = object;
                }
                this.currentlyPlayingIndex = this.getSelectedIndex();
            } else {
                this.currentlyPlayingIndex = -1;
            }
        } else {
            this.currentlyPlaying = filesystemObject;
            this.currentlyPlayingIndex = this.currentlyPlaying != null && this.currentlyPlaying.getParent().getFile().equals(this.currentDirectory.getFile()) ? this.getSelectedIndex() : -1;
            if (this.getSelectedIndexOutOfPlayable() == -1) {
                System.out.println("something broke");
                System.out.println("attempting to play " + this.currentlyPlaying.getPath());
                System.out.println("core in directory " + this.currentDirectory.getPath());
                System.out.println();
            } else {
                this.player.setSelectedIndex(this.getSelectedIndexOutOfPlayable());
            }
        }
    }

    private void openDir(final FilesystemObject dir) {
        if (dir == this.root) {
            this.currentDirectory = dir;
            this.currentDirContents = this.roots;
        } else {
            File[] children = dir.getFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (!Jukebox.this.options.showHidden && file.isHidden()) {
                        return false;
                    }
                    if (!file.canRead()) {
                        return false;
                    }
                    if (file.getName().startsWith("._")) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (Jukebox.this.isPlayable(file)) {
                        return true;
                    }
                    return Jukebox.this.isPlaylist(file);
                }
            });
            if (children == null) {
                return;
            }
            this.currentDirectory = dir;
            this.currentDirContents = new ArrayList();
            final FilesystemObject parent = dir.getParent();
            this.currentDirContents.add(parent);
            this.currentDirContents.add(dir);
            for (File child : children) {
                FilesystemObject newObject = new FilesystemObject(dir, child);
                this.currentDirContents.add(newObject);
            }
            final Collator collator = I18nUtils.getLocaleAwareCollator();
            boolean order = true;
            Collections.sort(this.currentDirContents, new Comparator<FilesystemObject>(){

                @Override
                public int compare(FilesystemObject object1, FilesystemObject object2) {
                    if (object1.equals(parent)) {
                        return -1;
                    }
                    if (object2.equals(parent)) {
                        return 1;
                    }
                    if (object1.equals(dir)) {
                        return -1;
                    }
                    if (object2.equals(dir)) {
                        return 1;
                    }
                    if (object1.isDirectory() && !object2.isDirectory()) {
                        return -1;
                    }
                    if (!object1.isDirectory() && object2.isDirectory()) {
                        return 1;
                    }
                    return collator.compare(object1.getName(), object2.getName()) * 1;
                }
            });
        }
    }

    private boolean isPlayable(File file) {
        return this.isPlayable(file.getName());
    }

    private boolean isPlayable(String filename) {
        filename = filename.toLowerCase();
        String extension = "";
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            extension = filename.substring(i + 1);
        }
        return this.getSupportedExtensions().contains(extension);
    }

    private boolean isPlaylist(File file) {
        if (file.getName().toLowerCase().endsWith(".m3u")) {
            return true;
        }
        return file.getName().toLowerCase().endsWith(".pls");
    }

    private void openPlaylist(final FilesystemObject dir) {
        FilesystemObject rootDir;
        this.currentDirContents = new ArrayList();
        this.currentDirectory = dir;
        final FilesystemObject parent = dir.getParent();
        this.currentDirContents.add(parent);
        this.currentDirContents.add(dir);
        for (rootDir = parent; rootDir != this.root && rootDir.getParent() != this.root; rootDir = rootDir.getParent()) {
        }
        File playlistFile = dir.getFile();
        boolean isM3u = playlistFile.getName().toLowerCase().endsWith(".m3u");
        boolean isPls = playlistFile.getName().toLowerCase().endsWith(".pls");
        boolean isJson = playlistFile.getName().toLowerCase().endsWith(".json");
        try {
            if (playlistFile.exists()) {
                BufferedReader in = new BufferedReader(new FileReader(playlistFile));
                if (isM3u || isPls) {
                    String sCurrentLine;
                    while ((sCurrentLine = in.readLine()) != null) {
                        String filePathOrName = null;
                        if (isM3u && !sCurrentLine.startsWith("#")) {
                            filePathOrName = sCurrentLine;
                        } else if (isPls && sCurrentLine.toLowerCase().startsWith("file")) {
                            filePathOrName = sCurrentLine.replaceFirst("^[Ff][Ii][Ll][Ee]\\d+=", "");
                        }
                        if (filePathOrName == null || !this.isPlayable(filePathOrName)) continue;
                        File possibleFile = new File(filePathOrName);
                        if (!possibleFile.exists()) {
                            possibleFile = new File(dir.getParent().getFile(), filePathOrName);
                        }
                        if (!possibleFile.exists()) {
                            possibleFile = new File(rootDir.getFile(), filePathOrName);
                        }
                        if (!possibleFile.exists()) continue;
                        FilesystemObject entry = new FilesystemObject(dir, possibleFile);
                        this.currentDirContents.add(entry);
                    }
                } else if (isJson) {
                    File resourceDir = new File(this.mc.field_1697.getAbsoluteFile(), "/assets/objects/");
                    JsonObject playlistJson = new JsonParser().parse((Reader)in).getAsJsonObject();
                    JsonObject objectsObject = playlistJson.get("objects").getAsJsonObject();
                    Set entries = objectsObject.entrySet();
                    for (Map.Entry entry : entries) {
                        String name = (String)entry.getKey();
                        if (!name.contains("music") && !name.contains("records")) continue;
                        JsonObject musicPiece = ((JsonElement)entry.getValue()).getAsJsonObject();
                        String hash = musicPiece.get("hash").getAsString();
                        File containingDir = new File(resourceDir, hash.substring(0, 2));
                        File resourceFile = new File(containingDir, hash + ".ogg");
                        FilesystemObject resourceObject = new FilesystemObject(dir, resourceFile);
                        resourceObject.setName(name);
                        this.currentDirContents.add(resourceObject);
                    }
                    final Collator collator = I18nUtils.getLocaleAwareCollator();
                    boolean order = true;
                    Collections.sort(this.currentDirContents, new Comparator<FilesystemObject>(){

                        @Override
                        public int compare(FilesystemObject object1, FilesystemObject object2) {
                            if (object1.equals(parent)) {
                                return -1;
                            }
                            if (object2.equals(parent)) {
                                return 1;
                            }
                            if (object1.equals(dir)) {
                                return -1;
                            }
                            if (object2.equals(dir)) {
                                return 1;
                            }
                            if (object1.isDirectory() && !object2.isDirectory()) {
                                return -1;
                            }
                            if (!object1.isDirectory() && object2.isDirectory()) {
                                return 1;
                            }
                            return collator.compare(object1.getName(), object2.getName()) * 1;
                        }
                    });
                }
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setPlayableContents() {
        this.playableDirContents = new ArrayList();
        for (FilesystemObject entry : this.currentDirContents) {
            if (entry.isDirectory() || entry.isPlaylist()) continue;
            this.playableDirContents.add(entry);
        }
    }

    public ArrayList<FilesystemObject> getCurrentDirectoryContents() {
        return this.currentDirContents;
    }

    public FilesystemObject getSelected() {
        return this.currentlyPlaying;
    }

    public int getSelectedIndex() {
        return this.currentDirContents.indexOf(this.currentlyPlaying);
    }

    public int getSelectedIndexOutOfPlayable() {
        return this.playableDirContents.indexOf(this.currentlyPlaying);
    }

    @Override
    public void update(Observable o, Object message) {
        this.updateHelper(o, message);
    }

    public void updateHelper(Observable o, Object message) {
        int intArg = ((Message)message).getIntArg();
        switch (((Message)message).getCommand()) {
            case 1: {
                this.options.reportedProgress = intArg;
                break;
            }
            case 6: {
                FilesystemObject newSong = this.getCurrentlyPlayingAsObject(this.player.getPlayingFile());
                if (this.options.osd && !newSong.equals(this.currentlyPlaying) && !(this.mc.field_1755 instanceof GuiJukebox) && this.mc.field_1724 != null) {
                    this.osdMessage = "\u266c " + I18nUtils.getString("jukebox.nowplaying") + ": " + newSong.getName();
                }
                this.currentlyPlaying = newSong;
                break;
            }
            case 4: {
                this.player.next();
                break;
            }
        }
    }

    private FilesystemObject getCurrentlyPlayingAsObject(File file) {
        for (FilesystemObject child : this.currentDirContents) {
            if (child.getFile() == null || file == null || !child.getFile().equals(file)) continue;
            return child;
        }
        return new FilesystemObject(this.currentDirectory, file);
    }

    public void action(int id) {
        this.player.action(id);
    }

    @Override
    public File getDirectory() {
        return this.currentDirectory == null ? null : this.currentDirectory.getFile();
    }

    @Override
    public File getFile(int currentFileIndex) {
        return this.playableDirContents == null ? null : this.playableDirContents.get(currentFileIndex).getFile();
    }

    @Override
    public int getFilesLength() {
        return this.playableDirContents == null ? 0 : this.playableDirContents.size();
    }

    @Override
    public String getFilePath(int index) {
        String path = "";
        try {
            path = this.playableDirContents.get(index).getFile().getPath();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return path;
    }

    @Override
    public HashSet<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }
}

