/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox;

import com.mamiyaotaru.jukebox.ui.overridden.EnumOptionsJukebox;
import com.mamiyaotaru.jukebox.utils.I18nUtils;
import com.mamiyaotaru.jukebox.utils.ReflectionUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class ModConfigJukebox {
    public class_310 game;
    public class_304 keyBindMenu = new class_304("key.jukebox.jukeboxmenu", class_3675.method_15981((String)"key.keyboard.j").method_1444(), "jukebox.title");
    public class_304 keyBindPlayPause = new class_304("key.jukebox.playpause", class_3675.method_15981((String)"key.keyboard.p").method_1444(), "jukebox.title");
    public class_304 keyBindNext = new class_304("key.jukebox.next", class_3675.method_15981((String)"key.keyboard.right.bracket").method_1444(), "jukebox.title");
    public class_304 keyBindPrevious = new class_304("key.jukebox.previous", class_3675.method_15981((String)"key.keyboard.left.bracket").method_1444(), "jukebox.title");
    public class_304 keyBindVolumeUp = new class_304("key.jukebox.volumeup", class_3675.method_15981((String)"key.keyboard.equal").method_1444(), "jukebox.title");
    public class_304 keyBindVolumeDown = new class_304("key.jukebox.volumedown", class_3675.method_15981((String)"key.keyboard.minus").method_1444(), "jukebox.title");
    public class_304[] keyBindings;
    public final int SORT_DATE = 1;
    public final int SORT_NAME = 2;
    public final int SORT_DISTANCE = 3;
    public final int SORT_COLOR = 4;
    public int sort = 1;
    public int volume = 100;
    public int progress = 0;
    public int reportedProgress = 0;
    public String directory = null;
    public int realScale = -1;
    public boolean osd = true;
    public boolean showHidden = false;

    public ModConfigJukebox() {
        this.game = class_310.method_1551();
        this.keyBindings = new class_304[]{this.keyBindMenu, this.keyBindPrevious, this.keyBindPlayPause, this.keyBindNext, this.keyBindVolumeUp, this.keyBindVolumeDown};
        String keyCategory = "jukebox.title";
        Map categoryOrder = (Map)ReflectionUtils.getPrivateFieldValueByType(null, class_304.class, Map.class, 2);
        System.out.println("CATEGORY ORDER IS " + categoryOrder.size());
        Integer categoryPlace = (Integer)categoryOrder.get(keyCategory);
        if (categoryPlace == null) {
            int currentSize = categoryOrder.size();
            categoryOrder.put(keyCategory, currentSize + 1);
        }
    }

    public void loadAll() {
        File settingsFile = new File(this.game.field_1697, "mods/mamiyaotaru/jukebox.properties");
        try {
            if (settingsFile.exists()) {
                String sCurrentLine;
                BufferedReader in = new BufferedReader(new FileReader(settingsFile));
                while ((sCurrentLine = in.readLine()) != null) {
                    String[] curLine = sCurrentLine.split("=");
                    if (curLine[0].equals("Current Directory")) {
                        this.directory = curLine[1];
                    } else if (curLine[0].equals("Volume")) {
                        this.volume = Integer.parseInt(curLine[1]);
                    } else if (curLine[0].equals("On Screen Display")) {
                        this.osd = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("Show Hidden Files")) {
                        this.showHidden = Boolean.parseBoolean(curLine[1]);
                    } else if (curLine[0].equals("UI Scale")) {
                        this.realScale = Integer.parseInt(curLine[1]);
                    } else if (curLine[0].equals("Menu Key")) {
                        this.bindKey(this.keyBindMenu, curLine[1]);
                    } else if (curLine[0].equals("Plase/Pause Key")) {
                        this.bindKey(this.keyBindPlayPause, curLine[1]);
                    } else if (curLine[0].equals("Next Key")) {
                        this.bindKey(this.keyBindNext, curLine[1]);
                    } else if (curLine[0].equals("Previous Key")) {
                        this.bindKey(this.keyBindPrevious, curLine[1]);
                    } else if (curLine[0].equals("Volume Up Key")) {
                        this.bindKey(this.keyBindVolumeUp, curLine[1]);
                    } else if (curLine[0].equals("Volume Down Key")) {
                        this.bindKey(this.keyBindVolumeDown, curLine[1]);
                    }
                    class_304.method_1426();
                }
                in.close();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void bindKey(class_304 keyBinding, String id) {
        try {
            keyBinding.method_1422(class_3675.method_15981((String)id));
        }
        catch (Exception e) {
            System.err.println(id + " is not a valid keybinding");
        }
    }

    public void saveAll() {
        File settingsFileDir = new File(this.game.field_1697, "mods/mamiyaotaru/");
        if (!settingsFileDir.exists()) {
            settingsFileDir.mkdirs();
        }
        File settingsFile = new File(this.game.field_1697, "mods/mamiyaotaru/jukebox.properties");
        try {
            PrintWriter out = new PrintWriter(new FileWriter(settingsFile));
            out.println("Current Directory=" + this.directory);
            out.println("Volume=" + Integer.toString(this.volume));
            out.println("On Screen Display=" + Boolean.toString(this.osd));
            out.println("Show Hidden Files=" + Boolean.toString(this.showHidden));
            out.println("UI Scale=" + Integer.toString(this.realScale));
            out.println("Menu Key=" + this.keyBindMenu.method_1428());
            out.println("Play/Pause Key=" + this.keyBindPlayPause.method_1428());
            out.println("Next Key=" + this.keyBindNext.method_1428());
            out.println("Previous Key=" + this.keyBindPrevious.method_1428());
            out.println("Volume Up Key=" + this.keyBindVolumeUp.method_1428());
            out.println("Volume Down Key=" + this.keyBindVolumeDown.method_1428());
            out.close();
        }
        catch (Exception local) {
            class_310.method_1551().field_1724.method_7353((class_2561)new class_2585("\u00a7EError Saving Settings " + local.getLocalizedMessage()), false);
        }
    }

    public void setSort(int sort) {
        this.sort = sort == this.sort || sort == -this.sort ? -this.sort : sort;
    }

    public String getKeyText(EnumOptionsJukebox par1EnumOptions) {
        String s = I18nUtils.getString(par1EnumOptions.getEnumString()) + ": ";
        if (par1EnumOptions.getEnumFloat()) {
            float f = this.getOptionFloatValue(par1EnumOptions);
            if (par1EnumOptions == EnumOptionsJukebox.VOLUME) {
                return s + (int)f + "%";
            }
            if (par1EnumOptions == EnumOptionsJukebox.PROGRESS) {
                return s + (int)f + "%";
            }
        }
        if (par1EnumOptions.getEnumBoolean()) {
            boolean flag = this.getOptionBooleanValue(par1EnumOptions);
            if (flag) {
                return s + I18nUtils.getString("options.on");
            }
            return s + I18nUtils.getString("options.off");
        }
        return s;
    }

    public float getOptionFloatValue(EnumOptionsJukebox par1EnumOptions) {
        if (par1EnumOptions == EnumOptionsJukebox.VOLUME) {
            return this.volume;
        }
        if (par1EnumOptions == EnumOptionsJukebox.PROGRESS) {
            return this.reportedProgress;
        }
        return 0.0f;
    }

    public boolean getOptionBooleanValue(EnumOptionsJukebox par1EnumOptions) {
        switch (par1EnumOptions) {
            case OSD: {
                return this.osd;
            }
            case SHOWHIDDEN: {
                return this.showHidden;
            }
        }
        throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getEnumString() + ". (possibly not a boolean)");
    }

    public void setOptionFloatValue(EnumOptionsJukebox par1EnumOptions, float par2) {
        if (par1EnumOptions == EnumOptionsJukebox.VOLUME) {
            float distance = par2 * 100.0f;
            this.volume = (int)distance;
        } else if (par1EnumOptions == EnumOptionsJukebox.PROGRESS) {
            float distance = par2 * 100.0f;
            this.progress = (int)distance;
        }
    }

    public void setProgress(int intArg) {
        this.progress = intArg;
    }

    public void setOptionValue(EnumOptionsJukebox par1EnumOptions, int i) {
        switch (par1EnumOptions) {
            case OSD: {
                this.osd = !this.osd;
                break;
            }
            case SHOWHIDDEN: {
                this.showHidden = !this.showHidden;
                break;
            }
            default: {
                throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getEnumString());
            }
        }
    }

    public String getKeyBindingDescription(int par1) {
        if (this.keyBindings[par1].method_1431().equals("key.jukebox.jukeboxmenu")) {
            return I18nUtils.getString("key.jukebox.menu");
        }
        return I18nUtils.getString(this.keyBindings[par1].method_1431());
    }

    public String getOptionDisplayString(int keybindIndex) {
        class_304 keyBinding = this.keyBindings[keybindIndex];
        return this.getKeybindDisplayString(keyBinding);
    }

    public String getKeybindDisplayString(class_304 keyBinding) {
        return keyBinding.method_16007();
    }

    public void setKeyBinding(class_304 keyBinding, class_3675.class_306 input) {
        keyBinding.method_1422(input);
        this.saveAll();
    }
}

