/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core;

import com.mamiyaotaru.jukebox.PreviousInstanceException;
import com.mamiyaotaru.jukebox.core.IJukeboxCore;
import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.Player;
import com.mamiyaotaru.jukebox.core.SocketManager;
import com.mamiyaotaru.jukebox.resources.ResourceAnchor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;

public class Core
implements Observer,
IJukeboxCore {
    private SocketManager socketManager;
    private Player player;
    private Notifier notifier;
    private Message message;
    private Vector<String> recentMetaDirectories;
    private File metaDirectory;
    private File directory;
    private File[] files;
    private SourceDataLine dummyLine;
    private Properties properties;
    private Comparator<File> fileComparator;
    private HashSet<String> supportedExtensions = new HashSet();

    public Core(String[] args) throws PreviousInstanceException {
        this.supportedExtensions.add("mp3");
        this.supportedExtensions.add("ogg");
        this.supportedExtensions.add("wav");
        this.supportedExtensions.add("m4a");
        this.supportedExtensions.add("flac");
        MidiDevice.Info[] devices = MidiSystem.getMidiDeviceInfo();
        if (devices.length == 0) {
            System.out.println("No MIDI devices found");
        } else {
            this.supportedExtensions.add("mid");
            this.supportedExtensions.add("midi");
        }
        this.notifier = new Notifier();
        this.message = new Message(0, "", 0);
        this.notifier.addObserver(this);
        this.recentMetaDirectories = new Vector(4);
        String localeString = "en_US";
        String[] bits = localeString.split("_");
        Locale locale = new Locale(bits[0], bits.length > 1 ? bits[1] : "");
        final Collator collator = Collator.getInstance(locale);
        this.fileComparator = new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                return collator.compare(a.getName(), b.getName());
            }
        };
        this.loadProperties();
        this.loadStartDirectories();
        this.player = new Player(this, this.notifier, this.message);
        if (args.length > 0) {
            this.openFile(args[0]);
        }
    }

    private void loadProperties() {
        FileInputStream in = null;
        Properties defaultProperties = new Properties();
        try {
            ClassLoader cl = ResourceAnchor.class.getClassLoader();
            defaultProperties.load(cl.getResourceAsStream("mamiyaotaru/jukebox/resources/default.properties"));
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.properties = new Properties(defaultProperties);
        try {
            in = new FileInputStream("jjj.properties");
            this.properties.load(in);
            in.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadStartDirectories() {
        try {
            this.parseRecentMetaDirectories(this.properties.getProperty("recentMetaDirectories"));
            String metaDirectoryName = this.properties.getProperty("metaDirectory");
            this.setMetaDirectory(metaDirectoryName);
            String directoryName = this.properties.getProperty("directory");
            this.setDirectory(directoryName);
        }
        catch (Exception e) {
            try {
                String home = (String)System.getProperties().get("user.home");
                this.setMetaDirectory(home);
                this.setDirectory(home);
            }
            catch (FileNotFoundException ee) {
                System.out.println("no home directory: you are screwed");
            }
        }
    }

    private void parseRecentMetaDirectories(String parseIt) {
        int begin = 0;
        int end = parseIt.indexOf("#");
        String dir = null;
        while (true) {
            dir = null;
            dir = end == -1 ? parseIt.substring(begin) : parseIt.substring(begin, end);
            File directory = new File(dir);
            if (directory.isDirectory()) {
                this.recentMetaDirectories.add(dir);
            }
            if (end == -1) break;
            begin = end + 1;
            end = parseIt.indexOf("#", begin);
        }
    }

    private void openDummyLine() {
        this.dummyLine = null;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, null);
        try {
            this.dummyLine = (SourceDataLine)AudioSystem.getLine(info);
            this.dummyLine.open(null);
            this.dummyLine.start();
        }
        catch (Exception e) {
            System.out.println("dummy line creation error: " + e.getMessage());
        }
    }

    public void shutdownInitiation() {
        System.out.println("core gets message to start shutdown");
        if (this.notifier.countObservers() == 1) {
            this.shutdown();
        } else {
            Message message = new Message(0, "", 0);
            message.setCommand(10);
            this.notifier.sendMessage(message);
        }
    }

    public void shutdown() {
        System.out.println("core gonna exit for real");
        if (this.notifier.countObservers() == 1) {
            this.notifier.deleteObserver(this);
            this.player.stopPlayback();
            this.properties.setProperty("directory", this.directory.getPath());
            this.properties.setProperty("metaDirectory", this.metaDirectory.getPath());
            this.properties.setProperty("recentMetaDirectories", this.storeRecentMetaDirectories());
            this.saveProperties();
            this.message = null;
            System.exit(0);
        }
    }

    private String storeRecentMetaDirectories() {
        String recentDirs = "";
        for (int t = 0; t < this.recentMetaDirectories.size(); ++t) {
            recentDirs = recentDirs + this.recentMetaDirectories.elementAt(t) + "#";
        }
        recentDirs = recentDirs + "#";
        return recentDirs;
    }

    private void saveProperties() {
        try {
            FileOutputStream out = new FileOutputStream("jjj.properties");
            this.properties.store(out, "---No Comment---");
            out.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public void setMetaDirectory(String metaDirectoryName) throws FileNotFoundException {
        File metaDirectory = new File(metaDirectoryName);
        if (!metaDirectory.isDirectory() || !metaDirectory.canRead()) {
            if (!metaDirectory.exists()) {
                // empty if block
            }
            throw new FileNotFoundException();
        }
        if (this.recentMetaDirectories.contains(metaDirectory.getPath())) {
            this.recentMetaDirectories.removeElementAt(this.recentMetaDirectories.indexOf(metaDirectoryName));
            this.recentMetaDirectories.add(metaDirectory.getPath());
        } else {
            if (this.recentMetaDirectories.size() == 4) {
                this.recentMetaDirectories.removeElementAt(0);
            }
            this.recentMetaDirectories.add(metaDirectoryName);
        }
        this.metaDirectory = metaDirectory;
        this.message.setCommand(8);
        this.message.setStringArg(metaDirectory.getPath());
        this.notifier.sendMessage(this.message);
        this.setDirectory(metaDirectoryName);
    }

    public void setDirectory(String directoryName) throws FileNotFoundException {
        File directory = new File(directoryName);
        if (!directory.isDirectory()) {
            if (!directory.exists()) {
                // empty if block
            }
            throw new FileNotFoundException();
        }
        this.directory = directory;
        this.listContents(directory);
        Message message = new Message(0, "", 0);
        message.setCommand(7);
        message.setStringArg(directory.getPath());
        this.notifier.sendMessage(message);
    }

    public void setDirectory(File dir) {
        this.directory = dir;
    }

    public void setContents(File[] files) {
        this.files = files;
    }

    public boolean isPlaying() {
        return this.player.isPlaying();
    }

    public boolean isPaused() {
        return this.player.isPaused();
    }

    public boolean isStopped() {
        return this.player.isStopped();
    }

    public String[] getRecentMetaDirectories() {
        String[] dirs = new String[this.recentMetaDirectories.size()];
        for (int t = 0; t < this.recentMetaDirectories.size(); ++t) {
            dirs[t] = this.recentMetaDirectories.elementAt(t);
        }
        return dirs;
    }

    public File getMetaDirectory() {
        return this.metaDirectory;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    public File getPlayingDirectory() {
        return this.player.getPlayingDirectory();
    }

    public File getPlayingFile() {
        return this.player.getPlayingFile();
    }

    public String getPlayingFileName() {
        return this.player.getPlayingFileName();
    }

    private void listContents(File directory) {
        FilenameFilter fileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String filename) {
                String extension = "";
                int i = filename.lastIndexOf(46);
                if (i > 0) {
                    extension = filename.substring(i + 1);
                }
                return !filename.startsWith("._") && Core.this.getSupportedExtensions().contains(extension.toLowerCase());
            }
        };
        String[] filenames = directory.list(fileFilter);
        this.files = new File[filenames.length];
        for (int t = 0; t < filenames.length; ++t) {
            this.files[t] = new File(directory, filenames[t]);
        }
        Arrays.sort(this.files, this.fileComparator);
    }

    public int getIndex(File file) {
        for (int t = 0; t < this.files.length; ++t) {
            if (!this.files[t].equals(file)) continue;
            return t;
        }
        return -1;
    }

    public File[] getContents() {
        return this.files;
    }

    @Override
    public int getFilesLength() {
        return this.files.length;
    }

    @Override
    public File getFile(int index) {
        try {
            return this.files[index];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public String getFilePath(int index) {
        try {
            return this.files[index].getPath();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return "";
        }
    }

    @Override
    public void update(Observable o, Object message) {
        switch (((Message)message).getCommand()) {
            case 4: {
                this.player.next();
            }
        }
    }

    public void action(int action) {
        this.player.action(action);
    }

    public void setSelectedIndex(int index) {
        this.player.setSelectedIndex(index);
    }

    public void setPosition(int startPosition) {
        this.player.setPosition(startPosition);
    }

    public void setVolume(int volume) {
        this.player.setVolume(volume);
    }

    public void openFile(String filename) {
        File file = new File(filename);
        if (file.isFile()) {
            this.openFile(file);
        }
    }

    public void openFile(File file) {
        int index = this.getIndex(file);
        if (index >= 0) {
            this.setSelectedIndex(index);
        } else {
            this.player.openFile(file);
        }
    }

    public void runConsoleCommand(String command) {
        int action = 0;
        if (command.equals("-r")) {
            action = 114;
        } else if (command.equals("-p")) {
            action = 111;
        } else if (command.equals("-u")) {
            action = 112;
        } else if (command.equals("-s")) {
            action = 116;
        } else if (command.equals("-t")) {
            action = 113;
        } else if (command.equals("-f")) {
            action = 115;
        } else if (command.equals("-x")) {
            this.shutdownInitiation();
        }
        this.action(action);
    }

    @Override
    public HashSet<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }
}

