/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core;

import com.mamiyaotaru.jukebox.core.IJukeboxCore;
import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.Song;
import java.io.File;

public class Player {
    IJukeboxCore core;
    Notifier notifier;
    Message message;
    Song song;
    File playingDirectory;
    File currentDirectory;
    File currentFile = null;
    int currentFileIndex;
    boolean playing;
    boolean paused;
    boolean stopped;
    private int volume = 100;

    public Player(IJukeboxCore core, Notifier notifier, Message message) {
        this.core = core;
        this.notifier = notifier;
        this.message = message;
        this.song = new Song(notifier, message);
        this.playing = false;
        this.paused = false;
        this.stopped = true;
        this.currentDirectory = core.getDirectory();
        this.currentFileIndex = 0;
        this.currentFile = core.getFile(this.currentFileIndex);
    }

    protected File getPlayingDirectory() {
        return this.playingDirectory;
    }

    public File getPlayingFile() {
        return this.currentFile;
    }

    protected String getPlayingFileName() {
        if (this.stopped) {
            return "";
        }
        return this.currentFile.getName();
    }

    public void action(int action) {
        switch (action) {
            case 111: {
                this.play();
                break;
            }
            case 112: {
                this.pause();
                break;
            }
            case 113: {
                this.togglePlayPause();
                break;
            }
            case 114: {
                this.previous();
                break;
            }
            case 115: {
                this.next();
                break;
            }
            case 116: {
                this.stop();
                break;
            }
            case 117: {
                this.setVolume(Math.min(100, this.volume + 10));
                break;
            }
            case 118: {
                this.setVolume(Math.max(0, this.volume - 10));
            }
        }
    }

    private void play() {
        if (this.playing) {
            this.stopPlayback();
            this.playCurrentFile();
        }
        if (this.paused) {
            this.unPause();
        }
        if (this.stopped) {
            this.playCurrentFile();
        }
    }

    private void playFileAtIndex(int index) {
        if (this.currentFileIndex >= this.core.getFilesLength() && index >= 0) {
            return;
        }
        this.playFile(this.core.getFile(index));
        Message message = new Message(6, this.core.getFilePath(index), index);
        this.notifier.sendMessage(message);
    }

    private void playCurrentFile() {
        if (this.currentFile != null && !this.currentFile.equals(this.core.getFile(this.currentFileIndex))) {
            this.playFile(this.currentFile);
        } else {
            this.playFileAtIndex(this.currentFileIndex);
        }
    }

    private void playNext() {
        if (this.currentDirectory != null && !this.currentDirectory.equals(this.core.getDirectory())) {
            this.currentFileIndex = 0;
            this.playFileAtIndex(this.currentFileIndex);
        } else if (this.currentFileIndex < this.core.getFilesLength() - 1) {
            ++this.currentFileIndex;
            this.playFileAtIndex(this.currentFileIndex);
        }
    }

    private void playPrevious() {
        if (this.currentDirectory != null && !this.currentDirectory.equals(this.core.getDirectory())) {
            this.currentFileIndex = 0;
            this.playFileAtIndex(this.currentFileIndex);
        } else if (this.currentFileIndex > 0) {
            --this.currentFileIndex;
            this.playFileAtIndex(this.currentFileIndex);
        }
    }

    private void playFile(File file) {
        if (file == null) {
            return;
        }
        String filePath = file.getPath();
        this.currentFile = file;
        this.currentDirectory = this.core.getDirectory();
        this.playingDirectory = file.getParentFile();
        if (!this.playingDirectory.equals(this.currentDirectory)) {
            Message message = new Message(0, "", 0);
            message.setCommand(6);
            message.setIntArg(-1);
            this.notifier.sendMessage(message);
        }
        this.playing = true;
        this.paused = false;
        this.stopped = false;
        this.currentFile = file;
        this.message.setCommand(1);
        this.message.setIntArg(0);
        this.notifier.sendMessage(this.message);
        this.song = new Song(this.notifier, this.message, file);
        this.song.setVolume(this.volume);
        this.song.play();
    }

    public void next() {
        this.stopPlayback();
        this.playNext();
    }

    private void previous() {
        this.stopPlayback();
        this.playPrevious();
    }

    private void stop() {
        this.stopPlayback();
        this.message.setCommand(1);
        this.message.setIntArg(0);
        this.notifier.sendMessage(this.message);
        Message message2 = new Message(0, "", 0);
        message2.setCommand(6);
        message2.setIntArg(-1);
        this.notifier.sendMessage(message2);
    }

    protected void stopPlayback() {
        this.song.stopPlayback();
        this.stopped = true;
        this.playing = false;
        this.paused = false;
    }

    private void pause() {
        if (this.paused) {
            this.unPause();
        } else if (this.playing) {
            this.paused = true;
            this.playing = false;
            this.stopped = false;
            this.song.pause();
        }
    }

    private void unPause() {
        this.paused = false;
        this.playing = true;
        this.stopped = false;
        this.song.unPause();
    }

    private void togglePlayPause() {
        if (this.paused) {
            this.unPause();
        } else if (this.stopped) {
            this.play();
        } else if (this.playing) {
            this.pause();
        }
    }

    public void setPosition(int startPosition) {
        this.song.setPosition(startPosition);
    }

    public void setSelectedIndex(int index) {
        this.currentFileIndex = index;
        this.stopPlayback();
        this.playFileAtIndex(this.currentFileIndex);
    }

    public void openFile(File file) {
        String filename = file.getName();
        if (filename.toLowerCase().endsWith("wav") || filename.toLowerCase().endsWith("mp3") || filename.toLowerCase().endsWith("ogg") || filename.toLowerCase().endsWith("m4a") || filename.toLowerCase().endsWith("flac")) {
            this.stopPlayback();
            this.playFile(file);
        }
    }

    public void setVolume(int volume) {
        this.volume = volume;
        this.song.setVolume(volume);
        this.message.setCommand(119);
        this.message.setIntArg(volume);
        this.notifier.sendMessage(this.message);
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

