/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core;

import com.mamiyaotaru.jukebox.PreviousInstanceException;
import com.mamiyaotaru.jukebox.core.Core;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class SocketManager {
    private Core core;
    private ServerSocket serverSocket = null;
    private boolean running = true;

    public SocketManager(String[] args, Core core) throws PreviousInstanceException {
        this.core = core;
        if (args.length > 0 && (args[0].equals("-h") || args[0].equals("--help") || args[0].equals("-x")) || this.checkForPrevious()) {
            this.handleArgs(args);
            throw new PreviousInstanceException();
        }
        this.startListenerThread();
    }

    private boolean checkForPrevious() {
        this.serverSocket = null;
        try {
            this.serverSocket = new ServerSocket(1492);
        }
        catch (BindException e) {
            return true;
        }
        catch (IOException e) {
            return true;
        }
        return false;
    }

    private void handleArgs(String[] args) {
        if (args.length > 0) {
            String arg = args[0];
            if (arg.equals("--help") || arg.equals("-h")) {
                this.printHelp();
            } else if (arg.equals("-r") || arg.equals("-p") || arg.equals("-u") || arg.equals("-s") || arg.equals("-t") || arg.equals("-f") || arg.equals("-x")) {
                this.passArgs(args);
            } else {
                File file = new File(args[0]);
                if (file.isFile()) {
                    this.passArgs(args);
                }
            }
        }
    }

    private void printHelp() {
        System.out.println("-h, --help              Display this text and exit.");
        System.out.println("-r                      Skip backwards in playlist");
        System.out.println("-p                      Start playing current playlist");
        System.out.println("-u                      Pause current song");
        System.out.println("-s                      Stop current song");
        System.out.println("-t                      Pause if playing, play otherwise");
        System.out.println("-f                      Skip forward in playlist");
        System.out.println("-x                      Close the application");
    }

    private void passArgs(String[] args) {
        Socket previousSocket = null;
        PrintWriter out = null;
        try {
            previousSocket = new Socket("localhost", 1492);
            out = new PrintWriter(previousSocket.getOutputStream(), true);
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host: localhost.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to: localhost.");
            System.exit(1);
        }
        if (args.length > 0) {
            out.println(args[0]);
        }
        out.close();
        try {
            previousSocket.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void startListenerThread() {
        Thread listenerThread = new Thread("socketListenerThread"){

            @Override
            public void run() {
                Socket clientSocket = null;
                InetAddress localhost = null;
                try {
                    localhost = InetAddress.getByName("localhost");
                }
                catch (Exception e) {
                    System.out.println("localhost unknown.  wtf");
                    return;
                }
                BufferedReader in = null;
                InputStreamReader source = null;
                while (SocketManager.this.running) {
                    String line;
                    try {
                        clientSocket = SocketManager.this.serverSocket.accept();
                    }
                    catch (IOException e) {
                        System.out.println("Accept failed: 4444");
                        break;
                    }
                    if (!clientSocket.getInetAddress().equals(localhost)) {
                        System.out.println("connection from outside rejected");
                        break;
                    }
                    try {
                        source = new InputStreamReader(clientSocket.getInputStream());
                        in = new BufferedReader(source);
                    }
                    catch (IOException e) {
                        System.out.println("in or out failed");
                        break;
                    }
                    try {
                        line = in.readLine();
                    }
                    catch (IOException e) {
                        System.out.println("Read failed");
                        break;
                    }
                    if (line.equals("-r") || line.equals("-p") || line.equals("-u") || line.equals("-s") || line.equals("-t") || line.equals("-f") || line.equals("-x")) {
                        SocketManager.this.core.runConsoleCommand(line);
                    } else {
                        SocketManager.this.core.openFile(line);
                    }
                    try {
                        in.close();
                        source.close();
                        clientSocket.close();
                    }
                    catch (Exception exception) {}
                }
            }

            protected void finalize() {
                try {
                    SocketManager.this.serverSocket.close();
                }
                catch (IOException e) {
                    System.out.println("Could not close socket");
                }
            }
        };
        listenerThread.start();
    }
}

