/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.AudioThreadFLAC;
import com.mamiyaotaru.jukebox.core.threads.AudioThreadM4A;
import com.mamiyaotaru.jukebox.core.threads.AudioThreadMIDI;
import com.mamiyaotaru.jukebox.core.threads.AudioThreadMP3;
import com.mamiyaotaru.jukebox.core.threads.AudioThreadOgg;
import com.mamiyaotaru.jukebox.core.threads.AudioThreadWAV;
import com.mamiyaotaru.jukebox.core.threads.IAudioThread;
import com.mamiyaotaru.jukebox.core.threads.ILengthThread;
import com.mamiyaotaru.jukebox.core.threads.LengthThreadFLAC;
import com.mamiyaotaru.jukebox.core.threads.LengthThreadM4A;
import com.mamiyaotaru.jukebox.core.threads.LengthThreadMIDI;
import com.mamiyaotaru.jukebox.core.threads.LengthThreadMP3;
import com.mamiyaotaru.jukebox.core.threads.LengthThreadOgg;
import com.mamiyaotaru.jukebox.core.threads.LengthThreadWAV;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;

public class Song {
    private String filename = "moo";
    private File file;
    private int startPosition;
    private int totalLength = 50000;
    private int currentPosition;
    private boolean stopped;
    private boolean paused;
    private boolean playing;
    private boolean totalChanged;
    private IAudioThread playerThread;
    private ILengthThread lengthThread;
    private Notifier notifier;
    private Message message;
    private ThreadCoordinator threadCoordinator;
    private int volume = 100;
    private boolean pendingSeek = false;

    public Song(Notifier notifier, Message message) {
        this.notifier = notifier;
        this.message = message;
        this.stopped = false;
        this.currentPosition = this.startPosition = 0;
        this.totalChanged = false;
        this.playerThread = null;
        this.threadCoordinator = new ThreadCoordinator(this);
    }

    public Song(Notifier notifier, Message message, File file) {
        this(notifier, message);
        this.file = file;
        this.filename = file.getName();
        this.totalChanged = false;
        if (this.filename.toLowerCase().endsWith("mp3")) {
            this.lengthThread = new LengthThreadMP3(file, this.threadCoordinator, notifier, message, 0, this.totalLength);
        } else if (this.filename.toLowerCase().endsWith("ogg")) {
            this.lengthThread = new LengthThreadOgg(file, this.threadCoordinator, notifier, message, 0, this.totalLength);
        } else if (this.filename.toLowerCase().endsWith("wav")) {
            this.lengthThread = new LengthThreadWAV(file, this.threadCoordinator, notifier, message, 0, this.totalLength);
        } else if (this.filename.toLowerCase().endsWith("m4a")) {
            this.lengthThread = new LengthThreadM4A(file, this.threadCoordinator, notifier, message, 0, this.totalLength);
        } else if (this.filename.toLowerCase().endsWith("flac")) {
            this.lengthThread = new LengthThreadFLAC(file, this.threadCoordinator, notifier, message, 0, this.totalLength);
        } else if (this.filename.toLowerCase().endsWith("mid") || this.filename.toLowerCase().endsWith("midi")) {
            this.lengthThread = new LengthThreadMIDI(file, this.threadCoordinator, notifier, message, 0, this.totalLength);
        } else {
            System.err.println(this.filename + " file type not recognized");
            throw new NullPointerException();
        }
        this.lengthThread.start();
    }

    public void setPosition(int startPosition) {
        if (!this.stopped) {
            this.message.setCommand(1);
            this.message.setIntArg(startPosition);
            this.notifier.sendMessage(this.message);
            if (this.playing) {
                this.stopPlayback();
                if (this.totalChanged) {
                    startPosition = this.totalLength * startPosition / 100;
                    this.play(startPosition);
                } else {
                    this.paused = false;
                    this.playing = true;
                    this.stopped = false;
                    this.startPosition = startPosition;
                    this.pendingSeek = true;
                }
            } else if (this.paused) {
                if (this.totalChanged) {
                    this.currentPosition = this.totalLength * startPosition / 100;
                } else {
                    this.startPosition = startPosition;
                    this.pendingSeek = true;
                }
            }
        }
    }

    protected void play() {
        this.play(0);
    }

    private void play(int startPosition) {
        this.readMyAudioFile(this.filename, startPosition, this.totalChanged);
    }

    public void stopPlayback() {
        this.stopped = true;
        this.paused = false;
        this.playing = false;
        if (this.playerThread != null) {
            this.playerThread.stopPlayback();
        }
    }

    private void readMyAudioFile(String filename, int startPosition, boolean totalChanged) {
        this.playing = true;
        this.paused = false;
        this.stopped = false;
        if (filename.toLowerCase().endsWith("mp3")) {
            this.playerThread = new AudioThreadMP3(this.file, this.threadCoordinator, this.notifier, this.message, startPosition, this.totalLength, totalChanged);
        } else if (filename.toLowerCase().endsWith("ogg")) {
            this.playerThread = new AudioThreadOgg(this.file, this.threadCoordinator, this.notifier, this.message, startPosition, this.totalLength, totalChanged);
        } else if (filename.toLowerCase().endsWith("wav")) {
            this.playerThread = new AudioThreadWAV(this.file, this.threadCoordinator, this.notifier, this.message, startPosition, this.totalLength, totalChanged);
        } else if (filename.toLowerCase().endsWith("m4a")) {
            this.playerThread = new AudioThreadM4A(this.file, this.threadCoordinator, this.notifier, this.message, startPosition, this.totalLength, totalChanged);
        } else if (filename.toLowerCase().endsWith("flac")) {
            this.playerThread = new AudioThreadFLAC(this.file, this.threadCoordinator, this.notifier, this.message, startPosition, this.totalLength, totalChanged);
        } else if (filename.toLowerCase().endsWith("mid") || filename.toLowerCase().endsWith("midi")) {
            this.playerThread = new AudioThreadMIDI(this.file, this.threadCoordinator, this.notifier, this.message, startPosition, this.totalLength, totalChanged);
        }
        this.playerThread.setVolume(this.volume);
        this.playerThread.start();
    }

    public void setTotalLength(int totalLength) {
        this.totalLength = totalLength;
    }

    public void setTotalChanged(boolean totalChanged) {
        this.totalChanged = totalChanged;
        if (this.pendingSeek) {
            this.pendingSeek = false;
            if (this.playing) {
                this.startPosition = this.totalLength * this.startPosition / 100;
                this.play(this.startPosition);
            } else if (this.paused) {
                this.currentPosition = this.totalLength * this.startPosition / 100;
            }
        }
    }

    public void pause() {
        if (!this.playing) {
            return;
        }
        this.currentPosition = this.playerThread.getPosition();
        this.stopPlayback();
        this.paused = true;
        this.playing = false;
        this.stopped = false;
    }

    public void unPause() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        this.playing = true;
        this.stopped = false;
        this.readMyAudioFile(this.filename, this.currentPosition - 2, this.totalChanged);
    }

    public void setVolume(int volume) {
        this.volume = volume;
        if (this.playerThread != null) {
            this.playerThread.setVolume(volume);
        }
    }
}

