/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.IAudioThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public abstract class AbstractAudioThread
extends Thread
implements IAudioThread {
    protected File file;
    protected boolean stopped;
    protected SourceDataLine line = null;
    protected int startPosition;
    protected int currentPosition;
    protected ThreadCoordinator threadCoordinator;
    protected Notifier notifier;
    protected Message message;
    protected int volume = 100;
    protected AudioFormat audioFormat = null;
    protected AudioFormat destAudioFormat = null;

    public AbstractAudioThread(String string) {
        super(string);
    }

    @Override
    public void run() {
        if (this.startPosition == 0) {
            this.message.setCommand(1);
            this.message.setIntArg(0);
            this.notifier.sendMessage(this.message);
        }
        this.readMyAudioFile(this.file, this.startPosition);
        this.finish();
        this.stopPlayback();
    }

    protected void finish() {
        if (!this.stopped) {
            if (this.line != null) {
                this.line.drain();
            }
            Message message = new Message(0, "", 0);
            message.setCommand(4);
            message.setIntArg(0);
            message.setStringArg(this.file.getPath());
            if (!this.stopped) {
                this.notifier.sendMessage(message);
            }
        }
    }

    @Override
    public abstract void stopPlayback();

    @Override
    public abstract void readMyAudioFile(File var1, int var2);

    @Override
    public int getPosition() {
        return this.currentPosition;
    }

    protected SourceDataLine getLine(AudioFormat audioFormat) {
        this.line = null;
        boolean error = false;
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, -1);
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open(audioFormat, -1);
        }
        catch (LineUnavailableException e1) {
            System.err.println(e1.getMessage() + ", will downsample");
            error = true;
        }
        catch (IllegalArgumentException e2) {
            System.err.println(e2.getMessage() + ", will downsample");
            error = true;
        }
        if (error) {
            this.destAudioFormat = new AudioFormat(audioFormat.getEncoding(), Math.min(audioFormat.getSampleRate(), 48000.0f), Math.min(audioFormat.getSampleSizeInBits(), 16), audioFormat.getChannels(), Math.min(audioFormat.getFrameSize(), 4), Math.min(audioFormat.getFrameRate(), 48000.0f), audioFormat.isBigEndian());
            info = new DataLine.Info(SourceDataLine.class, this.destAudioFormat, -1);
            try {
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(this.destAudioFormat, -1);
            }
            catch (LineUnavailableException e1) {
                e1.printStackTrace();
                return null;
            }
            catch (IllegalArgumentException e2) {
                e2.printStackTrace();
                return null;
            }
        } else {
            this.destAudioFormat = audioFormat;
        }
        this.line.start();
        this.setVolume(this.volume);
        return this.line;
    }

    protected byte[] downsample(byte[] sourceBytes, int sourceLength) {
        float sourceFramerate = this.audioFormat.getFrameRate();
        float destFramerate = this.destAudioFormat.getFrameRate();
        int sourceSampleSizeInBytes = this.audioFormat.getSampleSizeInBits() / 8;
        int destSampleSizeInBytes = this.destAudioFormat.getSampleSizeInBits() / 8;
        int channels = this.audioFormat.getChannels();
        int destLength = (int)((float)sourceLength * destFramerate / sourceFramerate);
        destLength = destLength * destSampleSizeInBytes / sourceSampleSizeInBytes;
        int sourceFrames = sourceLength / channels / sourceSampleSizeInBytes;
        int destFrames = destLength / channels / destSampleSizeInBytes;
        float ratio = sourceFrames / destFrames;
        byte[] destBytes = new byte[destLength];
        for (int t = 0; t < destFrames; ++t) {
            for (int s = 0; s < channels; ++s) {
                for (int i = 0; i < destSampleSizeInBytes; ++i) {
                    if (this.destAudioFormat.isBigEndian()) {
                        destBytes[t * channels * destSampleSizeInBytes + s * destSampleSizeInBytes + i] = sourceBytes[(int)((float)t * ratio) * channels * sourceSampleSizeInBytes + s * sourceSampleSizeInBytes + i];
                        continue;
                    }
                    destBytes[t * channels * destSampleSizeInBytes + s * destSampleSizeInBytes + destSampleSizeInBytes - 1 - i] = sourceBytes[(int)((float)t * ratio) * channels * sourceSampleSizeInBytes + sourceSampleSizeInBytes * s + sourceSampleSizeInBytes - 1 - i];
                }
            }
        }
        return destBytes;
    }

    @Override
    public void setVolume(int volume) {
        if (this.line != null && this.line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            FloatControl volumeControl = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
            float value = (float)volume / 100.0f;
            float dB = (float)(Math.log((double)value == 0.0 ? 1.0E-4 : (double)value) / Math.log(10.0) * 20.0);
            volumeControl.setValue(dB);
        } else {
            this.volume = volume;
        }
    }
}

