/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.AbstractAudioThread;
import com.mamiyaotaru.jukebox.core.threads.IAudioThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.frame.Frame;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.SeekTable;
import org.kc7bfi.jflac.metadata.StreamInfo;
import org.kc7bfi.jflac.util.ByteData;

public class AudioThreadFLAC
extends AbstractAudioThread
implements IAudioThread {
    private int totalLength = 10000;
    private boolean totalChanged;
    private BufferedInputStream bitstream;

    public AudioThreadFLAC(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength, boolean totalChanged) {
        super("FLACPlayerThread: " + file.getName());
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
        this.totalChanged = totalChanged;
    }

    @Override
    public synchronized void stopPlayback() {
        this.stopped = true;
        if (this.line != null) {
            this.line.close();
        }
        if (this.bitstream != null) {
            try {
                this.bitstream.close();
            }
            catch (IOException ex) {
                System.out.println("**** bitsream exception: " + ex.getLocalizedMessage());
            }
        }
    }

    @Override
    public void readMyAudioFile(File file, int startPosition) {
        Metadata[] metadata;
        try {
            this.bitstream = new BufferedInputStream(new FileInputStream(file), 32768);
        }
        catch (FileNotFoundException e1) {
            return;
        }
        FLACDecoder flacDecoder = new FLACDecoder(this.bitstream);
        try {
            metadata = flacDecoder.readMetadata();
        }
        catch (IOException e1) {
            return;
        }
        SeekTable seekTable = null;
        for (Metadata metadatum : metadata) {
            if (!(metadatum instanceof SeekTable)) continue;
            seekTable = (SeekTable)metadatum;
        }
        StreamInfo streamInfo = flacDecoder.getStreamInfo();
        this.audioFormat = streamInfo.getAudioFormat();
        this.line = this.getLine(this.audioFormat);
        if (this.line == null) {
            return;
        }
        int percentageDone = 0;
        int percentageTemp = 0;
        try {
            Frame frame;
            int framesTotal;
            for (framesTotal = 0; framesTotal < startPosition && !this.stopped && (frame = flacDecoder.readNextFrame()) != null; ++framesTotal) {
            }
            while (!this.stopped && (frame = flacDecoder.readNextFrame()) != null) {
                ++framesTotal;
                ByteData pcm = flacDecoder.decodeFrame(frame, null);
                byte[] audioBytes = pcm.getData();
                int length = pcm.getLen();
                if (this.destAudioFormat != this.audioFormat) {
                    audioBytes = this.downsample(audioBytes, length);
                    length = audioBytes.length;
                }
                this.line.write(audioBytes, 0, length);
                this.currentPosition = framesTotal;
                if (!this.totalChanged) {
                    this.totalChanged = this.threadCoordinator.getTotalChanged();
                    if (this.totalChanged) {
                        this.totalLength = this.threadCoordinator.getTotalLength();
                    }
                }
                if (percentageDone == (percentageTemp = framesTotal * 100 / this.totalLength)) continue;
                percentageDone = percentageTemp;
                this.message.setCommand(1);
                this.message.setIntArg(percentageDone);
                this.notifier.sendMessage(this.message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

