/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.beatofthedrum.alacdecoder.AlacContext;
import com.beatofthedrum.alacdecoder.AlacUtils;
import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.AbstractAudioThread;
import com.mamiyaotaru.jukebox.core.threads.IAudioThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.mp4.MP4Container;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import net.sourceforge.jaad.mp4.api.Movie;
import net.sourceforge.jaad.mp4.api.Track;

public class AudioThreadM4A
extends AbstractAudioThread
implements IAudioThread {
    private int totalLength = 100000000;
    private boolean totalChanged;
    private RandomAccessFile randomAccessFile;
    private AlacContext alacContext;

    public AudioThreadM4A(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength, boolean totalChanged) {
        super("M4aPlayerThread: " + file.getName());
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.stopped = false;
        this.startPosition = startPosition;
        if (totalChanged) {
            this.totalLength = totalLength;
        }
        this.totalChanged = totalChanged;
    }

    @Override
    public void stopPlayback() {
        this.stopped = true;
        if (this.line != null) {
            this.line.close();
        }
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.alacContext != null) {
            AlacUtils.AlacCloseFile(this.alacContext);
        }
    }

    @Override
    public void readMyAudioFile(File file, int startPosition) {
        Frame frame;
        int framesTotal;
        this.stopped = false;
        MP4Container container = null;
        AudioTrack track = null;
        Decoder decoder = null;
        try {
            this.randomAccessFile = new RandomAccessFile(file, "r");
            container = new MP4Container(new RandomAccessFile(file, "r"));
            Movie movie = container.getMovie();
            List<Track> tracks = movie.getTracks(AudioTrack.AudioCodec.AAC);
            if (tracks.isEmpty()) {
                this.readMyAudioFileALAC(file, startPosition);
                return;
            }
            track = (AudioTrack)tracks.get(0);
            byte[] decoderSpecificInfo = track.getDecoderSpecificInfo();
            decoder = new Decoder(decoderSpecificInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (decoder == null) {
            System.out.println("###  cannot read input file: " + file.getPath());
            return;
        }
        SampleBuffer sampleBuffer = new SampleBuffer();
        this.audioFormat = new AudioFormat(track.getSampleRate(), track.getSampleSize(), track.getChannelCount(), true, true);
        this.line = this.getLine(this.audioFormat);
        if (this.line == null) {
            return;
        }
        int percentageDone = 0;
        int percentageTemp = 0;
        try {
            for (framesTotal = 0; framesTotal < startPosition && (frame = track.readNextFrame()) != null && !this.stopped; ++framesTotal) {
            }
        }
        catch (AACException e1) {
            e1.printStackTrace();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            while ((frame = track.readNextFrame()) != null && !this.stopped) {
                decoder.decodeFrame(frame.getData(), sampleBuffer);
                byte[] audioBytes = sampleBuffer.getData();
                int length = audioBytes.length;
                if (this.destAudioFormat != this.audioFormat) {
                    audioBytes = this.downsample(audioBytes, length);
                    length = audioBytes.length;
                }
                int nBytesWritten = this.line.write(audioBytes, 0, length);
                this.currentPosition = ++framesTotal;
                if (!this.totalChanged) {
                    this.totalChanged = this.threadCoordinator.getTotalChanged();
                    if (this.totalChanged) {
                        this.totalLength = this.threadCoordinator.getTotalLength();
                    }
                }
                if (percentageDone == (percentageTemp = framesTotal * 100 / this.totalLength)) continue;
                percentageDone = percentageTemp;
                this.message.setCommand(1);
                this.message.setIntArg(percentageDone);
                this.notifier.sendMessage(this.message);
            }
        }
        catch (AACException e1) {
            e1.printStackTrace();
            return;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return;
        }
    }

    public void readMyAudioFileALAC(File file, int startPosition) {
        this.alacContext = AlacUtils.AlacOpenFileInput(file.getPath());
        if (this.alacContext.error) {
            return;
        }
        int channels = AlacUtils.AlacGetNumChannels(this.alacContext);
        int samples = AlacUtils.AlacGetNumSamples(this.alacContext);
        int bytesPerSample = AlacUtils.AlacGetBytesPerSample(this.alacContext);
        int sampleRate = AlacUtils.AlacGetSampleRate(this.alacContext);
        int bitsPerSample = AlacUtils.AlacGetBitsPerSample(this.alacContext);
        startPosition = startPosition / 4 * 4;
        this.audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleRate, bitsPerSample, channels, bytesPerSample * channels, sampleRate, false);
        this.line = this.getLine(this.audioFormat);
        if (this.line == null) {
            return;
        }
        int nSamplesTotal = 0;
        int percentageDone = 0;
        int percentageTemp = 0;
        byte[] audioBytes = null;
        int[] buffer = new int[147456];
        AlacUtils.AlacSetPosition(this.alacContext, startPosition);
        nSamplesTotal = startPosition;
        while (!this.stopped) {
            int nBytesRead = AlacUtils.AlacUnpackSamples(this.alacContext, buffer);
            if (nBytesRead > 0) {
                audioBytes = this.format_samples(bytesPerSample, buffer, nBytesRead);
                int length = nBytesRead;
                if (this.destAudioFormat != this.audioFormat) {
                    audioBytes = this.downsample(audioBytes, length);
                    length = audioBytes.length;
                }
                this.line.write(audioBytes, 0, length);
            }
            if (nBytesRead == 0) break;
            this.currentPosition = nSamplesTotal += nBytesRead / bytesPerSample / channels;
            if (!this.totalChanged) {
                this.totalChanged = this.threadCoordinator.getTotalChanged();
                if (this.totalChanged) {
                    this.totalLength = this.threadCoordinator.getTotalLength();
                }
            }
            if (percentageDone == (percentageTemp = nSamplesTotal * 100 / this.totalLength)) continue;
            percentageDone = percentageTemp;
            this.message.setCommand(1);
            this.message.setIntArg(percentageDone);
            this.notifier.sendMessage(this.message);
        }
    }

    private byte[] format_samples(int bps, int[] src, int samcnt) {
        int temp = 0;
        int counter = 0;
        int counter2 = 0;
        byte[] dst = new byte[65536];
        switch (bps) {
            case 1: {
                while (samcnt > 0) {
                    dst[counter] = (byte)(0xFF & src[counter] + 128);
                    ++counter;
                    --samcnt;
                }
                break;
            }
            case 2: {
                while (samcnt > 0) {
                    temp = src[counter2];
                    dst[counter] = (byte)temp;
                    dst[++counter] = (byte)(temp >>> 8);
                    ++counter;
                    ++counter2;
                    samcnt -= 2;
                }
                break;
            }
            case 3: {
                while (samcnt > 0) {
                    dst[counter] = (byte)src[counter2];
                    ++counter;
                    ++counter2;
                    --samcnt;
                }
                break;
            }
        }
        return dst;
    }
}

