/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.AbstractAudioThread;
import com.mamiyaotaru.jukebox.core.threads.IAudioThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import com.sun.media.sound.AudioSynthesizer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AudioThreadMIDI
extends AbstractAudioThread
implements IAudioThread {
    private int totalLength = 10000;
    private boolean totalChanged;
    static Sequencer sequencer;
    InputStream is;
    AudioInputStream audioInputStream;

    public AudioThreadMIDI(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength, boolean totalChanged) {
        super("playerThread: " + file.getName());
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
        this.totalChanged = totalChanged;
        if (sequencer == null) {
            try {
                sequencer = MidiSystem.getSequencer();
            }
            catch (MidiUnavailableException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void stopPlayback() {
        this.stopped = true;
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (sequencer != null) {
            sequencer.close();
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readMyAudioFile(File file, int startPosition) {
        try {
            sequencer.open();
            this.is = new BufferedInputStream(new FileInputStream(file));
            sequencer.setSequence(this.is);
            Sequence sequence = sequencer.getSequence();
            AudioSynthesizer synth = this.findAudioSynthesizer();
            if (synth == null) {
                System.out.println("No AudioSynthesizer was found!");
                return;
            }
            AudioFormat format = new AudioFormat(48000.0f, 16, 2, true, false);
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("interpolation", "sinc");
            p.put("max polyphony", "1024");
            this.audioInputStream = synth.openStream(format, p);
            double total = this.send(sequence, synth.getReceiver());
            long len = (long)((double)this.audioInputStream.getFormat().getFrameRate() * (total + 4.0));
            this.audioInputStream = new AudioInputStream(this.audioInputStream, this.audioInputStream.getFormat(), len);
            int EXTERNAL_BUFFER_SIZE = 128000;
            byte[] audioBytes = new byte[EXTERNAL_BUFFER_SIZE];
            AudioFormat.Encoding targetEncoding = AudioFormat.Encoding.PCM_SIGNED;
            this.audioInputStream = AudioSystem.getAudioInputStream(targetEncoding, this.audioInputStream);
            this.audioFormat = this.audioInputStream.getFormat();
            this.line = this.getLine(this.audioFormat);
            if (this.line == null) {
                return;
            }
            int nBytesRead = 0;
            int framesTotal = 0;
            int percentageDone = 0;
            int percentageTemp = 0;
            while (framesTotal < startPosition && nBytesRead != -1 && !this.stopped) {
                try {
                    nBytesRead = this.audioInputStream.read(audioBytes, 0, audioBytes.length);
                }
                catch (IOException e) {
                    return;
                }
                if (nBytesRead < 0) continue;
                ++framesTotal;
            }
            while (nBytesRead != -1 && !this.stopped) {
                try {
                    nBytesRead = this.audioInputStream.read(audioBytes, 0, audioBytes.length);
                }
                catch (IOException e) {
                    return;
                }
                if (nBytesRead >= 0) {
                    int length = nBytesRead;
                    if (this.destAudioFormat != this.audioFormat) {
                        audioBytes = this.downsample(audioBytes, length);
                        length = audioBytes.length;
                    }
                    int nBytesWritten = this.line.write(audioBytes, 0, length);
                    this.currentPosition = ++framesTotal;
                }
                if (!this.totalChanged) {
                    this.totalChanged = this.threadCoordinator.getTotalChanged();
                    if (this.totalChanged) {
                        this.totalLength = this.threadCoordinator.getTotalLength();
                    }
                }
                if (percentageDone == (percentageTemp = framesTotal * 100 / this.totalLength)) continue;
                percentageDone = percentageTemp;
                this.message.setCommand(1);
                this.message.setIntArg(percentageDone);
                this.notifier.sendMessage(this.message);
            }
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    private AudioSynthesizer findAudioSynthesizer() throws MidiUnavailableException {
        Synthesizer synth = MidiSystem.getSynthesizer();
        if (synth instanceof AudioSynthesizer) {
            return (AudioSynthesizer)synth;
        }
        MidiDevice.Info[] midiDeviceInfo = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < midiDeviceInfo.length; ++i) {
            MidiDevice dev = MidiSystem.getMidiDevice(midiDeviceInfo[i]);
            if (!(dev instanceof AudioSynthesizer)) continue;
            return (AudioSynthesizer)dev;
        }
        return null;
    }

    private double send(Sequence seq, Receiver recv) {
        float divtype = seq.getDivisionType();
        assert (seq.getDivisionType() == 0.0f);
        Track[] tracks = seq.getTracks();
        int[] trackspos = new int[tracks.length];
        int mpq = 500000;
        int seqres = seq.getResolution();
        long lasttick = 0L;
        long curtime = 0L;
        while (!this.stopped) {
            MidiEvent selevent = null;
            int seltrack = -1;
            for (int i = 0; i < tracks.length; ++i) {
                int trackpos = trackspos[i];
                Track track = tracks[i];
                if (trackpos >= track.size()) continue;
                MidiEvent event = track.get(trackpos);
                if (selevent != null && event.getTick() >= selevent.getTick()) continue;
                selevent = event;
                seltrack = i;
            }
            if (seltrack == -1) break;
            int n = seltrack;
            trackspos[n] = trackspos[n] + 1;
            long tick = selevent.getTick();
            curtime = divtype == 0.0f ? (curtime += (tick - lasttick) * (long)mpq / (long)seqres) : (long)((double)tick * 1000000.0 * (double)divtype / (double)seqres);
            lasttick = tick;
            MidiMessage msg = selevent.getMessage();
            if (msg instanceof MetaMessage) {
                if (divtype != 0.0f || ((MetaMessage)msg).getType() != 81) continue;
                byte[] data = ((MetaMessage)msg).getData();
                mpq = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                continue;
            }
            if (recv == null) continue;
            recv.send(msg, curtime);
        }
        return (double)curtime / 1000000.0;
    }
}

