/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.AbstractAudioThread;
import com.mamiyaotaru.jukebox.core.threads.IAudioThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;
import java.io.FileInputStream;
import javax.sound.sampled.AudioFormat;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;

public class AudioThreadMP3
extends AbstractAudioThread
implements IAudioThread {
    private int totalLength = 10000;
    private boolean totalChanged;
    private Bitstream bitstream;
    private byte[] byteBuf = new byte[4096];
    private int volume = 100;

    public AudioThreadMP3(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength, boolean totalChanged) {
        super("playerThread: " + file.getName());
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
        this.totalChanged = totalChanged;
    }

    @Override
    public synchronized void stopPlayback() {
        this.stopped = true;
        if (this.line != null) {
            this.line.close();
        }
        if (this.bitstream != null) {
            try {
                this.bitstream.close();
            }
            catch (BitstreamException ex) {
                System.out.println("**** bitsream exception: " + ex.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMyAudioFile(File file, int startPosition) {
        int frames = Integer.MAX_VALUE;
        boolean ret = true;
        int framesTotal = 0;
        Decoder decoder = new Decoder();
        try {
            AudioThreadMP3 audioThreadMP3 = this;
            synchronized (audioThreadMP3) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.bitstream = new Bitstream(fileInputStream);
            }
            int percentageDone = 0;
            int percentageTemp = 0;
            while (framesTotal < startPosition && frames-- > 0 && ret) {
                ++framesTotal;
                try {
                    Header header = this.bitstream.readFrame();
                    if (header == null) {
                        ret = false;
                        break;
                    }
                    this.bitstream.closeFrame();
                }
                catch (RuntimeException ex) {
                    ret = false;
                }
            }
            int playedTotal = 0;
            while (!this.stopped && frames-- > 0 && ret) {
                ++playedTotal;
                this.currentPosition = ++framesTotal;
                try {
                    Header header = this.bitstream.readFrame();
                    if (header == null) {
                        ret = false;
                        break;
                    }
                    SampleBuffer sampleBuffer = (SampleBuffer)decoder.decodeFrame(header, this.bitstream);
                    if (this.line == null) {
                        this.audioFormat = new AudioFormat(decoder.getOutputFrequency(), 16, decoder.getOutputChannels(), true, false);
                        this.line = this.getLine(this.audioFormat);
                        if (this.line == null) {
                            return;
                        }
                    }
                    if (playedTotal < 150) {
                        AudioThreadMP3 audioThreadMP32 = this;
                        synchronized (audioThreadMP32) {
                            int len = sampleBuffer.getBufferLength();
                            byte[] audioBytes = this.toByteArray(sampleBuffer.getBuffer(), 0, len);
                            int length = len * 2;
                            if (this.destAudioFormat != this.audioFormat) {
                                audioBytes = this.downsample(audioBytes, length);
                                length = audioBytes.length;
                            }
                            this.line.write(audioBytes, 0, len * 2);
                        }
                    } else {
                        int len = sampleBuffer.getBufferLength();
                        byte[] audioBytes = this.toByteArray(sampleBuffer.getBuffer(), 0, len);
                        int length = len * 2;
                        if (this.destAudioFormat != this.audioFormat) {
                            audioBytes = this.downsample(audioBytes, length);
                            length = audioBytes.length;
                        }
                        this.line.write(audioBytes, 0, len * 2);
                    }
                    this.bitstream.closeFrame();
                }
                catch (RuntimeException ex) {
                    ret = false;
                }
                if (!this.totalChanged) {
                    this.totalChanged = this.threadCoordinator.getTotalChanged();
                    if (this.totalChanged) {
                        this.totalLength = this.threadCoordinator.getTotalLength();
                    }
                }
                if (percentageDone == (percentageTemp = framesTotal * 100 / this.totalLength) || !this.totalChanged) continue;
                percentageDone = percentageTemp;
                this.message.setCommand(1);
                this.message.setIntArg(percentageDone);
                this.notifier.sendMessage(this.message);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected byte[] getByteArray(int length) {
        if (this.byteBuf.length < length) {
            this.byteBuf = new byte[length + 1024];
        }
        return this.byteBuf;
    }

    protected byte[] toByteArray(short[] samples, int offs, int len) {
        byte[] b = this.getByteArray(len * 2);
        int idx = 0;
        while (len-- > 0) {
            short s = samples[offs++];
            b[idx++] = (byte)s;
            b[idx++] = (byte)(s >>> 8);
        }
        return b;
    }
}

