/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.AbstractAudioThread;
import com.mamiyaotaru.jukebox.core.threads.IAudioThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;

public class AudioThreadOgg
extends AbstractAudioThread
implements IAudioThread {
    private static final int BUFSIZE = 8192;
    private static int convsize = 16384;
    private static byte[] audioBytes = new byte[convsize];
    private int RETRY;
    private int retry;
    private InputStream inputStream;
    private SyncState syncState;
    private StreamState streamState;
    private Page page;
    private Packet packet;
    private Info info;
    private Comment comment;
    private DspState dspState;
    private Block block;
    private byte[] buffer;
    private int bytes;
    private int rate;
    private int channels;
    private String current_source;
    private int totalLength;
    private boolean totalChanged;

    public AudioThreadOgg(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength, boolean totalChanged) {
        super("OggPlayerThread: " + file.getName());
        this.retry = this.RETRY = 3;
        this.inputStream = null;
        this.buffer = null;
        this.bytes = 0;
        this.rate = 0;
        this.channels = 0;
        this.current_source = null;
        this.totalLength = 10000;
        if (!file.exists()) {
            String path = file.getPath();
            int separator = path.lastIndexOf(".");
            path = path.substring(0, separator);
            file = new File(path);
        }
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
        this.totalChanged = totalChanged;
    }

    @Override
    public synchronized void stopPlayback() {
        this.stopped = true;
        try {
            if (this.line != null) {
                this.line.stop();
                this.line.close();
                this.line = null;
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            System.out.println("err0 " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMyAudioFile(File file, int startPosition) {
        try {
            this.inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        this.currentPosition = 0;
        int percentageDone = 0;
        int percentageTemp = 0;
        this.init_jorbis();
        this.retry = this.RETRY;
        block13: while (!this.stopped) {
            boolean eos = false;
            int index = this.syncState.buffer(8192);
            this.buffer = this.syncState.data;
            try {
                this.bytes = this.inputStream.read(this.buffer, index, 8192);
            }
            catch (Exception e) {
                System.err.println("err.5 " + e);
                return;
            }
            this.syncState.wrote(this.bytes);
            if (this.syncState.pageout(this.page) != 1) {
                if (this.bytes < 8192) break;
                System.err.println("Input does not appear to be an Ogg bitstream.");
                return;
            }
            this.streamState.init(this.page.serialno());
            this.streamState.reset();
            this.info.init();
            this.comment.init();
            if (this.streamState.pagein(this.page) < 0) {
                System.err.println("Error reading first page of Ogg bitstream data.");
                return;
            }
            this.retry = this.RETRY;
            if (this.streamState.packetout(this.packet) != 1) {
                System.err.println("Error reading initial header packet.");
                break;
            }
            if (this.info.synthesis_headerin(this.comment, this.packet) < 0) {
                System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
                return;
            }
            int i = 0;
            while (i < 2) {
                int result;
                while (i < 2 && (result = this.syncState.pageout(this.page)) != 0) {
                    if (result != 1) continue;
                    this.streamState.pagein(this.page);
                    while (i < 2 && (result = this.streamState.packetout(this.packet)) != 0) {
                        if (result == -1) {
                            System.err.println("Corrupt secondary header.  Exiting.");
                            break block13;
                        }
                        this.info.synthesis_headerin(this.comment, this.packet);
                        ++i;
                    }
                }
                index = this.syncState.buffer(8192);
                this.buffer = this.syncState.data;
                try {
                    this.bytes = this.inputStream.read(this.buffer, index, 8192);
                }
                catch (Exception e) {
                    System.err.println("err1 " + e);
                    return;
                }
                if (this.bytes == 0 && i < 2) {
                    System.err.println("End of file before finding all Vorbis headers!");
                    return;
                }
                if (this.currentPosition >= startPosition) {
                    this.syncState.wrote(this.bytes);
                }
                ++this.currentPosition;
            }
            byte[][] ptr = this.comment.user_comments;
            StringBuffer sb = null;
            for (int j = 0; j < ptr.length && ptr[j] != null; ++j) {
                if (sb == null) continue;
                sb.append(" " + new String(ptr[j], 0, ptr[j].length - 1));
            }
            convsize = 8192 / this.info.channels;
            this.dspState.synthesis_init(this.info);
            this.block.init(this.dspState);
            float[][][] _pcmf = new float[1][][];
            int[] _index = new int[this.info.channels];
            AudioThreadOgg j = this;
            synchronized (j) {
                if (!this.stopped) {
                    this.audioFormat = new AudioFormat(this.info.rate, 16, this.info.channels, true, false);
                    this.line = this.getLine(this.audioFormat);
                    if (this.line == null) {
                        return;
                    }
                }
            }
            while (!eos && !this.stopped) {
                int result;
                while (!eos && !this.stopped && (result = this.syncState.pageout(this.page)) != 0) {
                    if (result == -1) continue;
                    this.streamState.pagein(this.page);
                    while (!this.stopped && (result = this.streamState.packetout(this.packet)) != 0) {
                        int samples;
                        if (result == -1) continue;
                        if (this.block.synthesis(this.packet) == 0) {
                            this.dspState.synthesis_blockin(this.block);
                        }
                        while ((samples = this.dspState.synthesis_pcmout(_pcmf, _index)) > 0) {
                            float[][] pcmf = _pcmf[0];
                            boolean clipflag = false;
                            int bout = samples < convsize ? samples : convsize;
                            for (i = 0; i < this.info.channels; ++i) {
                                int ptr2 = i * 2;
                                int mono = _index[i];
                                for (int j2 = 0; j2 < bout; ++j2) {
                                    int val = (int)((double)pcmf[i][mono + j2] * 32767.0);
                                    if (val > Short.MAX_VALUE) {
                                        val = Short.MAX_VALUE;
                                        clipflag = true;
                                    }
                                    if (val < Short.MIN_VALUE) {
                                        val = Short.MIN_VALUE;
                                        clipflag = true;
                                    }
                                    if (val < 0) {
                                        val |= 0x8000;
                                    }
                                    AudioThreadOgg.audioBytes[ptr2] = (byte)val;
                                    AudioThreadOgg.audioBytes[ptr2 + 1] = (byte)(val >>> 8);
                                    ptr2 += 2 * this.info.channels;
                                }
                            }
                            if (this.line != null) {
                                int length = 2 * this.info.channels * bout;
                                if (this.destAudioFormat != this.audioFormat) {
                                    audioBytes = this.downsample(audioBytes, length);
                                    length = audioBytes.length;
                                }
                                this.line.write(audioBytes, 0, length);
                            }
                            this.dspState.synthesis_read(bout);
                        }
                    }
                    if (this.page.eos() == 0) continue;
                    eos = true;
                }
                if (!eos && !this.stopped) {
                    index = this.syncState.buffer(8192);
                    this.buffer = this.syncState.data;
                    try {
                        this.bytes = this.inputStream.read(this.buffer, index, 8192);
                    }
                    catch (Exception e) {
                        System.err.println("err2 " + e);
                        return;
                    }
                    if (this.bytes == -1) break;
                    if (this.currentPosition >= startPosition) {
                        this.syncState.wrote(this.bytes);
                    }
                    ++this.currentPosition;
                    if (this.bytes == 0) {
                        eos = true;
                    }
                }
                if (!this.totalChanged) {
                    this.totalChanged = this.threadCoordinator.getTotalChanged();
                    if (this.totalChanged) {
                        this.totalLength = this.threadCoordinator.getTotalLength();
                    }
                }
                if (percentageDone == (percentageTemp = this.currentPosition * 100 / this.totalLength) || this.currentPosition < startPosition) continue;
                percentageDone = percentageTemp;
                this.message.setCommand(1);
                this.message.setIntArg(percentageDone);
                this.notifier.sendMessage(this.message);
            }
            this.streamState.clear();
            this.block.clear();
            this.dspState.clear();
            this.info.clear();
        }
        this.syncState.clear();
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception e) {
            System.out.println("uncommented exception");
        }
    }

    private void init_jorbis() {
        this.syncState = new SyncState();
        this.streamState = new StreamState();
        this.page = new Page();
        this.packet = new Packet();
        this.info = new Info();
        this.comment = new Comment();
        this.dspState = new DspState();
        this.block = new Block(this.dspState);
        this.buffer = null;
        this.bytes = 0;
        this.syncState.init();
    }
}

