/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.AbstractAudioThread;
import com.mamiyaotaru.jukebox.core.threads.IAudioThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class AudioThreadWAV
extends AbstractAudioThread
implements IAudioThread {
    private int totalLength = 10000;
    private boolean totalChanged;
    private AudioInputStream audioInputStream;

    public AudioThreadWAV(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength, boolean totalChanged) {
        super("WavPlayerThread: " + file.getName());
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.stopped = false;
        this.startPosition = startPosition;
        if (totalChanged) {
            this.totalLength = totalLength;
        }
        this.totalChanged = totalChanged;
    }

    @Override
    public void stopPlayback() {
        this.stopped = true;
        if (this.line != null) {
            this.line.close();
        }
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void readMyAudioFile(File file, int startPosition) {
        this.stopped = false;
        this.audioInputStream = null;
        try {
            this.audioInputStream = AudioSystem.getAudioInputStream(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.audioInputStream == null) {
            System.out.println("###  cannot read input file: " + file.getPath());
            return;
        }
        int EXTERNAL_BUFFER_SIZE = 128000;
        byte[] audioBytes = new byte[EXTERNAL_BUFFER_SIZE];
        AudioFormat.Encoding targetEncoding = AudioFormat.Encoding.PCM_SIGNED;
        this.audioInputStream = AudioSystem.getAudioInputStream(targetEncoding, this.audioInputStream);
        this.audioFormat = this.audioInputStream.getFormat();
        this.line = this.getLine(this.audioFormat);
        if (this.line == null) {
            return;
        }
        int nBytesRead = 0;
        int framesTotal = 0;
        int percentageDone = 0;
        int percentageTemp = 0;
        while (framesTotal < startPosition && nBytesRead != -1 && !this.stopped) {
            try {
                nBytesRead = this.audioInputStream.read(audioBytes, 0, audioBytes.length);
            }
            catch (IOException e) {
                return;
            }
            if (nBytesRead < 0) continue;
            ++framesTotal;
        }
        while (nBytesRead != -1 && !this.stopped) {
            try {
                nBytesRead = this.audioInputStream.read(audioBytes, 0, audioBytes.length);
            }
            catch (IOException e) {
                return;
            }
            if (nBytesRead >= 0) {
                int length = nBytesRead;
                if (this.destAudioFormat != this.audioFormat) {
                    audioBytes = this.downsample(audioBytes, length);
                    length = audioBytes.length;
                }
                int nBytesWritten = this.line.write(audioBytes, 0, length);
                this.currentPosition = ++framesTotal;
            }
            if (!this.totalChanged) {
                this.totalChanged = this.threadCoordinator.getTotalChanged();
                if (this.totalChanged) {
                    this.totalLength = this.threadCoordinator.getTotalLength();
                }
            }
            if (percentageDone == (percentageTemp = framesTotal * 100 / this.totalLength)) continue;
            percentageDone = percentageTemp;
            this.message.setCommand(1);
            this.message.setIntArg(percentageDone);
            this.notifier.sendMessage(this.message);
        }
    }
}

