/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.ILengthThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.kc7bfi.jflac.FLACDecoder;
import org.kc7bfi.jflac.frame.Frame;
import org.kc7bfi.jflac.metadata.Metadata;
import org.kc7bfi.jflac.metadata.SeekTable;

public class LengthThreadFLAC
extends Thread
implements ILengthThread {
    File file;
    boolean stopped;
    int startPosition;
    int totalLength = 10000;
    ThreadCoordinator threadCoordinator;
    Notifier notifier;
    Message message;
    BufferedInputStream bitstream;

    public LengthThreadFLAC(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength) {
        super("lengthThread: " + file.getName());
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.stopped = false;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
    }

    @Override
    public void run() {
        int totalLength = this.getFileLength(this.file);
        if (!this.stopped) {
            this.threadCoordinator.setTotalLength(totalLength);
        }
        this.stopPlayback();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void stopPlayback() {
        this.stopped = true;
        if (this.bitstream != null) {
            try {
                this.bitstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getFileLength(File file) {
        Metadata[] metadata;
        try {
            this.bitstream = new BufferedInputStream(new FileInputStream(file), 32768);
        }
        catch (FileNotFoundException e1) {
            return this.totalLength;
        }
        FLACDecoder flacDecoder = new FLACDecoder(this.bitstream);
        try {
            metadata = flacDecoder.readMetadata();
        }
        catch (IOException e1) {
            return this.totalLength;
        }
        SeekTable seekTable = null;
        for (Metadata metadatum : metadata) {
            if (!(metadatum instanceof SeekTable)) continue;
            seekTable = (SeekTable)metadatum;
        }
        int framesTotal = 0;
        boolean percentageDone = false;
        boolean percentageTemp = false;
        try {
            Frame frame;
            while (!this.stopped && (frame = flacDecoder.readNextFrame()) != null) {
                ++framesTotal;
            }
        }
        catch (Exception e) {
            return this.totalLength;
        }
        return framesTotal;
    }
}

