/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.beatofthedrum.alacdecoder.AlacContext;
import com.beatofthedrum.alacdecoder.AlacUtils;
import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.ILengthThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.aac.SampleBuffer;
import net.sourceforge.jaad.mp4.MP4Container;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import net.sourceforge.jaad.mp4.api.Movie;
import net.sourceforge.jaad.mp4.api.Track;

public class LengthThreadM4A
extends Thread
implements ILengthThread {
    private File file;
    private boolean stopped;
    private int startPosition;
    private int totalLength = 10000;
    private ThreadCoordinator threadCoordinator;
    private Notifier notifier;
    private Message message;
    private RandomAccessFile randomAccessFile;
    private AlacContext alacContext;

    public LengthThreadM4A(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength) {
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.stopped = false;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
    }

    @Override
    public void run() {
        int totalLength = this.getFileLength(this.file);
        if (!this.stopped) {
            this.threadCoordinator.setTotalLength(totalLength);
        }
    }

    @Override
    public void stopPlayback() {
        this.stopped = true;
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.alacContext != null) {
            AlacUtils.AlacCloseFile(this.alacContext);
        }
    }

    @Override
    public int getFileLength(File file) {
        this.stopped = false;
        MP4Container container = null;
        Track track = null;
        Decoder decoder = null;
        try {
            this.randomAccessFile = new RandomAccessFile(file, "r");
            container = new MP4Container(new RandomAccessFile(file, "r"));
            Movie movie = container.getMovie();
            List<Track> tracks = movie.getTracks(AudioTrack.AudioCodec.AAC);
            if (tracks.isEmpty()) {
                return this.getFileLengthALAC(file);
            }
            track = (AudioTrack)tracks.get(0);
            byte[] decoderSpecificInfo = track.getDecoderSpecificInfo();
            decoder = new Decoder(decoderSpecificInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (decoder == null) {
            System.out.println("###  cannot read input file: " + file.getPath());
            return this.totalLength;
        }
        SampleBuffer sampleBuffer = new SampleBuffer();
        int framesTotal = 0;
        try {
            Frame frame;
            while ((frame = track.readNextFrame()) != null && !this.stopped) {
                ++framesTotal;
            }
        }
        catch (AACException e1) {
            e1.printStackTrace();
            return this.totalLength;
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return this.totalLength;
        }
        return framesTotal;
    }

    public int getFileLengthALAC(File file) {
        AlacContext alacContext = AlacUtils.AlacOpenFileInput(file.getPath());
        if (alacContext.error) {
            return this.totalLength;
        }
        int channels = AlacUtils.AlacGetNumChannels(alacContext);
        int samples = AlacUtils.AlacGetNumSamples(alacContext);
        int bytesPerSample = AlacUtils.AlacGetBytesPerSample(alacContext);
        int sampleRate = AlacUtils.AlacGetSampleRate(alacContext);
        int bitsPerSample = AlacUtils.AlacGetBitsPerSample(alacContext);
        boolean framesTotal = false;
        boolean nSamplesTotal = false;
        int[] buffer = new int[73728];
        return samples;
    }
}

