/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.ILengthThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import com.sun.media.sound.AudioSynthesizer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Track;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class LengthThreadMIDI
extends Thread
implements ILengthThread {
    File file;
    boolean stopped;
    int startPosition;
    int totalLength = 10000;
    ThreadCoordinator threadCoordinator;
    Notifier notifier;
    Message message;
    Sequencer sequencer;
    InputStream is;
    private AudioInputStream audioInputStream;
    protected AudioFormat audioFormat = null;
    protected AudioFormat destAudioFormat = null;

    public LengthThreadMIDI(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength) {
        super("lengthThread: " + file.getName());
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.stopped = false;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
    }

    @Override
    public void run() {
        int totalLength = this.getFileLength(this.file);
        if (!this.stopped) {
            this.threadCoordinator.setTotalLength(totalLength);
        }
        this.stopPlayback();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void stopPlayback() {
        this.stopped = true;
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.sequencer != null) {
            this.sequencer.close();
        }
        try {
            if (this.is != null) {
                this.is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getFileLength(File file) {
        int length = 100;
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.open();
            this.is = new BufferedInputStream(new FileInputStream(file));
            this.sequencer.setSequence(this.is);
            Sequence sequence = this.sequencer.getSequence();
            AudioSynthesizer synth = this.findAudioSynthesizer();
            if (synth == null) {
                System.out.println("No AudioSynthesizer was found!");
                return length;
            }
            AudioFormat format = new AudioFormat(48000.0f, 16, 2, true, false);
            HashMap<String, Object> p = new HashMap<String, Object>();
            p.put("interpolation", "sinc");
            p.put("max polyphony", "1024");
            this.audioInputStream = synth.openStream(format, p);
            double total = this.send(sequence, synth.getReceiver());
            long len = (long)((double)this.audioInputStream.getFormat().getFrameRate() * (total + 4.0));
            this.audioInputStream = new AudioInputStream(this.audioInputStream, this.audioInputStream.getFormat(), len);
            int EXTERNAL_BUFFER_SIZE = 128000;
            byte[] abData = new byte[EXTERNAL_BUFFER_SIZE];
            int nBytesRead = 0;
            int framesTotal = 0;
            while (nBytesRead != -1) {
                try {
                    nBytesRead = this.audioInputStream.read(abData, 0, abData.length);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (nBytesRead < 0) continue;
                ++framesTotal;
            }
            return framesTotal;
        }
        catch (MidiUnavailableException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        return length;
    }

    private AudioSynthesizer findAudioSynthesizer() throws MidiUnavailableException {
        Synthesizer synth = MidiSystem.getSynthesizer();
        if (synth instanceof AudioSynthesizer) {
            return (AudioSynthesizer)synth;
        }
        MidiDevice.Info[] midiDeviceInfo = MidiSystem.getMidiDeviceInfo();
        for (int i = 0; i < midiDeviceInfo.length; ++i) {
            MidiDevice dev = MidiSystem.getMidiDevice(midiDeviceInfo[i]);
            if (!(dev instanceof AudioSynthesizer)) continue;
            return (AudioSynthesizer)dev;
        }
        return null;
    }

    private double send(Sequence seq, Receiver recv) {
        float divtype = seq.getDivisionType();
        assert (seq.getDivisionType() == 0.0f);
        Track[] tracks = seq.getTracks();
        int[] trackspos = new int[tracks.length];
        int mpq = 500000;
        int seqres = seq.getResolution();
        long lasttick = 0L;
        long curtime = 0L;
        while (!this.stopped) {
            MidiEvent selevent = null;
            int seltrack = -1;
            for (int i = 0; i < tracks.length; ++i) {
                int trackpos = trackspos[i];
                Track track = tracks[i];
                if (trackpos >= track.size()) continue;
                MidiEvent event = track.get(trackpos);
                if (selevent != null && event.getTick() >= selevent.getTick()) continue;
                selevent = event;
                seltrack = i;
            }
            if (seltrack == -1) break;
            int n = seltrack;
            trackspos[n] = trackspos[n] + 1;
            long tick = selevent.getTick();
            curtime = divtype == 0.0f ? (curtime += (tick - lasttick) * (long)mpq / (long)seqres) : (long)((double)tick * 1000000.0 * (double)divtype / (double)seqres);
            lasttick = tick;
            MidiMessage msg = selevent.getMessage();
            if (msg instanceof MetaMessage) {
                if (divtype != 0.0f || ((MetaMessage)msg).getType() != 81) continue;
                byte[] data = ((MetaMessage)msg).getData();
                mpq = (data[0] & 0xFF) << 16 | (data[1] & 0xFF) << 8 | data[2] & 0xFF;
                continue;
            }
            if (recv == null) continue;
            recv.send(msg, curtime);
        }
        return (double)curtime / 1000000.0;
    }
}

