/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.ILengthThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;
import java.io.FileInputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.player.Player;

public class LengthThreadMP3
extends Thread
implements ILengthThread {
    File file;
    boolean stopped;
    int startPosition;
    int totalLength = 10000;
    ThreadCoordinator threadCoordinator;
    Notifier notifier;
    Message message;
    Bitstream bitstream;
    Player MP3player;

    public LengthThreadMP3(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength) {
        super("lengthThread: " + file.getName());
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.stopped = false;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
    }

    @Override
    public void run() {
        int totalLength = this.getFileLength(this.file);
        if (!this.stopped) {
            this.threadCoordinator.setTotalLength(totalLength);
        }
        this.stopPlayback();
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public synchronized void stopPlayback() {
        this.stopped = true;
        if (this.bitstream != null) {
            try {
                this.bitstream.close();
            }
            catch (BitstreamException bitstreamException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFileLength(File file) {
        int frames = Integer.MAX_VALUE;
        boolean ret = true;
        int framesTotal = 0;
        Decoder decoder = new Decoder();
        try {
            LengthThreadMP3 lengthThreadMP3 = this;
            synchronized (lengthThreadMP3) {
                FileInputStream fileInputStream = new FileInputStream(file);
                this.bitstream = new Bitstream(fileInputStream);
            }
            while (frames-- > 0 && ret) {
                ++framesTotal;
                try {
                    Header header = this.bitstream.readFrame();
                    if (header == null) {
                        ret = false;
                        break;
                    }
                    this.bitstream.closeFrame();
                }
                catch (RuntimeException ex) {
                    ret = false;
                }
                ret = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return framesTotal;
    }
}

