/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.ILengthThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class LengthThreadOgg
extends Thread
implements ILengthThread {
    private static final int BUFSIZE = 8192;
    private static int convsize = 16384;
    private static byte[] convbuffer = new byte[convsize];
    private int RETRY;
    private int retry;
    private InputStream inputStream;
    private SyncState syncState;
    private StreamState streamState;
    private Page page;
    private Packet packet;
    private Info info;
    private Comment comment;
    private DspState dspState;
    private Block block;
    private byte[] buffer;
    private int bytes;
    private int rate;
    private int channels;
    private String current_source;
    private int frameSizeInBytes;
    private int bufferLengthInBytes;
    private File file;
    private boolean stopped;
    private int startPosition;
    private int totalLength;
    private ThreadCoordinator threadCoordinator;
    private Notifier notifier;
    private Message message;

    public LengthThreadOgg(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength) {
        this.retry = this.RETRY = 3;
        this.inputStream = null;
        this.buffer = null;
        this.bytes = 0;
        this.rate = 0;
        this.channels = 0;
        this.current_source = null;
        this.totalLength = 10000;
        if (!file.exists()) {
            String path = file.getPath();
            int separator = path.lastIndexOf(".");
            path = path.substring(0, separator);
            file = new File(path);
        }
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.stopped = false;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
    }

    @Override
    public void run() {
        int totalLength = this.getFileLength(this.file);
        if (!this.stopped) {
            this.threadCoordinator.setTotalLength(totalLength);
        }
        this.stopPlayback();
    }

    @Override
    public synchronized void stopPlayback() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getFileLength(File file) {
        try {
            this.inputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return this.totalLength;
        }
        this.totalLength = 0;
        this.init_jorbis();
        this.retry = this.RETRY;
        block8: while (!this.stopped) {
            boolean eos = false;
            int index = this.syncState.buffer(8192);
            this.buffer = this.syncState.data;
            try {
                this.bytes = this.inputStream.read(this.buffer, index, 8192);
            }
            catch (Exception e) {
                System.err.println(e);
                return this.totalLength;
            }
            this.syncState.wrote(this.bytes);
            if (this.syncState.pageout(this.page) != 1) {
                if (this.bytes < 8192) break;
                System.err.println("Input does not appear to be an Ogg bitstream.");
                return this.totalLength;
            }
            this.streamState.init(this.page.serialno());
            this.streamState.reset();
            this.info.init();
            this.comment.init();
            if (this.streamState.pagein(this.page) < 0) {
                System.err.println("Error reading first page of Ogg bitstream data.");
                return this.totalLength;
            }
            this.retry = this.RETRY;
            if (this.streamState.packetout(this.packet) != 1) {
                System.err.println("Error reading initial header packet.");
                break;
            }
            if (this.info.synthesis_headerin(this.comment, this.packet) < 0) {
                System.err.println("This Ogg bitstream does not contain Vorbis audio data.");
                return this.totalLength;
            }
            int i = 0;
            while (i < 2) {
                int result;
                while (i < 2 && (result = this.syncState.pageout(this.page)) != 0) {
                    if (result != 1) continue;
                    this.streamState.pagein(this.page);
                    while (i < 2 && (result = this.streamState.packetout(this.packet)) != 0) {
                        if (result == -1) {
                            System.err.println("Corrupt secondary header.  Exiting.");
                            break block8;
                        }
                        this.info.synthesis_headerin(this.comment, this.packet);
                        ++i;
                    }
                }
                index = this.syncState.buffer(8192);
                this.buffer = this.syncState.data;
                try {
                    this.bytes = this.inputStream.read(this.buffer, index, 8192);
                }
                catch (Exception e) {
                    System.err.println("err1 " + e);
                    return this.totalLength;
                }
                if (this.bytes == 0 && i < 2) {
                    System.err.println("End of file before finding all Vorbis headers!");
                    return this.totalLength;
                }
                ++this.totalLength;
            }
            byte[][] ptr = this.comment.user_comments;
            StringBuffer sb = null;
            for (int j = 0; j < ptr.length && ptr[j] != null; ++j) {
                if (sb == null) continue;
                sb.append(" " + new String(ptr[j], 0, ptr[j].length - 1));
            }
            convsize = 8192 / this.info.channels;
            this.dspState.synthesis_init(this.info);
            this.block.init(this.dspState);
            float[][][] _pcmf = new float[1][][];
            int[] _index = new int[this.info.channels];
            while (!eos) {
                int result;
                while (!eos && (result = this.syncState.pageout(this.page)) != 0) {
                    if (result == -1) continue;
                    this.streamState.pagein(this.page);
                    while ((result = this.streamState.packetout(this.packet)) != 0) {
                        int samples;
                        if (result == -1) continue;
                        if (this.block.synthesis(this.packet) == 0) {
                            this.dspState.synthesis_blockin(this.block);
                        }
                        while ((samples = this.dspState.synthesis_pcmout(_pcmf, _index)) > 0) {
                            float[][] pcmf = _pcmf[0];
                            boolean clipflag = false;
                            int bout = samples < convsize ? samples : convsize;
                            for (i = 0; i < this.info.channels; ++i) {
                                int ptr2 = i * 2;
                                int mono = _index[i];
                                for (int j = 0; j < bout; ++j) {
                                    int val = (int)((double)pcmf[i][mono + j] * 32767.0);
                                    if (val > Short.MAX_VALUE) {
                                        val = Short.MAX_VALUE;
                                        clipflag = true;
                                    }
                                    if (val < Short.MIN_VALUE) {
                                        val = Short.MIN_VALUE;
                                        clipflag = true;
                                    }
                                    if (val < 0) {
                                        val |= 0x8000;
                                    }
                                    LengthThreadOgg.convbuffer[ptr2] = (byte)val;
                                    LengthThreadOgg.convbuffer[ptr2 + 1] = (byte)(val >>> 8);
                                    ptr2 += 2 * this.info.channels;
                                }
                            }
                            this.dspState.synthesis_read(bout);
                        }
                    }
                    if (this.page.eos() == 0) continue;
                    eos = true;
                }
                if (eos || this.stopped) continue;
                index = this.syncState.buffer(8192);
                this.buffer = this.syncState.data;
                try {
                    this.bytes = this.inputStream.read(this.buffer, index, 8192);
                }
                catch (Exception e) {
                    System.err.println("err2 " + e);
                    return this.totalLength;
                }
                if (this.bytes == -1) break;
                ++this.totalLength;
                if (this.bytes != 0) continue;
                eos = true;
            }
            this.streamState.clear();
            this.block.clear();
            this.dspState.clear();
            this.info.clear();
        }
        this.syncState.clear();
        return this.totalLength;
    }

    private void init_jorbis() {
        this.syncState = new SyncState();
        this.streamState = new StreamState();
        this.page = new Page();
        this.packet = new Packet();
        this.info = new Info();
        this.comment = new Comment();
        this.dspState = new DspState();
        this.block = new Block(this.dspState);
        this.buffer = null;
        this.bytes = 0;
        this.syncState.init();
    }
}

