/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.core.threads;

import com.mamiyaotaru.jukebox.core.Message;
import com.mamiyaotaru.jukebox.core.Notifier;
import com.mamiyaotaru.jukebox.core.threads.ILengthThread;
import com.mamiyaotaru.jukebox.core.threads.ThreadCoordinator;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class LengthThreadWAV
extends Thread
implements ILengthThread {
    private File file;
    private boolean stopped;
    private int startPosition;
    private int totalLength = 10000;
    private ThreadCoordinator threadCoordinator;
    private Notifier notifier;
    private Message message;
    private AudioInputStream audioInputStream;

    public LengthThreadWAV(File file, ThreadCoordinator threadCoordinator, Notifier notifier, Message message, int startPosition, int totalLength) {
        this.file = file;
        this.threadCoordinator = threadCoordinator;
        this.notifier = notifier;
        this.message = message;
        this.stopped = false;
        this.startPosition = startPosition;
        this.totalLength = totalLength;
    }

    @Override
    public void run() {
        int totalLength = this.getFileLength(this.file);
        if (!this.stopped) {
            this.threadCoordinator.setTotalLength(totalLength);
        }
    }

    @Override
    public void stopPlayback() {
        this.stopped = true;
        if (this.audioInputStream != null) {
            try {
                this.audioInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getFileLength(File file) {
        this.audioInputStream = null;
        try {
            this.audioInputStream = AudioSystem.getAudioInputStream(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.audioInputStream == null) {
            System.out.println("###  cannot read input file: " + file.getPath());
            return 10000;
        }
        int EXTERNAL_BUFFER_SIZE = 128000;
        byte[] abData = new byte[EXTERNAL_BUFFER_SIZE];
        int nBytesRead = 0;
        int framesTotal = 0;
        while (nBytesRead != -1) {
            try {
                nBytesRead = this.audioInputStream.read(abData, 0, abData.length);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (nBytesRead < 0) continue;
            ++framesTotal;
        }
        return framesTotal;
    }
}

