/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.ui;

import com.mamiyaotaru.jukebox.FilesystemObject;
import com.mamiyaotaru.jukebox.Jukebox;
import com.mamiyaotaru.jukebox.ModConfigJukebox;
import com.mamiyaotaru.jukebox.ui.GuiJukeboxOptions;
import com.mamiyaotaru.jukebox.ui.GuiSlotJukebox;
import com.mamiyaotaru.jukebox.ui.overridden.EnumOptionsJukebox;
import com.mamiyaotaru.jukebox.ui.overridden.GuiOptionSliderJukebox;
import com.mamiyaotaru.jukebox.ui.overridden.Popup;
import com.mamiyaotaru.jukebox.ui.overridden.PopupGuiButton;
import com.mamiyaotaru.jukebox.ui.overridden.PopupGuiScreen;
import com.mamiyaotaru.jukebox.utils.I18nUtils;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class GuiJukebox
extends PopupGuiScreen {
    private static final EnumOptionsJukebox[] relevantOptions = new EnumOptionsJukebox[]{EnumOptionsJukebox.PROGRESS, EnumOptionsJukebox.VOLUME};
    private final class_437 parentScreen;
    private Jukebox jukebox;
    protected final ModConfigJukebox options;
    protected String screenTitle = "Jukebox";
    private GuiSlotJukebox fileList;
    private class_4185 buttonPrevious;
    private class_4185 buttonPlay;
    private class_4185 buttonPause;
    private class_4185 buttonStop;
    private class_4185 buttonNext;
    private class_4185 buttonSortName;
    private class_4185 buttonSortCreated;
    private class_4185 buttonSortDistance;
    private class_4185 buttonSortColor;
    private String tooltip = null;
    protected FilesystemObject selectedFilesystemObject = null;
    private boolean changedSort = false;
    private boolean exiting = false;

    public GuiJukebox(class_437 parentScreen, Jukebox jukebox) {
        this.jukebox = jukebox;
        this.parentScreen = parentScreen;
        this.options = jukebox.options;
    }

    public void init() {
        int buttonWidth;
        this.screenTitle = I18nUtils.getString("jukebox.title");
        this.fileList = new GuiSlotJukebox(this, this.jukebox);
        for (int t = 0; t < relevantOptions.length; ++t) {
            EnumOptionsJukebox option = relevantOptions[t];
            if (!option.getEnumFloat()) continue;
            float value = this.options.getOptionFloatValue(option) / 100.0f;
            buttonWidth = this.getWidth() / 2 - 12;
            int separation = 4;
            this.addButton((class_339)new GuiOptionSliderJukebox(10 + t % 2 * (buttonWidth + separation), 32, buttonWidth, 20, option, value, this.options, this, null));
        }
        int sideMargin = 10;
        int buttonCount = 5;
        int buttonSeparation = 4;
        buttonWidth = (this.width - sideMargin * 2 - buttonSeparation * (buttonCount - 1)) / buttonCount;
        this.buttonPrevious = new PopupGuiButton(sideMargin + 0 * (buttonWidth + buttonSeparation), this.getHeight() - 52, buttonWidth, 20, I18nUtils.getString("jukebox.previous"), this, null){

            public void onPress() {
                GuiJukebox.this.jukebox.action(114);
            }
        };
        this.addButton((class_339)this.buttonPrevious);
        this.buttonPlay = new PopupGuiButton(sideMargin + 1 * (buttonWidth + buttonSeparation), this.getHeight() - 52, buttonWidth, 20, I18nUtils.getString("jukebox.play"), this, null){

            public void onPress() {
                GuiJukebox.this.jukebox.action(111);
            }
        };
        this.addButton((class_339)this.buttonPlay);
        this.buttonPause = new PopupGuiButton(sideMargin + 2 * (buttonWidth + buttonSeparation), this.getHeight() - 52, buttonWidth, 20, I18nUtils.getString("jukebox.pause"), this, null){

            public void onPress() {
                GuiJukebox.this.jukebox.action(112);
            }
        };
        this.addButton((class_339)this.buttonPause);
        this.buttonStop = new PopupGuiButton(sideMargin + 3 * (buttonWidth + buttonSeparation), this.getHeight() - 52, buttonWidth, 20, I18nUtils.getString("jukebox.stop"), this, null){

            public void onPress() {
                GuiJukebox.this.jukebox.action(116);
            }
        };
        this.addButton((class_339)this.buttonStop);
        this.buttonNext = new PopupGuiButton(sideMargin + 4 * (buttonWidth + buttonSeparation), this.getHeight() - 52, buttonWidth, 20, I18nUtils.getString("jukebox.next"), this, null){

            public void onPress() {
                GuiJukebox.this.jukebox.action(115);
            }
        };
        this.addButton((class_339)this.buttonNext);
        this.addButton((class_339)new PopupGuiButton(sideMargin + 3 * (buttonWidth + buttonSeparation), this.getHeight() - 28, buttonWidth, 20, I18nUtils.getString("menu.options"), this, null){

            public void onPress() {
                GuiJukebox.this.minecraft.method_1507((class_437)new GuiJukeboxOptions(GuiJukebox.this, GuiJukebox.this.options));
            }
        });
        this.addButton((class_339)new PopupGuiButton(sideMargin + 4 * (buttonWidth + buttonSeparation), this.getHeight() - 28, buttonWidth, 20, I18nUtils.getString("gui.done"), this, null){

            public void onPress() {
                GuiJukebox.this.minecraft.method_1507(GuiJukebox.this.parentScreen);
            }
        });
        boolean isSomethingSelected = this.selectedFilesystemObject != null;
        this.buttonPlay.active = this.jukebox.player.isPlaying() || this.jukebox.player.isPaused() || this.jukebox.getCurrentDirectoryContents().size() > 0;
        this.buttonPause.active = this.jukebox.player.isPlaying() || this.jukebox.player.isPaused();
        this.buttonStop.active = this.jukebox.player.isPlaying() || this.jukebox.player.isPaused();
        this.buttonPause.setMessage(I18nUtils.getString(this.jukebox.player.isPaused() ? "jukebox.unpause" : "jukebox.pause"));
        this.sort();
    }

    private void sort() {
    }

    @Override
    public void popupAction(Popup popup, int action) {
    }

    protected void setSelectedObject(FilesystemObject file) {
        this.selectedFilesystemObject = file;
        boolean isSomethingSelected = this.selectedFilesystemObject != null;
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        if (this.options.keyBindMenu.method_1417(keysm, scancode)) {
            keysm = 256;
            scancode = -1;
            b = -1;
        }
        return super.keyPressed(keysm, scancode, b);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.options.keyBindMenu.method_1417(keyCode, -1)) {
            super.keyPressed(256, -1, -1);
        }
        return super.charTyped(typedChar, keyCode);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.fileList != null) {
            this.fileList.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.fileList != null) {
            this.fileList.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        return this.fileList.mouseScrolled(mouseX, mouseY, amount);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        return this.fileList.mouseDragged(mouseX, mouseY, mouseEvent, deltaX, deltaY);
    }

    @Override
    public void render(int par1, int par2, float par3) {
        this.tooltip = null;
        this.fileList.render(par1, par2, par3);
        this.drawCenteredString(this.font, this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.render(par1, par2, par3);
        if (this.tooltip != null) {
            this.renderTooltip(this.tooltip, par1, par2);
        }
        GuiOptionSliderJukebox progressSlider = (GuiOptionSliderJukebox)((Object)this.buttons.get(0));
        progressSlider.sliderValue = (float)this.options.reportedProgress / 100.0f;
        String s = this.options.getKeyText(EnumOptionsJukebox.PROGRESS);
        progressSlider.setMessage(s);
        progressSlider.active = this.jukebox.player.isPaused() || this.jukebox.player.isPlaying();
        boolean isSomethingSelected = this.selectedFilesystemObject != null;
        this.buttonPlay.active = this.jukebox.player.isPlaying() || this.jukebox.player.isPaused() || this.jukebox.getCurrentDirectoryContents().size() > 0;
        this.buttonPause.active = this.jukebox.player.isPlaying() || this.jukebox.player.isPaused();
        this.buttonStop.active = this.jukebox.player.isPlaying() || this.jukebox.player.isPaused();
        this.buttonPause.setMessage(I18nUtils.getString(this.jukebox.player.isPaused() ? "jukebox.unpause" : "jukebox.pause"));
    }

    public void renderTooltip(String par1Str, int par2, int par3) {
        if (par1Str != null) {
            int var4 = par2 + 12;
            int var5 = par3 - 12;
            int var6 = this.font.method_1727(par1Str);
            this.fillGradient(var4 - 3, var5 - 3, var4 + var6 + 3, var5 + 8 + 3, -1073741824, -1073741824);
            this.font.method_1720(par1Str, (float)var4, (float)var5, -1);
        }
    }

    static String setTooltip(GuiJukebox par0GuiWaypoints, String par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    static class_4185 getButtonEdit(GuiJukebox par0GuiWaypoints) {
        return par0GuiWaypoints.buttonPrevious;
    }

    static class_4185 getButtonDelete(GuiJukebox par0GuiWaypoints) {
        return par0GuiWaypoints.buttonPlay;
    }

    static class_4185 getButtonTeleport(GuiJukebox par0GuiWaypoints) {
        return par0GuiWaypoints.buttonPause;
    }

    public void removed() {
        this.exiting = true;
        this.minecraft.field_1690.field_1868 = this.options.realScale;
        this.minecraft.method_15993();
        this.options.saveAll();
    }

    public void init(class_310 minecraft, int p_146280_2_, int p_146280_3_) {
        if (!this.exiting) {
            int guiScale = Math.min(2, minecraft.field_1690.field_1868 == 0 ? 1000 : minecraft.field_1690.field_1868);
            if (guiScale != minecraft.field_1690.field_1868) {
                minecraft.field_1690.field_1868 = guiScale;
                minecraft.method_15993();
            }
            super.init(minecraft, minecraft.field_1704.method_4486(), minecraft.field_1704.method_4502());
        } else {
            this.exiting = false;
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public class_327 getFontRenderer() {
        return this.font;
    }
}

