/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.ui;

import com.mamiyaotaru.jukebox.FilesystemObject;
import com.mamiyaotaru.jukebox.Jukebox;
import com.mamiyaotaru.jukebox.ui.GuiJukebox;
import com.mamiyaotaru.jukebox.ui.overridden.Popup;
import com.mamiyaotaru.jukebox.ui.overridden.PopupGuiSlot;
import com.mamiyaotaru.jukebox.utils.GLShim;
import com.mamiyaotaru.jukebox.utils.GLUtils;
import com.mamiyaotaru.jukebox.utils.I18nUtils;
import java.util.ArrayList;
import net.minecraft.class_2588;
import net.minecraft.class_333;
import net.minecraft.class_350;
import net.minecraft.class_437;

class GuiSlotJukebox
extends PopupGuiSlot {
    final GuiJukebox parentGui;
    private Jukebox jukebox;

    public GuiSlotJukebox(GuiJukebox par1GuiJukebox, Jukebox jukebox) {
        super(par1GuiJukebox.options.game, par1GuiJukebox.getWidth(), par1GuiJukebox.getHeight(), 56, par1GuiJukebox.getHeight() - 65 + 4, 18);
        this.parentGui = par1GuiJukebox;
        this.jukebox = jukebox;
        this.populate();
    }

    private void populate() {
        JukeboxItem playing = null;
        FilesystemObject playingFOB = this.jukebox.getSelected();
        this.clearEntries();
        for (FilesystemObject fob : this.jukebox.getCurrentDirectoryContents()) {
            JukeboxItem item = new JukeboxItem(this.parentGui, fob);
            this.addEntry(item);
            if (!fob.equals(playingFOB)) continue;
            playing = item;
        }
        if (playing != null) {
            this.ensureVisible(playing);
        }
    }

    public void setSelected(class_350.class_351 item) {
        this.setSelected((JukeboxItem)item);
    }

    public void setSelected(JukeboxItem item) {
        super.setSelected((class_350.class_351)item);
        if (this.getSelected() instanceof JukeboxItem) {
            class_333.field_2054.method_19788(new class_2588("narrator.select", new Object[]{((JukeboxItem)this.getSelected()).fileSystemObject.getName()}).getString());
        }
        this.parentGui.setSelectedObject(item.fileSystemObject);
    }

    public int getRowWidth() {
        return this.width - 20;
    }

    protected int getScrollbarPosition() {
        return this.width - 7;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (mouseY > (double)this.field_19085 && mouseY < (double)this.field_19086 && mouseButton == 1) {
            int mouseDirectX = (int)this.minecraft.field_1729.method_1603();
            int mouseDirectY = (int)this.minecraft.field_1729.method_1604();
            ArrayList<Popup.PopupEntry> entries = new ArrayList<Popup.PopupEntry>();
            entries.add(new Popup.PopupEntry("Easter Egg!", 0, true, true));
            entries.add(new Popup.PopupEntry("Popup experiment:", 0, true, true));
            entries.add(new Popup.PopupEntry("not functional", 0, true, true));
            entries.add(new Popup.PopupEntry("at the moment", 0, true, true));
            entries.add(new Popup.PopupEntry("but proof of", 0, true, true));
            entries.add(new Popup.PopupEntry("concept; could be", 0, true, true));
            entries.add(new Popup.PopupEntry("used later!", 0, true, true));
            this.parentGui.createPopup((int)mouseX, (int)mouseY, mouseDirectX, mouseDirectY, entries);
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    protected boolean isSelectedItem(int par1) {
        return ((JukeboxItem)this.getEntry(par1)).fileSystemObject.equals(this.parentGui.selectedFilesystemObject);
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight;
    }

    public void renderBackground() {
        this.parentGui.renderBackground();
    }

    protected void sortBy(int sortKey, boolean ascending) {
        int order = ascending ? 1 : -1;
    }

    public class JukeboxItem
    extends class_350.class_351<JukeboxItem> {
        private final GuiJukebox parentGui;
        private final FilesystemObject fileSystemObject;

        protected JukeboxItem(GuiJukebox jukeboxScreen, FilesystemObject fileSystemObject) {
            this.parentGui = jukeboxScreen;
            this.fileSystemObject = fileSystemObject;
        }

        public void render(int slotIndex, int slotYPos, int leftEdge, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            String name = this.fileSystemObject.getName();
            if (((GuiSlotJukebox)GuiSlotJukebox.this).jukebox.currentDirectory != null && this.fileSystemObject.equals(((GuiSlotJukebox)GuiSlotJukebox.this).jukebox.currentDirectory.getParent())) {
                name = ".. " + I18nUtils.getString("jukebox.parent") + " (" + name + ")";
            } else if (this.fileSystemObject.equals(((GuiSlotJukebox)GuiSlotJukebox.this).jukebox.currentDirectory)) {
                name = ". " + I18nUtils.getString("jukebox.current") + " (" + name + ")";
            }
            this.parentGui.drawString(this.parentGui.getFontRenderer(), name, leftEdge + 18, slotYPos + 3, 0xFFFFFF);
            if (mouseX < leftEdge || mouseY < slotYPos || mouseX > leftEdge + GuiSlotJukebox.this.width || mouseY <= slotYPos + GuiSlotJukebox.this.itemHeight) {
                // empty if block
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.fileSystemObject.equals(((GuiSlotJukebox)GuiSlotJukebox.this).jukebox.currentlyPlaying)) {
                GLUtils.img("textures/item/music_disc_cat.png");
                class_437.blit((int)leftEdge, (int)(slotYPos - 2), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                GLUtils.img("textures/particle/note.png");
                boolean xOffset = false;
                boolean yOffset = false;
                class_437.blit((int)(GuiSlotJukebox.this.width - 26), (int)(slotYPos - 2), (float)((float)xOffset), (float)((float)yOffset), (int)8, (int)8, (int)8, (int)8);
            } else {
                GLUtils.img(this.fileSystemObject.getIcon());
                class_437.blit((int)leftEdge, (int)(slotYPos - 2), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            if (this.parentGui.clickedPopup(mouseX, mouseY)) {
                return false;
            }
            GuiSlotJukebox.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int width = 215;
            if (GuiSlotJukebox.this.doubleclick) {
                boolean sameDirectory = this.parentGui.selectedFilesystemObject == ((GuiSlotJukebox)GuiSlotJukebox.this).jukebox.currentDirectory;
                GuiSlotJukebox.this.jukebox.openFile(this.parentGui.selectedFilesystemObject);
                if (!sameDirectory && (this.parentGui.selectedFilesystemObject.isDirectory() || this.parentGui.selectedFilesystemObject.isPlaylist())) {
                    GuiSlotJukebox.this.populate();
                }
            }
            return true;
        }
    }
}

