/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.jukebox.ui.overridden;

import com.mamiyaotaru.jukebox.ui.overridden.IPopupGuiScreen;
import com.mamiyaotaru.jukebox.ui.overridden.Popup;
import java.util.ArrayList;
import net.minecraft.class_310;
import net.minecraft.class_350;

public abstract class PopupGuiSlot
extends class_350
implements IPopupGuiScreen {
    private ArrayList<Popup> popups = new ArrayList();
    protected long lastClicked = 0L;
    public boolean doubleclick = false;

    public PopupGuiSlot(class_310 par1Minecraft, int width, int height, int top, int bottom, int slotHeight) {
        super(par1Minecraft, width, height, top, bottom, slotHeight);
    }

    public void createPopup(int x, int y, int directX, int directY, ArrayList<Popup.PopupEntry> entries) {
        this.popups.add(new Popup(x, y, directX, directY, entries, this));
    }

    public void clearPopups() {
        this.popups.clear();
    }

    public boolean clickedPopup(double x, double y) {
        boolean clicked = false;
        ArrayList<Popup> deadPopups = new ArrayList<Popup>();
        for (Popup popup : this.popups) {
            boolean clickedPopup = popup.clickedMe(x, y);
            if (!clickedPopup) {
                deadPopups.add(popup);
            } else if (popup.shouldClose()) {
                deadPopups.add(popup);
            }
            clicked = clicked || clickedPopup;
        }
        this.popups.removeAll(deadPopups);
        return clicked;
    }

    @Override
    public boolean overPopup(int x, int y) {
        boolean over = false;
        for (Popup popup : this.popups) {
            boolean overPopup = popup.overMe(x, y);
            over = over || overPopup;
        }
        return over;
    }

    @Override
    public boolean popupOpen() {
        return this.popups.size() > 0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.clickedPopup(mouseX, mouseY)) {
            return false;
        }
        this.doubleclick = System.currentTimeMillis() - this.lastClicked < 250L;
        this.lastClicked = System.currentTimeMillis();
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public void popupAction(Popup popup, int action) {
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

