/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr;

import java.util.Arrays;
import net.sourceforge.jaad.aac.sbr.SBRTables;

class Calculation
implements SBRTables {
    Calculation() {
    }

    static int getStartChannel(int startFrequency, int sampleRate) {
        int index = Calculation.getSampleRateIndex(sampleRate);
        return START_MIN_TABLE[index] + START_OFFSETS[OFFSET_INDEX_TABLE[index]][startFrequency];
    }

    static int getStopChannel(int stopFrequency, int sampleRate, int k0) {
        if (stopFrequency == 15) {
            return Math.min(64, k0 * 3);
        }
        if (stopFrequency == 14) {
            return Math.min(64, k0 * 2);
        }
        int index = Calculation.getSampleRateIndex(sampleRate);
        return Math.min(64, STOP_MIN_TABLE[index] + STOP_OFFSETS[index][Math.min(stopFrequency, 13)]);
    }

    static int getSampleRateIndex(int samplerate) {
        if (92017 <= samplerate) {
            return 0;
        }
        if (75132 <= samplerate) {
            return 1;
        }
        if (55426 <= samplerate) {
            return 2;
        }
        if (46009 <= samplerate) {
            return 3;
        }
        if (37566 <= samplerate) {
            return 4;
        }
        if (27713 <= samplerate) {
            return 5;
        }
        if (23004 <= samplerate) {
            return 6;
        }
        if (18783 <= samplerate) {
            return 7;
        }
        if (13856 <= samplerate) {
            return 8;
        }
        if (11502 <= samplerate) {
            return 9;
        }
        if (9391 <= samplerate) {
            return 10;
        }
        return 11;
    }

    static int[] calculateMasterFrequencyTableFS0(int k0, int k2, boolean alterScale) {
        int i;
        if (k2 <= k0) {
            return null;
        }
        int dk = alterScale ? 2 : 1;
        int nrBands = alterScale ? k2 - k0 + 2 >> 2 << 1 : k2 - k0 >> 1 << 1;
        if ((nrBands = Math.min(nrBands, 63)) <= 0) {
            return new int[0];
        }
        int k2Achieved = k0 + nrBands * dk;
        int k2Diff = k2 - k2Achieved;
        int[] vDk = new int[64];
        for (i = 0; i < nrBands; ++i) {
            vDk[i] = dk;
        }
        if (k2Diff != 0) {
            int incr = k2Diff > 0 ? -1 : 1;
            int n = i = k2Diff > 0 ? nrBands - 1 : 0;
            while (k2Diff != 0) {
                int n2 = i;
                vDk[n2] = vDk[n2] - incr;
                i += incr;
                k2Diff += incr;
            }
        }
        int len = Math.min(nrBands + 1, 64);
        int[] table = new int[len];
        table[0] = k0;
        for (i = 1; i < len; ++i) {
            table[i] = table[i - 1] + vDk[i - 1];
        }
        return table;
    }

    static int[] calculateMasterFrequencyTable(int k0, int k2, int frequencyScale, boolean alterScale) {
        int[] ret;
        int A_0;
        int i;
        int k1;
        boolean twoRegions;
        if (k2 <= k0) {
            return null;
        }
        int bands = MFT_BANDS_COUNT[frequencyScale - 1];
        if ((double)((float)k2 / (float)k0) > 2.2449) {
            twoRegions = true;
            k1 = k0 << 1;
        } else {
            twoRegions = false;
            k1 = k2;
        }
        int nrBand0 = Math.min(2 * Calculation.findBands(false, bands, k0, k1), 63);
        if (nrBand0 <= 0) {
            return new int[0];
        }
        int[] vDk0 = new int[64];
        double q = Calculation.findInitialPower(nrBand0, k0, k1);
        double qk = k0;
        int A_1 = (int)(qk + 0.5);
        for (i = 0; i <= nrBand0; ++i) {
            A_0 = A_1;
            A_1 = (int)Math.round(qk *= q);
            vDk0[i] = A_1 - A_0;
        }
        Arrays.sort(vDk0, 0, nrBand0);
        int[] vk0 = new int[64];
        vk0[0] = k0;
        for (i = 1; i <= nrBand0; ++i) {
            vk0[i] = vk0[i - 1] + vDk0[i - 1];
            if (vDk0[i - 1] != 0) continue;
            return new int[0];
        }
        if (twoRegions) {
            int nrBand1 = Math.min(2 * Calculation.findBands(true, bands, k1, k2), 63);
            int[] vDk1 = new int[64];
            q = Calculation.findInitialPower(nrBand1, k1, k2);
            qk = k1;
            A_1 = (int)(qk + 0.5);
            for (i = 0; i <= nrBand1 - 1; ++i) {
                A_0 = A_1;
                A_1 = (int)((qk *= q) + 0.5);
                vDk1[i] = A_1 - A_0;
            }
            if (vDk1[0] < vDk0[nrBand0 - 1]) {
                Arrays.sort(vDk1, 0, nrBand1 + 1);
                int change = vDk0[nrBand0 - 1] - vDk1[0];
                vDk1[0] = vDk0[nrBand0 - 1];
                vDk1[nrBand1 - 1] = vDk1[nrBand1 - 1] - change;
            }
            int[] vk1 = new int[64];
            Arrays.sort(vDk1, 0, nrBand1);
            vk1[0] = k1;
            for (i = 1; i <= nrBand1; ++i) {
                vk1[i] = vk1[i - 1] + vDk1[i - 1];
                if (vDk1[i - 1] != 0) continue;
                return new int[0];
            }
            int off = nrBand0 + 1;
            int len = Math.min(off + nrBand1, 64);
            ret = new int[len];
            System.arraycopy(vk0, 0, ret, 0, off);
            System.arraycopy(vk1, 1, ret, off, nrBand1);
        } else {
            int len = Math.min(nrBand0 + 1, 64);
            ret = new int[len];
            System.arraycopy(vk0, 0, ret, 0, len);
        }
        return ret;
    }

    static int findBands(boolean warp, int bands, int a0, int a1) {
        double div = Math.log(2.0);
        if (warp) {
            div *= 1.3;
        }
        return (int)((double)bands * Math.log((double)a1 / (double)a0) / div + 0.5);
    }

    private static double findInitialPower(int bands, int a0, int a1) {
        return Math.pow((double)a1 / (double)a0, 1.0 / (double)bands);
    }
}

