/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import net.sourceforge.jaad.aac.sbr2.FilterbankTables;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;

class AnalysisFilterbank
implements SBRConstants,
FilterbankTables {
    private final float[][][] COEFS;
    private final float[][] X = new float[2][320];
    private final float[] z = new float[320];
    private final float[] u = new float[64];

    AnalysisFilterbank() {
        this.COEFS = new float[32][64][2];
        for (int k = 0; k < 32; ++k) {
            for (int n = 0; n < 64; ++n) {
                double tmp = 0.04908738521234052 * ((double)k + 0.5) * ((double)(2 * n) - 0.5);
                this.COEFS[k][n][0] = (float)(2.0 * Math.cos(tmp));
                this.COEFS[k][n][1] = (float)(2.0 * Math.sin(tmp));
            }
        }
    }

    public void process(float[] in, float[][][] out, int ch) {
        float[] x = this.X[ch];
        int inOff = 0;
        for (int l = 0; l < 32; ++l) {
            int k;
            int n;
            for (n = 319; n >= 32; --n) {
                x[n] = x[n - 32];
            }
            for (n = 31; n >= 0; --n) {
                x[n] = in[inOff];
                ++inOff;
            }
            for (n = 0; n < 320; ++n) {
                this.z[n] = (float)((double)x[n] * WINDOW[2 * n]);
            }
            for (n = 0; n < 64; ++n) {
                this.u[n] = this.z[n];
                for (k = 1; k < 5; ++k) {
                    int n2 = n;
                    this.u[n2] = this.u[n2] + this.z[n + k * 64];
                }
            }
            for (k = 0; k < 32; ++k) {
                out[k][l][0] = this.u[0] * this.COEFS[k][0][0];
                out[k][l][1] = this.u[0] * this.COEFS[k][0][1];
                for (n = 1; n < 64; ++n) {
                    float[] fArray = out[k][l];
                    fArray[0] = fArray[0] + this.u[n] * this.COEFS[k][n][0];
                    float[] fArray2 = out[k][l];
                    fArray2[1] = fArray2[1] + this.u[n] * this.COEFS[k][n][1];
                }
            }
        }
    }
}

