/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import java.util.Arrays;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.sbr2.FrequencyTables;
import net.sourceforge.jaad.aac.sbr2.HuffmanTables;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;
import net.sourceforge.jaad.aac.sbr2.SBRHeader;
import net.sourceforge.jaad.aac.syntax.BitStream;

class ChannelData
implements SBRConstants,
HuffmanTables {
    private boolean ampRes;
    private int frameClass;
    private int envCount;
    private int envCountPrev;
    private int noiseCount;
    private final int[] freqRes = new int[5];
    private int freqResPrevious;
    private int pointer;
    private int la;
    private int laPrevious;
    private final boolean[] dfEnv;
    private final boolean[] dfNoise;
    private final int[] invfMode = new int[5];
    private final int[] invfModePrevious = new int[5];
    private final float[][] envelopeSF;
    private final float[] envelopeSFPrevious;
    private final int[] te;
    private int tePrevious = 0;
    private final float[][] noiseFloorData;
    private final float[] noiseFDPrevious;
    private final int[] tq;
    private boolean sinusoidalsPresent;
    private final boolean[] sinusoidals;
    private final boolean[] sIndexMappedPrevious;
    private final float[] bwArray;
    private int noiseIndex;
    private int sineIndex;
    private int lTemp;
    private final float[][] gTmp;
    private final float[][] qTmp;

    ChannelData() {
        this.dfEnv = new boolean[5];
        this.dfNoise = new boolean[2];
        this.envelopeSF = new float[5][64];
        this.envelopeSFPrevious = new float[64];
        this.te = new int[6];
        this.noiseFloorData = new float[2][64];
        this.noiseFDPrevious = new float[64];
        this.tq = new int[3];
        this.sinusoidals = new boolean[64];
        this.sIndexMappedPrevious = new boolean[64];
        Arrays.fill(this.sIndexMappedPrevious, false);
        this.bwArray = new float[5];
        this.lTemp = 0;
        this.gTmp = new float[42][48];
        this.qTmp = new float[42][48];
    }

    void savePreviousData() {
        this.lTemp = 2 * this.te[this.envCount] - 32;
        this.envCountPrev = this.envCount;
        this.freqResPrevious = this.freqRes[this.freqRes.length - 1];
        this.laPrevious = this.la;
        this.tePrevious = this.te[this.envCountPrev];
        System.arraycopy(this.invfMode, 0, this.invfModePrevious, 0, 5);
    }

    void decodeGrid(BitStream in, SBRHeader header, FrequencyTables tables) throws AACException {
        int absBordTrail = 16;
        this.ampRes = header.getAmpRes();
        this.frameClass = in.readBits(2);
        switch (this.frameClass) {
            case 0: {
                int i;
                this.envCount = 1 << in.readBits(2);
                int relLead = this.envCount - 1;
                if (this.envCount == 1) {
                    this.ampRes = false;
                } else if (this.envCount > 4) {
                    throw new AACException("SBR: too many envelopes: " + this.envCount);
                }
                Arrays.fill(this.freqRes, in.readBit());
                this.te[0] = 0;
                this.te[this.envCount] = absBordTrail;
                absBordTrail = (absBordTrail + (this.envCount >> 1)) / this.envCount;
                for (i = 0; i < relLead; ++i) {
                    this.te[i + 1] = this.te[i] + absBordTrail;
                }
                break;
            }
            case 1: {
                int i;
                int relTrail = in.readBits(2);
                this.envCount = relTrail + 1;
                this.te[0] = 0;
                this.te[this.envCount] = absBordTrail += in.readBits(2);
                for (i = 0; i < relTrail; ++i) {
                    this.te[this.envCount - 1 - i] = this.te[this.envCount - i] - 2 * in.readBits(2) - 2;
                }
                this.pointer = in.readBits(CEIL_LOG2[this.envCount]);
                for (i = 0; i < this.envCount; ++i) {
                    this.freqRes[this.envCount - 1 - i] = in.readBit();
                }
                break;
            }
            case 2: {
                int i;
                this.te[0] = in.readBits(2);
                int relLead = in.readBits(2);
                this.envCount = relLead + 1;
                this.te[this.envCount] = absBordTrail;
                for (i = 0; i < relLead; ++i) {
                    this.te[i + 1] = this.te[i] + 2 * in.readBits(2) + 2;
                }
                this.pointer = in.readBits(CEIL_LOG2[this.envCount]);
                for (i = 0; i < this.envCount; ++i) {
                    this.freqRes[i] = in.readBit();
                }
                break;
            }
            default: {
                int i;
                this.te[0] = in.readBits(2);
                absBordTrail += in.readBits(2);
                int relLead = in.readBits(2);
                int relTrail = in.readBits(2);
                this.envCount = relLead + relTrail + 1;
                if (this.envCount > 5) {
                    throw new AACException("SBR: too many envelopes: " + this.envCount);
                }
                this.te[this.envCount] = absBordTrail;
                for (i = 0; i < relLead; ++i) {
                    this.te[i + 1] = this.te[i] + 2 * in.readBits(2) + 2;
                }
                for (i = 0; i < relTrail; ++i) {
                    this.te[this.envCount - 1 - i] = this.te[this.envCount - i] - 2 * in.readBits(2) - 2;
                }
                this.pointer = in.readBits(CEIL_LOG2[this.envCount]);
                for (i = 0; i < this.envCount; ++i) {
                    this.freqRes[i] = in.readBit();
                }
            }
        }
        this.noiseCount = this.envCount > 1 ? 2 : 1;
        this.tq[0] = this.te[0];
        this.tq[this.noiseCount] = this.te[this.envCount];
        if (this.envCount == 1) {
            this.tq[1] = this.te[1];
        } else {
            int middleBorder;
            switch (this.frameClass) {
                case 0: {
                    middleBorder = this.envCount / 2;
                    break;
                }
                case 2: {
                    if (this.pointer == 0) {
                        middleBorder = 1;
                        break;
                    }
                    if (this.pointer == 1) {
                        middleBorder = this.envCount - 1;
                        break;
                    }
                    middleBorder = this.pointer - 1;
                    break;
                }
                default: {
                    middleBorder = this.pointer > 1 ? this.envCount + 1 - this.pointer : this.envCount - 1;
                }
            }
            this.tq[1] = this.te[middleBorder];
        }
        this.la = (this.frameClass == 1 || this.frameClass == 3) && this.pointer > 0 ? this.envCount + 1 - this.pointer : (this.frameClass == 2 && this.pointer > 1 ? this.pointer - 1 : -1);
    }

    void decodeDTDF(BitStream in) throws AACException {
        int i;
        for (i = 0; i < this.envCount; ++i) {
            this.dfEnv[i] = in.readBool();
        }
        for (i = 0; i < this.noiseCount; ++i) {
            this.dfNoise[i] = in.readBool();
        }
    }

    void decodeInvf(BitStream in, SBRHeader header, FrequencyTables tables) throws AACException {
        for (int i = 0; i < tables.getNq(); ++i) {
            this.invfMode[i] = in.readBits(2);
        }
    }

    void decodeEnvelope(BitStream in, SBRHeader header, FrequencyTables tables, boolean secCh, boolean coupling) throws AACException {
        int fLav;
        int[][] fHuff;
        int tLav;
        int[][] tHuff;
        int bits;
        int delta;
        if (coupling && secCh) {
            delta = 1;
            if (this.ampRes) {
                bits = 5;
                tHuff = T_HUFFMAN_ENV_BAL_3_0;
                tLav = 12;
                fHuff = F_HUFFMAN_ENV_BAL_3_0;
                fLav = 12;
            } else {
                bits = 6;
                tHuff = T_HUFFMAN_ENV_BAL_1_5;
                tLav = 24;
                fHuff = F_HUFFMAN_ENV_BAL_1_5;
                fLav = 24;
            }
        } else {
            delta = 0;
            if (this.ampRes) {
                bits = 6;
                tHuff = T_HUFFMAN_ENV_3_0;
                tLav = 31;
                fHuff = F_HUFFMAN_ENV_3_0;
                fLav = 31;
            } else {
                bits = 7;
                tHuff = T_HUFFMAN_ENV_1_5;
                tLav = 60;
                fHuff = F_HUFFMAN_ENV_1_5;
                fLav = 60;
            }
        }
        int[] envBands = tables.getN();
        int odd = envBands[1] & 1;
        for (int i = 0; i < this.envCount; ++i) {
            int j;
            int frPrev;
            float[] prev = i == 0 ? this.envelopeSFPrevious : this.envelopeSF[i - 1];
            int n = frPrev = i == 0 ? this.freqResPrevious : this.freqRes[i - 1];
            if (this.dfEnv[i]) {
                int k;
                if (this.freqRes[i] == frPrev) {
                    for (j = 0; j < envBands[this.freqRes[i]]; ++j) {
                        this.envelopeSF[i][j] = prev[j] + (float)(this.decodeHuffman(in, tHuff) - tLav << delta);
                    }
                    continue;
                }
                if (this.freqRes[i] == 1) {
                    for (j = 0; j < envBands[this.freqRes[i]]; ++j) {
                        k = j + odd >> 1;
                        this.envelopeSF[i][j] = prev[k] + (float)(this.decodeHuffman(in, tHuff) - tLav << delta);
                    }
                    continue;
                }
                for (j = 0; j < envBands[this.freqRes[i]]; ++j) {
                    k = j != 0 ? 2 * j - odd : 0;
                    this.envelopeSF[i][j] = prev[k] + (float)(this.decodeHuffman(in, tHuff) - tLav << delta);
                }
                continue;
            }
            this.envelopeSF[i][0] = in.readBits(bits) << delta;
            for (j = 1; j < envBands[this.freqRes[i]]; ++j) {
                this.envelopeSF[i][j] = this.envelopeSF[i][j - 1] + (float)(this.decodeHuffman(in, fHuff) - fLav << delta);
            }
        }
        System.arraycopy(this.envelopeSF[this.envCount - 1], 0, this.envelopeSFPrevious, 0, 64);
    }

    void decodeNoise(BitStream in, SBRHeader header, FrequencyTables tables, boolean secCh, boolean coupling) throws AACException {
        int fLav;
        int[][] fHuff;
        int tLav;
        int[][] tHuff;
        int delta;
        if (coupling && secCh) {
            delta = 1;
            tHuff = T_HUFFMAN_NOISE_BAL_3_0;
            tLav = 12;
            fHuff = F_HUFFMAN_NOISE_BAL_3_0;
            fLav = 12;
        } else {
            delta = 0;
            tHuff = T_HUFFMAN_NOISE_3_0;
            tLav = 31;
            fHuff = F_HUFFMAN_NOISE_3_0;
            fLav = 31;
        }
        int noiseBands = tables.getNq();
        for (int i = 0; i < this.noiseCount; ++i) {
            int j;
            if (this.dfNoise[i]) {
                float[] prev = i == 0 ? this.noiseFDPrevious : this.noiseFloorData[i - 1];
                for (j = 0; j < noiseBands; ++j) {
                    this.noiseFloorData[i][j] = prev[j] + (float)(this.decodeHuffman(in, tHuff) - tLav << delta);
                }
                continue;
            }
            this.noiseFloorData[i][0] = in.readBits(5) << delta;
            for (j = 1; j < noiseBands; ++j) {
                this.noiseFloorData[i][j] = this.noiseFloorData[i][j - 1] + (float)(this.decodeHuffman(in, fHuff) - fLav << delta);
            }
        }
        System.arraycopy(this.noiseFloorData[this.noiseCount - 1], 0, this.noiseFDPrevious, 0, 64);
    }

    void decodeSinusoidal(BitStream in, SBRHeader header, FrequencyTables tables) throws AACException {
        this.sinusoidalsPresent = in.readBool();
        if (this.sinusoidalsPresent) {
            for (int i = 0; i < tables.getN(1); ++i) {
                this.sinusoidals[i] = in.readBool();
            }
        } else {
            Arrays.fill(this.sinusoidals, false);
        }
    }

    private int decodeHuffman(BitStream in, int[][] table) throws AACException {
        int j;
        int off = 0;
        int len = table[off][0];
        for (int cw = in.readBits(len); cw != table[off][1]; cw |= in.readBits(j)) {
            j = table[++off][0] - len;
            len = table[off][0];
            cw <<= j;
        }
        return table[off][2];
    }

    public boolean getAmpRes() {
        return this.ampRes;
    }

    public float[][] getEnvelopeScalefactors() {
        return this.envelopeSF;
    }

    public int getEnvCount() {
        return this.envCount;
    }

    public int getEnvCountPrevious() {
        return this.envCountPrev;
    }

    public int[] getTe() {
        return this.te;
    }

    public int getTePrevious() {
        return this.tePrevious;
    }

    public float[][] getNoiseFloorData() {
        return this.noiseFloorData;
    }

    public int getNoiseCount() {
        return this.noiseCount;
    }

    public int[] getTq() {
        return this.tq;
    }

    public int[] getFrequencyResolutions() {
        return this.freqRes;
    }

    int getFrameClass() {
        return this.frameClass;
    }

    public int getLa(boolean previous) {
        return previous ? (this.laPrevious == this.envCountPrev ? 0 : -1) : this.la;
    }

    int getPointer() {
        return this.pointer;
    }

    public boolean areSinusoidalsPresent() {
        return this.sinusoidalsPresent;
    }

    public boolean[] getSinusoidals() {
        return this.sinusoidals;
    }

    public boolean[] getSIndexMappedPrevious() {
        return this.sIndexMappedPrevious;
    }

    void setSIndexMappedPrevious(boolean[] sIndexMapped) {
        Arrays.fill(this.sIndexMappedPrevious, false);
        System.arraycopy(sIndexMapped, 0, this.sIndexMappedPrevious, 0, sIndexMapped.length);
    }

    int[] getInvfMode(boolean previous) {
        return previous ? this.invfModePrevious : this.invfMode;
    }

    float[] getChirpFactors() {
        return this.bwArray;
    }

    int getNoiseIndex() {
        return this.noiseIndex;
    }

    void setNoiseIndex(int noiseIndex) {
        this.noiseIndex = noiseIndex;
    }

    int getSineIndex() {
        return this.sineIndex;
    }

    void setSineIndex(int sineIndex) {
        this.sineIndex = sineIndex;
    }

    public int getLTemp() {
        return this.lTemp;
    }

    public float[][] getGTmp() {
        return this.gTmp;
    }

    public float[][] getQTmp() {
        return this.qTmp;
    }

    void copyGrid(ChannelData cd) {
        this.ampRes = cd.getAmpRes();
        this.frameClass = cd.getFrameClass();
        this.envCount = cd.getEnvCount();
        this.noiseCount = cd.getNoiseCount();
        System.arraycopy(cd.getFrequencyResolutions(), 0, this.freqRes, 0, this.envCount);
        System.arraycopy(cd.getTe(), 0, this.te, 0, this.te.length);
        System.arraycopy(cd.getTq(), 0, this.tq, 0, this.tq.length);
        this.pointer = cd.getPointer();
    }

    void copyInvf(ChannelData cd) {
        System.arraycopy(cd.getInvfMode(false), 0, this.invfMode, 0, 5);
    }
}

