/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import java.util.Arrays;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.SampleFrequency;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;
import net.sourceforge.jaad.aac.sbr2.SBRHeader;

class FrequencyTables
implements SBRConstants {
    private static final int[] MFT_START_MIN = new int[]{7, 7, 10, 11, 12, 16, 16, 17, 24};
    private static final int[] MFT_STOP_MIN = new int[]{13, 15, 20, 21, 23, 32, 32, 35, 48};
    private static final int[] MFT_SF_OFFSETS = new int[]{5, 5, 4, 4, 4, 3, 2, 1, 0};
    private static final int[][] MFT_START_OFFSETS = new int[][]{{-8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7}, {-5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 9, 11, 13}, {-5, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 9, 11, 13, 16}, {-6, -4, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 9, 11, 13, 16}, {-4, -2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 9, 11, 13, 16, 20}, {-2, -1, 0, 1, 2, 3, 4, 5, 6, 7, 9, 11, 13, 16, 20, 24}};
    private static final int[][] MFT_STOP_OFFSETS = new int[][]{{2, 4, 6, 8, 11, 14, 18, 22, 26, 31, 37, 44, 51}, {2, 4, 6, 8, 11, 14, 18, 22, 26, 31, 36, 42, 49}, {2, 4, 6, 9, 11, 14, 17, 21, 25, 29, 34, 39, 44}, {2, 4, 6, 9, 11, 14, 17, 21, 24, 28, 33, 38, 43}, {2, 4, 6, 9, 11, 14, 17, 20, 24, 28, 32, 36, 41}, {2, 4, 6, 8, 10, 12, 14, 17, 20, 23, 26, 29, 32}, {2, 4, 6, 8, 10, 12, 14, 17, 20, 23, 26, 29, 32}, {2, 3, 5, 7, 9, 11, 13, 16, 18, 21, 23, 26, 29}, {1, 2, 3, 4, 6, 7, 8, 9, 11, 12, 13, 15, 16}};
    private static final int[] MFT_INPUT1 = new int[]{12, 10, 8};
    private static final float[] MFT_INPUT2 = new float[]{1.0f, 1.3f};
    private static final float[] LIM_BANDS_PER_OCTAVE_POW = new float[]{1.3271518f, 1.1850928f, 1.1198716f};
    private static final float GOAL_SB_FACTOR = 2048000.0f;
    int k0;
    int k2;
    private int[] mft;
    private int nMaster;
    private final int[][] fTable;
    private final int[] n = new int[2];
    private int m = 0;
    private int mPrev = 0;
    private int kx = 0;
    private int kxPrev = 0;
    private int[] fNoise;
    int nq;
    private int[] fLim;
    private int nl;
    private int patchCount;
    private final int[] patchSubbands;
    private final int[] patchStartSubband;
    private int[] patchBorders;

    FrequencyTables() {
        this.fTable = new int[2][];
        this.patchSubbands = new int[6];
        this.patchStartSubband = new int[6];
    }

    void calculate(SBRHeader header, int sampleRate) throws AACException {
        this.calculateMFT(header, sampleRate);
        this.calculateFrequencyTables(header);
        this.calculateNoiseTable(header);
        this.calculatePatches(sampleRate);
        this.calculateLimiterTable(header);
    }

    private void calculateMFT(SBRHeader header, int sampleRate) throws AACException {
        int sfIndex = SampleFrequency.forFrequency(sampleRate).getIndex();
        int sfOff = MFT_SF_OFFSETS[sfIndex];
        this.k0 = MFT_START_MIN[sfIndex] + MFT_START_OFFSETS[sfOff][header.getStartFrequency(false)];
        int stop = header.getStopFrequency(false);
        int x = stop == 15 ? 3 * this.k0 : (stop == 14 ? 2 * this.k0 : MFT_STOP_MIN[sfIndex] + MFT_STOP_OFFSETS[sfOff][header.getStopFrequency(false) - 1]);
        this.k2 = Math.min(64, x);
        if (this.k0 >= this.k2) {
            throw new AACException("SBR: MFT borders out of range: lower=" + this.k0 + ", higher=" + this.k2);
        }
        int max = sampleRate == 44100 ? 35 : (sampleRate >= 48000 ? 32 : 48);
        if (this.k2 - this.k0 > max) {
            throw new AACException("SBR: too many subbands: " + (this.k2 - this.k0) + ", maximum number for samplerate " + sampleRate + ": " + max);
        }
        if (header.getFrequencyScale(false) == 0) {
            this.calculateMFT1(header, this.k0, this.k2);
        } else {
            this.calculateMFT2(header, this.k0, this.k2);
        }
        if (header.getXOverBand(false) >= this.nMaster) {
            throw new AACException("SBR: illegal length of master frequency table: " + this.nMaster + ", xOverBand: " + header.getXOverBand(false));
        }
    }

    private void calculateMFT1(SBRHeader header, int k0, int k2) throws AACException {
        int k2Diff;
        int dk;
        if (header.isAlterScale(false)) {
            dk = 2;
            this.nMaster = 2 * Math.round((float)(k2 - k0) / 4.0f);
        } else {
            dk = 1;
            this.nMaster = 2 * (int)((float)(k2 - k0) / 2.0f);
        }
        if (this.nMaster <= 0) {
            throw new AACException("SBR: illegal number of bands for master frequency table: " + this.nMaster);
        }
        int k2Achieved = k0 + this.nMaster * dk;
        int[] vDk = new int[this.nMaster];
        Arrays.fill(vDk, dk);
        if (k2Diff != 0) {
            int k;
            int incr = k2Diff > 0 ? -1 : 1;
            int n = k = k2Diff > 0 ? this.nMaster - 1 : 0;
            for (k2Diff = k2 - k2Achieved; k2Diff != 0; k2Diff += incr) {
                int n2 = k;
                vDk[n2] = vDk[n2] - incr;
                k += incr;
            }
        }
        this.mft = new int[this.nMaster + 1];
        this.mft[0] = k0;
        for (int i = 1; i <= this.nMaster; ++i) {
            this.mft[i] = this.mft[i - 1] + vDk[i - 1];
        }
    }

    private void calculateMFT2(SBRHeader header, int k0, int k2) throws AACException {
        float pow2;
        float pow1;
        int k1;
        boolean twoRegions;
        int bands = MFT_INPUT1[header.getFrequencyScale(false) - 1];
        float warp = MFT_INPUT2[header.isAlterScale(false) ? 1 : 0];
        float div1 = (float)k2 / (float)k0;
        if ((double)div1 > 2.2449) {
            twoRegions = true;
            k1 = 2 * k0;
        } else {
            twoRegions = false;
            k1 = k2;
        }
        float div2 = (float)k1 / (float)k0;
        float log = (float)Math.log(div2) / 1.3862944f;
        int bandCount0 = 2 * Math.round((float)bands * log);
        if (bandCount0 <= 0) {
            throw new AACException("SBR: illegal band count for master frequency table: " + bandCount0);
        }
        int[] vDk0 = new int[bandCount0];
        for (int i = 0; i < bandCount0; ++i) {
            pow1 = (float)Math.pow(div2, (float)(i + 1) / (float)bandCount0);
            pow2 = (float)Math.pow(div2, (float)i / (float)bandCount0);
            vDk0[i] = Math.round((float)k0 * pow1) - Math.round((float)k0 * pow2);
            if (vDk0[i] > 0) continue;
            throw new AACException("SBR: illegal value in master frequency table: " + vDk0[i]);
        }
        Arrays.sort(vDk0);
        int[] vk0 = new int[bandCount0 + 1];
        vk0[0] = k0;
        for (int i = 1; i <= bandCount0; ++i) {
            vk0[i] = vk0[i - 1] + vDk0[i - 1];
        }
        if (twoRegions) {
            div1 = (float)k2 / (float)k1;
            log = (float)Math.log(div1);
            int bandCount1 = 2 * (int)Math.round((double)((float)bands * log) / (1.3862943611198906 * (double)warp));
            int[] vDk1 = new int[bandCount1];
            int min = -1;
            for (int i = 0; i < bandCount1; ++i) {
                pow1 = (float)Math.pow(div1, (float)(i + 1) / (float)bandCount1);
                pow2 = (float)Math.pow(div1, (float)i / (float)bandCount1);
                vDk1[i] = Math.round((float)k1 * pow1) - Math.round((float)k1 * pow2);
                if (min < 0 || vDk1[i] < min) {
                    min = vDk1[i];
                    continue;
                }
                if (vDk1[i] > 0) continue;
                throw new AACException("SBR: illegal value in master frequency table: " + vDk1[i]);
            }
            if (min < vDk0[vDk0.length - 1]) {
                Arrays.sort(vDk1);
                int change = vDk0[vDk0.length - 1] - vDk1[0];
                int x = (int)((double)vDk1[bandCount1 - 1] - (double)vDk1[0] / 2.0);
                if (change > x) {
                    change = x;
                }
                vDk1[0] = vDk1[0] + change;
                int n = bandCount1 - 1;
                vDk1[n] = vDk1[n] - change;
            }
            Arrays.sort(vDk1);
            int[] vk1 = new int[bandCount1 + 1];
            vk1[0] = k1;
            for (int i = 1; i <= bandCount1; ++i) {
                vk1[i] = vk1[i - 1] + vDk1[i - 1];
            }
            this.nMaster = bandCount0 + bandCount1;
            this.mft = new int[this.nMaster + 1];
            System.arraycopy(vk0, 0, this.mft, 0, bandCount0 + 1);
            System.arraycopy(vk1, 1, this.mft, bandCount0 + 1, bandCount1);
        } else {
            this.nMaster = bandCount0;
            this.mft = new int[this.nMaster + 1];
            System.arraycopy(vk0, 0, this.mft, 0, this.nMaster + 1);
        }
    }

    private void calculateFrequencyTables(SBRHeader header) throws AACException {
        int xover = header.getXOverBand(false);
        this.n[1] = this.getNMaster() - xover;
        this.fTable[1] = new int[this.n[1] + 1];
        System.arraycopy(this.mft, xover, this.fTable[1], 0, this.n[1] + 1);
        this.kxPrev = this.kx;
        this.kx = this.fTable[1][0];
        this.mPrev = this.m;
        this.m = this.fTable[1][this.getN(1)] - this.kx;
        if (this.kx > 32) {
            throw new AACException("SBR: start frequency border out of range: " + this.kx);
        }
        if (this.kx + this.m > 64) {
            throw new AACException("SBR: stop frequency border out of range: " + (this.kx + this.m));
        }
        int half = (int)((double)this.n[1] / 2.0);
        this.n[0] = half + (this.n[1] - 2 * half);
        this.fTable[0] = new int[this.n[0] + 1];
        this.fTable[0][0] = this.fTable[1][0];
        int div = this.n[1] & 1;
        for (int i = 1; i <= this.n[0]; ++i) {
            this.fTable[0][i] = this.fTable[1][2 * i - div];
        }
    }

    private void calculateNoiseTable(SBRHeader header) throws AACException {
        float log = (float)Math.log((float)this.k2 / (float)this.kx) / 0.6931472f;
        int x = Math.round((float)header.getNoiseBands(false) * log);
        this.nq = Math.max(1, x);
        if (this.nq > 5) {
            throw new AACException("SBR: too many noise floor scalefactors: " + this.nq);
        }
        this.fNoise = new int[this.nq + 1];
        this.fNoise[0] = this.fTable[0][0];
        int i = 0;
        for (int k = 1; k <= this.nq; ++k) {
            i += (int)((float)(this.n[0] - i) / (float)(this.nq + 1 - k));
            this.fNoise[k] = this.fTable[0][i];
        }
    }

    private void calculatePatches(int sampleRate) throws AACException {
        int sb;
        int k;
        int msb = this.k0;
        int usb = this.kx;
        this.patchCount = 0;
        int goalSb = Math.round(2048000.0f / (float)sampleRate);
        if (goalSb < this.kx + this.m) {
            k = 0;
            int i = 0;
            while (this.mft[i] < goalSb) {
                k = i + 1;
                ++i;
            }
        } else {
            k = this.nMaster;
        }
        do {
            int odd;
            int j = k + 1;
            while ((sb = this.mft[--j]) > this.k0 - 1 + msb - (odd = sb - 2 + this.k0 & 1)) {
            }
            this.patchSubbands[this.patchCount] = Math.max(sb - usb, 0);
            this.patchStartSubband[this.patchCount] = this.k0 - odd - this.patchSubbands[this.patchCount];
            if (this.patchSubbands[this.patchCount] > 0) {
                usb = sb;
                msb = sb;
                ++this.patchCount;
            } else {
                msb = this.kx;
            }
            if (this.mft[k] - sb >= 3) continue;
            k = this.nMaster;
        } while (sb != this.kx + this.m);
        if (this.patchSubbands[this.patchCount - 1] < 3 && this.patchCount > 1) {
            --this.patchCount;
        }
        if (this.patchCount > 5) {
            throw new AACException("SBR: too many patches: " + this.patchCount);
        }
    }

    private void calculateLimiterTable(SBRHeader header) throws AACException {
        int bands = header.getLimiterBands();
        if (bands == 0) {
            this.fLim = new int[]{this.fTable[0][0], this.fTable[0][this.n[0]]};
            this.nl = 1;
            this.patchBorders = new int[0];
        } else {
            float limBandsPerOctaveWarped = LIM_BANDS_PER_OCTAVE_POW[header.getLimiterBands() - 1];
            this.patchBorders = new int[this.patchCount + 1];
            this.patchBorders[0] = this.kx;
            for (int i = 1; i <= this.patchCount; ++i) {
                this.patchBorders[i] = this.patchBorders[i - 1] + this.patchSubbands[i - 1];
            }
            int[] limTable = new int[this.n[0] + this.patchCount];
            System.arraycopy(this.fTable[0], 0, limTable, 0, this.n[0] + 1);
            if (this.patchCount > 1) {
                System.arraycopy(this.patchBorders, 1, limTable, this.n[0] + 1, this.patchCount - 1);
            }
            Arrays.sort(limTable);
            int in = 1;
            int out = 0;
            int lims = this.n[0] + this.patchCount - 1;
            while (out < lims) {
                if ((float)limTable[in] >= (float)limTable[out] * limBandsPerOctaveWarped) {
                    limTable[++out] = limTable[in++];
                    continue;
                }
                if (limTable[in] == limTable[out] || !this.inArray(this.patchBorders, limTable[in])) {
                    ++in;
                    --lims;
                    continue;
                }
                if (!this.inArray(this.patchBorders, limTable[out])) {
                    limTable[out] = limTable[in++];
                    --lims;
                    continue;
                }
                limTable[++out] = limTable[in++];
            }
            this.fLim = new int[lims + 1];
            System.arraycopy(limTable, 0, this.fLim, 0, lims + 1);
            this.nl = lims;
        }
    }

    private boolean inArray(int[] a, int x) {
        boolean found = false;
        for (int i = 0; !found && i < a.length; ++i) {
            if (a[i] != x) continue;
            found = true;
        }
        return found;
    }

    public int getK0() {
        return this.k0;
    }

    public int getK2() {
        return this.k2;
    }

    public int[] getMFT() {
        return this.mft;
    }

    public int getNMaster() {
        return this.nMaster;
    }

    public int[] getFrequencyTable(int i) {
        return this.fTable[i];
    }

    public int getN(int i) {
        return this.n[i];
    }

    public int[] getN() {
        return this.n;
    }

    public int getKx(boolean previous) {
        return previous ? this.kxPrev : this.kx;
    }

    public int getM(boolean previous) {
        return previous ? this.mPrev : this.m;
    }

    public int[] getNoiseTable() {
        return this.fNoise;
    }

    public int getNq() {
        return this.nq;
    }

    public int getPatchCount() {
        return this.patchCount;
    }

    public int[] getPatchSubbands() {
        return this.patchSubbands;
    }

    public int[] getPatchStartSubband() {
        return this.patchStartSubband;
    }

    public int[] getPatchBorders() {
        return this.patchBorders;
    }

    public int[] getLimiterTable() {
        return this.fLim;
    }

    public int getNl() {
        return this.nl;
    }
}

