/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac.sbr2;

import java.util.logging.Level;
import net.sourceforge.jaad.aac.AACException;
import net.sourceforge.jaad.aac.SampleFrequency;
import net.sourceforge.jaad.aac.ps2.PS;
import net.sourceforge.jaad.aac.sbr2.AnalysisFilterbank;
import net.sourceforge.jaad.aac.sbr2.ChannelData;
import net.sourceforge.jaad.aac.sbr2.FrequencyTables;
import net.sourceforge.jaad.aac.sbr2.HFAdjuster;
import net.sourceforge.jaad.aac.sbr2.HFGenerator;
import net.sourceforge.jaad.aac.sbr2.SBRConstants;
import net.sourceforge.jaad.aac.sbr2.SBRHeader;
import net.sourceforge.jaad.aac.sbr2.SynthesisFilterbank;
import net.sourceforge.jaad.aac.syntax.BitStream;
import net.sourceforge.jaad.aac.syntax.Constants;

public class SBR
implements SBRConstants {
    private boolean stereo;
    private int sampleFrequency;
    private boolean downSampled;
    private final SBRHeader header;
    private final ChannelData[] cd;
    private final FrequencyTables tables;
    private boolean coupling;
    private final float[][][][] W;
    private final float[][][] Xlow;
    private final float[][][] Xhigh;
    private final float[][][][] Y;
    private final float[][][][] X;
    private final AnalysisFilterbank qmfA;
    private final SynthesisFilterbank qmfS;
    private PS ps;
    private boolean psUsed;

    public SBR(SampleFrequency sf, boolean downSampled) {
        this.sampleFrequency = sf.getFrequency() * 2;
        this.downSampled = downSampled;
        this.header = new SBRHeader();
        this.cd = new ChannelData[2];
        this.cd[0] = new ChannelData();
        this.cd[1] = new ChannelData();
        this.tables = new FrequencyTables();
        this.W = new float[2][32][32][2];
        this.Xlow = new float[32][40][2];
        this.Xhigh = new float[64][40][2];
        this.Y = new float[2][44][64][2];
        this.X = new float[2][64][38][2];
        this.qmfA = new AnalysisFilterbank();
        this.qmfS = new SynthesisFilterbank();
        this.psUsed = false;
    }

    public void decode(BitStream in, int bitsAvailable, boolean stereo, boolean crc) throws AACException {
        this.stereo = stereo;
        int start = in.getPosition();
        if (crc) {
            Constants.LOGGER.info("SBR CRC bits present");
            in.skipBits(10);
        }
        if (in.readBool()) {
            this.header.decode(in);
            if (this.header.isReset()) {
                this.tables.calculate(this.header, this.sampleFrequency);
            }
        }
        if (this.header.isDecoded()) {
            this.decodeData(in, stereo);
            int read = in.getPosition() - start;
            int bitsLeft = bitsAvailable - read;
            if (bitsLeft >= 8) {
                Constants.LOGGER.log(Level.WARNING, "SBR: bits left: {0}", bitsLeft);
            } else if (bitsLeft < 0) {
                throw new AACException("SBR data overread: " + bitsLeft);
            }
            in.skipBits(bitsLeft);
        } else {
            int left = bitsAvailable - (in.getPosition() - start);
            in.skipBits(left);
            Constants.LOGGER.log(Level.INFO, "SBR frame without header, skipped {0} bits", left);
        }
    }

    private void decodeData(BitStream in, boolean stereo) throws AACException {
        if (stereo) {
            this.decodeChannelPairElement(in);
        } else {
            this.decodeSingleChannelElement(in);
        }
        if (in.readBool()) {
            int bitsLeft;
            int extensionID;
            int count = in.readBits(4);
            if (count == 15) {
                count += in.readBits(8);
            }
            for (bitsLeft = 8 * count; bitsLeft > 7; bitsLeft -= this.decodeExtension(in, extensionID)) {
                bitsLeft -= 2;
                extensionID = in.readBits(2);
            }
            if (bitsLeft > 0) {
                in.skipBits(bitsLeft);
            }
        }
    }

    private void decodeSingleChannelElement(BitStream in) throws AACException {
        if (in.readBool()) {
            in.skipBits(4);
        }
        this.cd[0].decodeGrid(in, this.header, this.tables);
        this.cd[0].decodeDTDF(in);
        this.cd[0].decodeInvf(in, this.header, this.tables);
        this.cd[0].decodeEnvelope(in, this.header, this.tables, false, false);
        this.cd[0].decodeNoise(in, this.header, this.tables, false, false);
        this.cd[0].decodeSinusoidal(in, this.header, this.tables);
        this.dequantSingle(0);
    }

    private void decodeChannelPairElement(BitStream in) throws AACException {
        if (in.readBool()) {
            in.skipBits(8);
        }
        if (this.coupling = in.readBool()) {
            this.cd[0].decodeGrid(in, this.header, this.tables);
            this.cd[1].copyGrid(this.cd[0]);
            this.cd[0].decodeDTDF(in);
            this.cd[1].decodeDTDF(in);
            this.cd[0].decodeInvf(in, this.header, this.tables);
            this.cd[1].copyInvf(this.cd[0]);
            this.cd[0].decodeEnvelope(in, this.header, this.tables, false, this.coupling);
            this.cd[0].decodeNoise(in, this.header, this.tables, false, this.coupling);
            this.cd[1].decodeEnvelope(in, this.header, this.tables, true, this.coupling);
            this.cd[1].decodeNoise(in, this.header, this.tables, true, this.coupling);
            this.dequantCoupled();
        } else {
            this.cd[0].decodeGrid(in, this.header, this.tables);
            this.cd[1].decodeGrid(in, this.header, this.tables);
            this.cd[0].decodeDTDF(in);
            this.cd[1].decodeDTDF(in);
            this.cd[0].decodeInvf(in, this.header, this.tables);
            this.cd[1].decodeInvf(in, this.header, this.tables);
            this.cd[0].decodeEnvelope(in, this.header, this.tables, false, this.coupling);
            this.cd[1].decodeEnvelope(in, this.header, this.tables, true, this.coupling);
            this.cd[0].decodeNoise(in, this.header, this.tables, false, this.coupling);
            this.cd[1].decodeNoise(in, this.header, this.tables, true, this.coupling);
            this.dequantSingle(0);
            this.dequantSingle(1);
        }
        this.cd[0].decodeSinusoidal(in, this.header, this.tables);
        this.cd[1].decodeSinusoidal(in, this.header, this.tables);
    }

    private int decodeExtension(BitStream in, int extensionID) throws AACException {
        int start = in.getPosition();
        switch (extensionID) {
            case 2: {
                if (this.ps == null) {
                    this.ps = new PS();
                }
                this.ps.decode(in);
                if (this.psUsed || !this.ps.hasHeader()) break;
                this.psUsed = true;
                break;
            }
            default: {
                in.skipBits(6);
            }
        }
        return in.getPosition() - start;
    }

    private void dequantSingle(int ch) {
        float a = this.cd[ch].getAmpRes() ? 1.0f : 0.5f;
        float[][] e = this.cd[ch].getEnvelopeScalefactors();
        int[] freqRes = this.cd[ch].getFrequencyResolutions();
        int[] n = this.tables.getN();
        for (int l = 0; l < this.cd[ch].getEnvCount(); ++l) {
            for (int k = 0; k < n[freqRes[l]]; ++k) {
                e[l][k] = (float)Math.pow(2.0, e[l][k] * a + 6.0f);
            }
        }
        int nq = this.tables.getNq();
        int lq = this.cd[ch].getNoiseCount();
        float[][] q = this.cd[ch].getNoiseFloorData();
        for (int l = 0; l < lq; ++l) {
            for (int k = 0; k < nq; ++k) {
                q[l][k] = (float)Math.pow(2.0, 6.0f - q[l][k]);
            }
        }
    }

    private void dequantCoupled() {
        float f3;
        float f2;
        float f1;
        float a = this.cd[0].getAmpRes() ? 1.0f : 0.5f;
        int panOffset = PAN_OFFSETS[this.cd[0].getAmpRes() ? 1 : 0];
        float[][] e0 = this.cd[0].getEnvelopeScalefactors();
        float[][] e1 = this.cd[1].getEnvelopeScalefactors();
        int[] r = this.cd[0].getFrequencyResolutions();
        int le = this.cd[0].getEnvCount();
        int[] n = this.tables.getN();
        for (int l = 0; l < le; ++l) {
            for (int k = 0; k < n[r[l]]; ++k) {
                f1 = (float)Math.pow(2.0, e0[l][k] * a + 7.0f);
                f2 = (float)Math.pow(2.0, ((float)panOffset - e1[l][k]) * a);
                e0[l][k] = f3 = f1 / (1.0f + f2);
                e1[l][k] = f3 * f2;
            }
        }
        float[][] q0 = this.cd[0].getNoiseFloorData();
        float[][] q1 = this.cd[1].getNoiseFloorData();
        int lq = this.cd[0].getNoiseCount();
        int nq = this.tables.getNq();
        for (int l = 0; l < lq; ++l) {
            for (int k = 0; k < nq; ++k) {
                f1 = (float)Math.pow(2.0, 6.0f - q0[l][k] + 1.0f);
                f2 = (float)Math.pow(2.0, (float)PAN_OFFSETS[1] - q1[l][k]);
                q0[l][k] = f3 = f1 / (1.0f + f2);
                q1[l][k] = f3 * f2;
            }
        }
    }

    public boolean isPSUsed() {
        return this.psUsed;
    }

    public void process(float[] left, float[] right, boolean downSampled) throws AACException {
        if (!this.header.isDecoded()) {
            return;
        }
        this.processChannel(0, left);
        if (this.stereo) {
            this.processChannel(1, right);
        } else if (this.psUsed) {
            for (int l = 32; l < 38; ++l) {
                for (int k = 0; k < 5; ++k) {
                    this.X[0][k][l][0] = this.Xlow[k][l + 2][0];
                    this.X[0][k][l][1] = this.Xlow[k][l + 2][1];
                }
            }
            this.ps.process(this.X[0], this.X[1]);
        }
        this.qmfS.process(this.X[0], left, 0);
        if (this.stereo || this.psUsed) {
            this.qmfS.process(this.X[1], right, 1);
        }
    }

    private void processChannel(int ch, float[] data) throws AACException {
        int k;
        int l;
        int kxPrev = this.tables.getKx(true);
        for (l = 0; l < 8; ++l) {
            for (k = 0; k < kxPrev; ++k) {
                this.Xlow[k][l][0] = this.W[ch][k][l + 32 - 8][0];
                this.Xlow[k][l][1] = this.W[ch][k][l + 32 - 8][1];
            }
            for (k = kxPrev; k < 32; ++k) {
                this.Xlow[k][l][0] = 0.0f;
                this.Xlow[k][l][1] = 0.0f;
            }
        }
        this.qmfA.process(data, this.W[ch], 0);
        int kx = this.tables.getKx(false);
        for (l = 8; l < 40; ++l) {
            for (k = 0; k < kx; ++k) {
                this.Xlow[k][l][0] = this.W[ch][k][l - 8][0];
                this.Xlow[k][l][1] = this.W[ch][k][l - 8][1];
            }
            for (k = kx; k < 32; ++k) {
                this.Xlow[k][l][0] = 0.0f;
                this.Xlow[k][l][1] = 0.0f;
            }
        }
        HFGenerator.process(this.tables, this.cd[ch], this.Xlow, this.Xhigh);
        int lTemp = this.cd[ch].getLTemp();
        int mPrev = this.tables.getM(true);
        int m = this.tables.getM(false);
        for (l = 0; l < lTemp; ++l) {
            for (k = 0; k < kxPrev; ++k) {
                this.X[ch][k][l][0] = this.Xlow[k][l + 2][0];
                this.X[ch][k][l][1] = this.Xlow[k][l + 2][1];
            }
            for (k = kxPrev; k < kxPrev + mPrev; ++k) {
                this.X[ch][k][l][0] = this.Y[ch][l + 2 + 32][k][0];
                this.X[ch][k][l][1] = this.Y[ch][l + 2 + 32][k][1];
            }
            for (k = kxPrev + mPrev; k < 64; ++k) {
                this.X[ch][k][l][0] = 0.0f;
                this.X[ch][k][l][1] = 0.0f;
            }
        }
        HFAdjuster.process(this.header, this.tables, this.cd[ch], this.Xhigh, this.Y[ch]);
        for (l = lTemp; l < 32; ++l) {
            for (k = 0; k < kx; ++k) {
                this.X[ch][k][l][0] = this.Xlow[k][l + 2][0];
                this.X[ch][k][l][1] = this.Xlow[k][l + 2][1];
            }
            for (k = kx; k < kx + m; ++k) {
                this.X[ch][k][l][0] = this.Y[ch][l + 2][k][0];
                this.X[ch][k][l][1] = this.Y[ch][l + 2][k][1];
            }
            for (k = kx + m; k < 64; ++k) {
                this.X[ch][k][l][0] = 0.0f;
                this.X[ch][k][l][1] = 0.0f;
            }
        }
        this.cd[ch].savePreviousData();
    }
}

