/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.mp4;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Arrays;

public class MP4InputStream {
    public static final int MASK8 = 255;
    public static final int MASK16 = 65535;
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    private static final int BYTE_ORDER_MASK = 65279;
    private final InputStream in;
    private final RandomAccessFile fin;
    private int peeked;
    private long offset;

    MP4InputStream(InputStream in) {
        this.in = in;
        this.fin = null;
        this.peeked = -1;
        this.offset = 0L;
    }

    MP4InputStream(RandomAccessFile fin) {
        this.fin = fin;
        this.in = null;
        this.peeked = -1;
    }

    public int read() throws IOException {
        int i = 0;
        if (this.peeked >= 0) {
            i = this.peeked;
            this.peeked = -1;
        } else if (this.in != null) {
            i = this.in.read();
        } else if (this.fin != null) {
            i = this.fin.read();
        }
        if (i == -1) {
            throw new EOFException();
        }
        if (this.in != null) {
            ++this.offset;
        }
        return i;
    }

    public void read(byte[] b, int off, int len) throws IOException {
        int read = 0;
        int i = 0;
        if (this.peeked >= 0 && len > 0) {
            b[off] = (byte)this.peeked;
            this.peeked = -1;
            ++read;
        }
        while (read < len) {
            if (this.in != null) {
                i = this.in.read(b, off + read, len - read);
            } else if (this.fin != null) {
                i = this.fin.read(b, off + read, len - read);
            }
            if (i < 0) {
                throw new EOFException();
            }
            read += i;
        }
        this.offset += (long)read;
    }

    public long readBytes(int n) throws IOException {
        if (n < 1 || n > 8) {
            throw new IndexOutOfBoundsException("invalid number of bytes to read: " + n);
        }
        byte[] b = new byte[n];
        this.read(b, 0, n);
        long result = 0L;
        for (int i = 0; i < n; ++i) {
            result = result << 8 | (long)(b[i] & 0xFF);
        }
        return result;
    }

    public void readBytes(byte[] b) throws IOException {
        this.read(b, 0, b.length);
    }

    public String readString(int n) throws IOException {
        int pos;
        int i = -1;
        char[] c = new char[n];
        for (pos = 0; pos < n; ++pos) {
            i = this.read();
            c[pos] = (char)i;
        }
        return new String(c, 0, pos);
    }

    public String readUTFString(int max, String encoding) throws IOException {
        return new String(this.readTerminated(max, 0), Charset.forName(encoding));
    }

    public String readUTFString(int max) throws IOException {
        byte[] bom = new byte[2];
        this.read(bom, 0, 2);
        if (bom[0] == 0 || bom[1] == 0) {
            return new String();
        }
        int i = bom[0] << 8 | bom[1];
        byte[] b = this.readTerminated(max - 2, 0);
        byte[] b2 = new byte[b.length + bom.length];
        System.arraycopy(bom, 0, b2, 0, bom.length);
        System.arraycopy(b, 0, b2, bom.length, b.length);
        return new String(b2, Charset.forName(i == 65279 ? UTF16 : UTF8));
    }

    public byte[] readTerminated(int max, int terminator) throws IOException {
        byte[] b = new byte[max];
        int pos = 0;
        int i = 0;
        while (pos < max && i != -1) {
            i = this.read();
            if (i == -1) continue;
            b[pos++] = (byte)i;
        }
        return Arrays.copyOf(b, pos);
    }

    public double readFixedPoint(int m, int n) throws IOException {
        int bits = m + n;
        if (bits % 8 != 0) {
            throw new IllegalArgumentException("number of bits is not a multiple of 8: " + (m + n));
        }
        long l = this.readBytes(bits / 8);
        double x = Math.pow(2.0, n);
        double d = (double)l / x;
        return d;
    }

    public void skipBytes(long n) throws IOException {
        long l = 0L;
        if (this.peeked >= 0 && n > 0L) {
            this.peeked = -1;
            ++l;
        }
        while (l < n) {
            if (this.in != null) {
                l += this.in.skip(n - l);
                continue;
            }
            if (this.fin == null) continue;
            l += (long)this.fin.skipBytes((int)(n - l));
        }
        this.offset += l;
    }

    public long getOffset() throws IOException {
        long l = -1L;
        if (this.in != null) {
            l = this.offset;
        } else if (this.fin != null) {
            l = this.fin.getFilePointer();
        }
        return l;
    }

    public void seek(long pos) throws IOException {
        if (this.fin == null) {
            throw new IOException("could not seek: no random access");
        }
        this.fin.seek(pos);
    }

    public boolean hasRandomAccess() {
        return this.fin != null;
    }

    public boolean hasLeft() throws IOException {
        boolean b;
        if (this.fin != null) {
            b = this.fin.getFilePointer() < this.fin.length() - 1L;
        } else if (this.peeked >= 0) {
            b = true;
        } else {
            int i = this.in.read();
            boolean bl = b = i != -1;
            if (b) {
                this.peeked = i;
            }
        }
        return b;
    }

    void close() throws IOException {
        this.peeked = -1;
        if (this.in != null) {
            this.in.close();
        } else if (this.fin != null) {
            this.fin.close();
        }
    }
}

