/*
 * Decompiled with CFR 0.152.
 */
package com.ButtonPlus.cmdbuttons;

import com.ButtonPlus.cmdbuttons.ButtonData;
import com.ButtonPlus.cmdbuttons.ButtonManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class ButtonCommand {
    private static final List<String> WOOL_COLORS_SUGGEST = Arrays.asList("\"white\"", "\"orange\"", "\"magenta\"", "\"light_blue\"", "\"yellow\"", "\"lime\"", "\"pink\"", "\"gray\"", "\"light_gray\"", "\"cyan\"", "\"purple\"", "\"blue\"", "\"brown\"", "\"green\"", "\"red\"", "\"black\"");
    private static final List<String> WOOL_COLORS_RAW = Arrays.asList("white", "orange", "magenta", "light_blue", "yellow", "lime", "pink", "gray", "light_gray", "cyan", "purple", "blue", "brown", "green", "red", "black");
    private static final List<String> TEXT_COLORS_SUGGEST = Arrays.asList("\"$0\"", "\"$1\"", "\"$2\"", "\"$3\"", "\"$4\"", "\"$5\"", "\"$6\"", "\"$7\"", "\"$8\"", "\"$9\"", "\"$a\"", "\"$b\"", "\"$c\"", "\"$d\"", "\"$e\"", "\"$f\"");
    private static final List<String> POSITIONS = Arrays.asList("\"LEFT\"", "\"RIGHT\"", "\"TOP\"");

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"button");
        builder.then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"key", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"woolColor", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.m_82970_(WOOL_COLORS_SUGGEST, (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"colorCode", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.m_82970_(TEXT_COLORS_SUGGEST, (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"cmd", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"cooldown", (ArgumentType)IntegerArgumentType.integer((int)0)).then(Commands.m_82129_((String)"position", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.m_82970_(POSITIONS, (SuggestionsBuilder)b)).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key").toUpperCase();
            String wool = StringArgumentType.getString((CommandContext)context, (String)"woolColor").replace("\"", "").toLowerCase();
            if (!WOOL_COLORS_RAW.contains(wool)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7c\u0426\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!"));
                return 0;
            }
            String color = StringArgumentType.getString((CommandContext)context, (String)"colorCode").replace("\"", "");
            String cmd = StringArgumentType.getString((CommandContext)context, (String)"cmd");
            int cd = IntegerArgumentType.getInteger((CommandContext)context, (String)"cooldown");
            String pos = StringArgumentType.getString((CommandContext)context, (String)"position").replace("\"", "").toUpperCase();
            ButtonManager.addButton(new ButtonData(key, wool, color, cmd, cd, pos));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a\u041a\u043d\u043e\u043f\u043a\u0430 \u00a7e" + key + " \u00a7a\u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430!")), false);
            return 1;
        }))))))));
        builder.then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"key", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.m_82970_((Iterable)ButtonManager.buttons.stream().map(btn -> "\"" + btn.key + "\"").collect(Collectors.toList()), (SuggestionsBuilder)b)).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key").replace("\"", "").toUpperCase();
            if (ButtonManager.buttons.removeIf(btn -> btn.key.equalsIgnoreCase(key))) {
                ButtonManager.save();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7e\u041a\u043d\u043e\u043f\u043a\u0430 " + key + " \u0443\u0434\u0430\u043b\u0435\u043d\u0430.")), false);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7c\u041a\u043d\u043e\u043f\u043a\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430."));
            return 0;
        })));
        builder.then(Commands.m_82127_((String)"hide").then(Commands.m_82129_((String)"key", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.m_82970_((Iterable)ButtonManager.buttons.stream().map(btn -> "\"" + btn.key + "\"").collect(Collectors.toList()), (SuggestionsBuilder)b)).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key").replace("\"", "").toUpperCase();
            for (ButtonData btn : ButtonManager.buttons) {
                if (!btn.key.equalsIgnoreCase(key)) continue;
                btn.isVisible = false;
                ButtonManager.save();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a77\u041a\u043d\u043e\u043f\u043a\u0430 " + key + " \u0441\u043a\u0440\u044b\u0442\u0430.")), false);
                return 1;
            }
            return 0;
        })));
        builder.then(Commands.m_82127_((String)"show").then(Commands.m_82129_((String)"key", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.m_82970_((Iterable)ButtonManager.buttons.stream().map(btn -> "\"" + btn.key + "\"").collect(Collectors.toList()), (SuggestionsBuilder)b)).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key").replace("\"", "").toUpperCase();
            for (ButtonData btn : ButtonManager.buttons) {
                if (!btn.key.equalsIgnoreCase(key)) continue;
                btn.isVisible = true;
                ButtonManager.save();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a\u041a\u043d\u043e\u043f\u043a\u0430 " + key + " \u0442\u0435\u043f\u0435\u0440\u044c \u0432\u0438\u0434\u043d\u0430.")), false);
                return 1;
            }
            return 0;
        })));
        builder.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"profile").then(Commands.m_82127_((String)"save").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name").replace("\"", "");
            ButtonManager.saveProfile(name);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7a\u041f\u0440\u043e\u0444\u0438\u043b\u044c " + name + " \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d.")), false);
            return 1;
        })))).then(Commands.m_82127_((String)"load").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.m_82970_(ButtonManager.getProfileList(), (SuggestionsBuilder)b)).executes(context -> {
            String name = StringArgumentType.getString((CommandContext)context, (String)"name").replace("\"", "");
            if (ButtonManager.loadProfile(name)) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7e\u041f\u0440\u043e\u0444\u0438\u043b\u044c " + name + " \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d.")), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7c\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c."));
            }
            return 1;
        }))));
        builder.then(Commands.m_82127_((String)"clear").executes(context -> {
            ButtonManager.buttons.clear();
            ButtonManager.save();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a76\u0412\u0441\u0435 \u043a\u043d\u043e\u043f\u043a\u0438 \u043e\u0447\u0438\u0449\u0435\u043d\u044b."), false);
            return 1;
        }));
        dispatcher.register(builder);
    }
}

