/*
 * Decompiled with CFR 0.152.
 */
package com.ButtonPlus.cmdbuttons;

import com.ButtonPlus.cmdbuttons.ButtonData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.loading.FMLPaths;

public class ButtonManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File FILE = new File(FMLPaths.CONFIGDIR.get().toFile(), "cmdbuttons.json");
    private static final File PROFILES_DIR = new File(FMLPaths.CONFIGDIR.get().toFile(), "button_profiles");
    public static List<ButtonData> buttons = new ArrayList<ButtonData>();

    public static void load() {
        if (!FILE.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(FILE);){
            List loaded = (List)GSON.fromJson((Reader)reader, new TypeToken<List<ButtonData>>(){}.getType());
            if (loaded != null) {
                buttons = loaded;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(FILE);){
            GSON.toJson(buttons, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addButton(ButtonData button) {
        buttons.add(button);
        ButtonManager.save();
    }

    public static void executeCommand(ButtonData button) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        long rem = button.lastUsedTime + (long)button.cooldown * 50L - System.currentTimeMillis();
        if (rem > 0L) {
            mc.f_91073_.m_6263_((Player)mc.f_91074_, mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), (SoundEvent)SoundEvents.f_12209_.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
            return;
        }
        String cmd = button.command;
        cmd = cmd.replace("{me}", mc.f_91074_.m_6302_());
        String pos = String.format("%d %d %d", (int)mc.f_91074_.m_20185_(), (int)mc.f_91074_.m_20186_(), (int)mc.f_91074_.m_20189_());
        if ((cmd = cmd.replace("{pos}", pos)).contains("{target}")) {
            Entity entity;
            EntityHitResult hit = ButtonManager.getPlayerLookTarget(mc, 30.0);
            if (hit != null && (entity = hit.m_82443_()) instanceof Player) {
                Player target = (Player)entity;
                cmd = cmd.replace("{target}", target.m_6302_());
            } else {
                mc.f_91074_.m_5661_((Component)Component.m_237113_((String)"\u00a7c\u0426\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!"), true);
                mc.f_91073_.m_6263_((Player)mc.f_91074_, mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), (SoundEvent)SoundEvents.f_12209_.get(), SoundSource.PLAYERS, 1.0f, 0.5f);
                return;
            }
        }
        mc.f_91074_.f_108617_.m_246979_(cmd);
        button.lastUsedTime = System.currentTimeMillis();
        mc.f_91073_.m_6263_((Player)mc.f_91074_, mc.f_91074_.m_20185_(), mc.f_91074_.m_20186_(), mc.f_91074_.m_20189_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
    }

    private static EntityHitResult getPlayerLookTarget(Minecraft mc, double range) {
        if (mc.m_91288_() == null) {
            return null;
        }
        Vec3 start = mc.m_91288_().m_20299_(1.0f);
        Vec3 look = mc.m_91288_().m_20252_(1.0f).m_82490_(range);
        Vec3 end = start.m_82549_(look);
        return ProjectileUtil.m_37287_((Entity)mc.m_91288_(), (Vec3)start, (Vec3)end, (AABB)mc.m_91288_().m_20191_().m_82369_(look).m_82400_(1.0), e -> e instanceof Player && !e.m_5833_(), (double)(range * range));
    }

    public static void saveProfile(String name) {
        if (!PROFILES_DIR.exists()) {
            PROFILES_DIR.mkdirs();
        }
        try (FileWriter writer = new FileWriter(new File(PROFILES_DIR, name + ".json"));){
            GSON.toJson(buttons, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean loadProfile(String name) {
        File file = new File(PROFILES_DIR, name + ".json");
        if (!file.exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(file);){
            List loaded = (List)GSON.fromJson((Reader)reader, new TypeToken<List<ButtonData>>(){}.getType());
            if (loaded == null) return false;
            buttons = loaded;
            ButtonManager.save();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static List<String> getProfileList() {
        if (!PROFILES_DIR.exists()) {
            return new ArrayList<String>();
        }
        String[] files = PROFILES_DIR.list((dir, name) -> name.endsWith(".json"));
        return files != null ? Arrays.stream(files).map(f -> "\"" + f.replace(".json", "") + "\"").toList() : new ArrayList<String>();
    }
}

