/*
 * Decompiled with CFR 0.152.
 */
package com.ButtonPlus.cmdbuttons;

import com.ButtonPlus.cmdbuttons.ButtonData;
import com.ButtonPlus.cmdbuttons.ButtonManager;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.glfw.GLFW;

@Mod.EventBusSubscriber(modid="cmdbuttons")
public class ClientEvents {
    private static final Map<String, int[]> SPECIAL_KEYS = new HashMap<String, int[]>();

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91080_ != null || event.getAction() != 1) {
            return;
        }
        ArrayList<ButtonData> triggeredButtons = new ArrayList<ButtonData>();
        for (ButtonData button : ButtonManager.buttons) {
            String[] combo = button.getKeys();
            boolean allPressed = true;
            for (String k : combo) {
                if (ClientEvents.isKeyPressed(k)) continue;
                allPressed = false;
                break;
            }
            if (!allPressed || combo.length == 1 && ClientEvents.isAnySpecialKeyPressedExcept(combo[0])) continue;
            triggeredButtons.add(button);
        }
        triggeredButtons.stream().max((b1, b2) -> Integer.compare(b1.getKeys().length, b2.getKeys().length)).ifPresent(ButtonManager::executeCommand);
    }

    private static boolean isKeyPressed(String keyName) {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        if (SPECIAL_KEYS.containsKey(keyName)) {
            for (int code : SPECIAL_KEYS.get(keyName)) {
                if (GLFW.glfwGetKey((long)window, (int)code) != 1) continue;
                return true;
            }
            return false;
        }
        try {
            int code = InputConstants.m_84851_((String)("key.keyboard." + keyName.toLowerCase())).m_84873_();
            return GLFW.glfwGetKey((long)window, (int)code) == 1;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isAnySpecialKeyPressedExcept(String currentKey) {
        long window = Minecraft.m_91087_().m_91268_().m_85439_();
        for (Map.Entry<String, int[]> entry : SPECIAL_KEYS.entrySet()) {
            if (entry.getKey().equalsIgnoreCase(currentKey)) continue;
            for (int code : entry.getValue()) {
                if (GLFW.glfwGetKey((long)window, (int)code) != 1) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91066_.f_92062_ || mc.f_91074_ == null) {
                return;
            }
            GuiGraphics graphics = event.getGuiGraphics();
            int sw = mc.m_91268_().m_85445_();
            int sh = mc.m_91268_().m_85446_();
            List<ButtonData> left = ClientEvents.getButtonsByPos("LEFT");
            List<ButtonData> right = ClientEvents.getButtonsByPos("RIGHT");
            List<ButtonData> top = ClientEvents.getButtonsByPos("TOP");
            if (!mc.f_91074_.m_21206_().m_41619_() && !left.isEmpty()) {
                top.add(left.remove(left.size() - 1));
            }
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
            ClientEvents.drawZone(graphics, mc, left, sw / 2 - 96, sh - 22, -1);
            ClientEvents.drawZone(graphics, mc, right, sw / 2 + 96, sh - 22, 1);
            int topY = sh - 45;
            if (!mc.f_91074_.m_7500_() && !mc.f_91074_.m_5833_()) {
                topY -= 14;
                if (mc.f_91074_.m_21230_() > 0) {
                    topY -= 10;
                }
                if (mc.f_91074_.m_20146_() < mc.f_91074_.m_6062_()) {
                    topY -= 10;
                }
            }
            ClientEvents.drawZone(graphics, mc, top, sw / 2, topY, 0);
            graphics.m_280168_().m_85849_();
        }
    }

    private static List<ButtonData> getButtonsByPos(String pos) {
        return ButtonManager.buttons.stream().filter(b -> b.isVisible && b.position.equals(pos)).collect(Collectors.toCollection(ArrayList::new));
    }

    private static void drawZone(GuiGraphics graphics, Minecraft mc, List<ButtonData> list, int startX, int y, int dir) {
        int size = 20;
        int gap = 2;
        int tw = list.size() * size + Math.max(0, list.size() - 1) * gap;
        int x = dir == -1 ? startX - tw : (dir == 0 ? startX - tw / 2 : startX);
        for (ButtonData b : list) {
            ClientEvents.renderButton(graphics, mc, b, x, y);
            x += size + gap;
        }
    }

    private static void renderButton(GuiGraphics g, Minecraft mc, ButtonData b, int x, int y) {
        ResourceLocation wool = new ResourceLocation("minecraft", "textures/block/" + b.woolColor + "_wool.png");
        g.m_280163_(wool, x + 1, y + 1, 0.0f, 0.0f, 18, 18, 16, 16);
        g.m_280637_(x, y, 20, 20, -13158601);
        g.m_280637_(x + 1, y + 1, 18, 18, -1);
        long rem = b.lastUsedTime + (long)b.cooldown * 50L - System.currentTimeMillis();
        if (rem > 0L) {
            int h = (int)((float)rem / (float)((long)b.cooldown * 50L) * 18.0f);
            g.m_280509_(x + 1, y + 19 - h, x + 19, y + 19, -1879048192);
            String time = rem > 1000L ? rem / 1000L + "s" : String.format("%.1f", Float.valueOf((float)rem / 1000.0f));
            g.m_280168_().m_85836_();
            g.m_280168_().m_252880_((float)(x + 10), (float)(y + 11), 300.0f);
            g.m_280168_().m_85841_(0.6f, 0.6f, 0.6f);
            g.m_280137_(mc.f_91062_, time, 0, 0, -256);
            g.m_280168_().m_85849_();
        } else {
            g.m_280168_().m_85836_();
            boolean isCombo = b.key.contains("+");
            float scale = isCombo ? 0.55f : 0.9f;
            g.m_280168_().m_252880_((float)(x + 10), (float)(y + (isCombo ? 8 : 6)), 300.0f);
            g.m_280168_().m_85841_(scale, scale, scale);
            int color = ClientEvents.getMcColor(b.colorCode.isEmpty() ? (char)'f' : b.colorCode.charAt(0));
            g.m_280137_(mc.f_91062_, b.key, 0, 0, color);
            g.m_280168_().m_85849_();
        }
    }

    private static int getMcColor(char c) {
        ChatFormatting f = ChatFormatting.m_126645_((char)c);
        return f != null && f.m_126665_() != null ? f.m_126665_() | 0xFF000000 : -1;
    }

    static {
        SPECIAL_KEYS.put("CTRL", new int[]{341, 345});
        SPECIAL_KEYS.put("SHIFT", new int[]{340, 344});
        SPECIAL_KEYS.put("ALT", new int[]{342, 346});
        SPECIAL_KEYS.put("TAB", new int[]{258});
        SPECIAL_KEYS.put("ESC", new int[]{256});
    }
}

