/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.fetch;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="athisworkshopfetch", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.DoubleValue KEEP_STICK_CHANCE = BUILDER.comment(new String[]{" ", "Chance that a fetched stick will be kept by the wolf instead of being dropped automatically.", "If kept, you must right-click the wolf to get the stick.", "0.0 = always drop, 1.0 = never drop"}).defineInRange("keepStickChance", 0.35, 0.0, 1.0);
    public static final ForgeConfigSpec.DoubleValue WOLF_FETCH_SPEED = BUILDER.comment(new String[]{" ", "Movement speed multiplier for wolves while fetching.", "Higher values make wolves faster, lower values make them slower."}).defineInRange("wolfFetchSpeed", 1.2, 0.5, 3.0);
    public static final ForgeConfigSpec.IntValue FETCH_SEARCH_RADIUS = BUILDER.comment(new String[]{" ", "Maximum distance (in blocks) that a wolf can search for sticks.", "Larger values = wolves can find sticks from farther away."}).defineInRange("fetchSearchRadius", 24, 8, 64);
    public static final ForgeConfigSpec.IntValue STICK_CARRY_TIME_LIMIT = BUILDER.comment(new String[]{" ", "Maximum time (in ticks) a wolf can carry a stick before dropping it.", "20 ticks = 1 second. Use 0 to disable timeout."}).defineInRange("stickCarryTimeLimit", 800, 0, 6000);
    public static final ForgeConfigSpec.BooleanValue ENABLE_FETCH_GOAL = BUILDER.comment(new String[]{" ", "Enable/disable the fetch goal entirely."}).define("enableFetchGoal", true);
    public static final ForgeConfigSpec.DoubleValue RETRIEVE_BREAK_CHANCE = BUILDER.comment(new String[]{" ", "Chance that a fetched item breaks when you right-click the wolf to retrieve it.", "Plays an item break sound and shows breaking particles.", "0.0 = never, 1.0 = always"}).defineInRange("retrieveBreakChance", 0.2, 0.0, 1.0);
    public static final ForgeConfigSpec.BooleanValue SUPPORT_BONES = BUILDER.comment(new String[]{" ", "Allow wolves to fetch bones as well as sticks.", "Useful for doggo immersion!"}).define("supportBones", true);
    public static final ForgeConfigSpec.DoubleValue THROW_VELOCITY = BUILDER.comment(new String[]{" ", "How fast thrown sticks/bones are launched.", "Higher = farther throws. Vanilla snowballs are ~1.5.", "Try 1.0 - 1.2 for shorter throws."}).defineInRange("throwVelocity", 1.15, 0.1, 4.0);
    public static final ForgeConfigSpec.DoubleValue THROW_INACCURACY = BUILDER.comment(new String[]{" ", "Inaccuracy/spread for thrown sticks/bones.", "Higher = more random drift."}).defineInRange("throwInaccuracy", 1.0, 0.0, 10.0);
    public static final ForgeConfigSpec.BooleanValue BONE_HEALS_ON_DELIVERY = BUILDER.comment(new String[]{" ", "If true: when a wolf brings you a bone and is not at full health, it will eat the bone to heal.", "If the wolf is at full health, it behaves like other fetched items (drop/keep for right-click)."}).define("boneHealsOnDelivery", true);
    public static final ForgeConfigSpec.DoubleValue BONE_HEAL_AMOUNT = BUILDER.comment(new String[]{" ", "How much health a wolf heals when it eats a delivered bone.", "1.0 = half a heart, 2.0 = 1 heart, 4.0 = 2 hearts."}).defineInRange("boneHealAmount", 2.0, 0.0, 40.0);
    public static final ForgeConfigSpec.BooleanValue SUPPORT_ROTTEN_FLESH = BUILDER.comment(new String[]{" ", "Allow wolves to fetch rotten flesh.", "Dangerous but fun!"}).define("supportRottenFlesh", false);
    public static final ForgeConfigSpec.BooleanValue ROTTEN_FLESH_HEALS_ON_DELIVERY = BUILDER.comment(new String[]{" ", "If true: when a wolf brings you rotten flesh and is not at full health, it will eat it to heal.", "If the wolf is at full health, it behaves like other fetched items (drop/keep for right-click)."}).define("rottenFleshHealsOnDelivery", true);
    public static final ForgeConfigSpec.DoubleValue ROTTEN_FLESH_HEAL_AMOUNT = BUILDER.comment(new String[]{" ", "How much health a wolf heals when it eats delivered rotten flesh.", "1.0 = half a heart, 2.0 = 1 heart, 4.0 = 2 hearts."}).defineInRange("rottenFleshHealAmount", 2.0, 0.0, 40.0);
    public static final ForgeConfigSpec.BooleanValue ENABLE_PARTICLE_EFFECTS = BUILDER.comment(new String[]{" ", "Show particle effects when sticks are picked up.", "Set to false to disable for better performance."}).define("enableParticleEffects", true);
    public static final ForgeConfigSpec.BooleanValue ENABLE_PANT_SOUNDS = BUILDER.comment(new String[]{" ", "Play pant/howl sounds when wolves pick up sticks.", "Set to false for silence."}).define("enablePantSounds", true);
    public static final ForgeConfigSpec.BooleanValue SHOW_CARRY_INDICATOR = BUILDER.comment(new String[]{" ", "Show a visual indicator (particles/message) when wolf picks up a stick.", "Helpful for knowing the wolf is actually fetching."}).define("showCarryIndicator", true);
    public static final ForgeConfigSpec.BooleanValue PRIORITIZE_THROWN_STICKS = BUILDER.comment(new String[]{" ", "Wolves will prioritize thrown sticks over ground sticks.", "Useful for games of fetch!"}).define("prioritizeThrownSticks", true);
    public static final ForgeConfigSpec.IntValue MULTI_STICK_LIMIT = BUILDER.comment(new String[]{" ", "Maximum number of sticks a wolf can carry at once.", "Set to 1 for vanilla-like behavior (one stick at a time)."}).defineInRange("multiStickLimit", 1, 1, 64);
    public static final ForgeConfigSpec.BooleanValue ENABLE_BONDING = BUILDER.comment(new String[]{" ", "Enable/disable the Bonding mechanic.", "Bonding can trigger when a tamed wolf at full health delivers a fetched bone."}).define("enableBonding", true);
    public static final ForgeConfigSpec.DoubleValue BONDING_CHANCE_ON_BONE_DELIVERY = BUILDER.comment(new String[]{" ", "Chance to trigger Bonding when a wolf is at full health and delivers a bone.", "On success, the wolf will eat the bone anyway and both gain Bonding.", "0.02 = 2% (rare)."}).defineInRange("bondingChanceOnBoneDelivery", 0.02, 0.0, 1.0);
    public static final ForgeConfigSpec.IntValue BONDING_DURATION_TICKS = BUILDER.comment(new String[]{" ", "Bonding duration in ticks.", "20 ticks = 1 second. Default 6000 = 5 minutes."}).defineInRange("bondingDurationTicks", 12000, 20, 72000);
    public static final ForgeConfigSpec.DoubleValue BONDING_SHARED_DAMAGE_FACTOR = BUILDER.comment(new String[]{" ", "How much damage is mirrored to the bonded partner.", "0.5 = partner takes 50% of the damage you take."}).defineInRange("bondingSharedDamageFactor", 0.5, 0.0, 1.0);
    public static final ForgeConfigSpec.IntValue BONDING_SHARED_DAMAGE_RANGE = BUILDER.comment(new String[]{" ", "Maximum distance (in blocks) that a bonded partner must be within to receive shared damage.", "Set to 0 to disable range checks (shared damage applies regardless of distance)."}).defineInRange("bondingSharedDamageRange", 16, 0, 128);
    static final ForgeConfigSpec SPEC = BUILDER.build();

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
    }
}

