/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.fetch;

import java.util.UUID;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.athlantes.fetch.Config;
import org.athlantes.fetch.ModEntities;
import org.athlantes.fetch.effect.ModEffects;
import org.athlantes.fetch.entity.ThrownStickEntity;
import org.athlantes.fetch.entity.WolfStickLayer;
import org.athlantes.fetch.entity.WolfTailLayer;
import org.athlantes.fetch.goal.FetchStickGoal;
import org.athlantes.fetch.util.BondingData;
import org.athlantes.fetch.util.BondingManager;
import org.athlantes.fetch.util.FetchableItems;
import org.athlantes.fetch.util.HappinessManager;

public class ModEvents {
    @Deprecated
    public static final String WOLF_CARRYING_STICK_TAG = "fetch:carrying_stick";
    @Deprecated
    public static final String WOLF_HAS_FETCH_GOAL_TAG = "fetch:has_fetch_goal";

    @Mod.EventBusSubscriber(modid="athisworkshopfetch", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void addLayers(EntityRenderersEvent.AddLayers event) {
            WolfRenderer wolfRenderer = (WolfRenderer)event.getRenderer(EntityType.f_20499_);
            if (wolfRenderer != null) {
                wolfRenderer.m_115326_((RenderLayer)new WolfTailLayer((RenderLayerParent<Wolf, WolfModel<Wolf>>)wolfRenderer));
                wolfRenderer.m_115326_((RenderLayer)new WolfStickLayer((RenderLayerParent<Wolf, WolfModel<Wolf>>)wolfRenderer));
            }
        }
    }

    @Mod.EventBusSubscriber(modid="athisworkshopfetch", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEvents {
        private static final String TAG_BONDING_REFLECT = "athisworkshopfetch:bonding_reflect";
        private static final String PENDING_SAD_START = "athisworkshopfetch:pending_sad_start";
        private static final String PENDING_SAD_DURATION = "athisworkshopfetch:pending_sad_duration";

        private static boolean hasFetchGoal(Wolf wolf) {
            for (WrappedGoal wrapped : wolf.f_21345_.m_148105_()) {
                if (!(wrapped.m_26015_() instanceof FetchStickGoal)) continue;
                return true;
            }
            return false;
        }

        @SubscribeEvent
        public static void onEntityJoin(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof Wolf)) {
                return;
            }
            Wolf wolf = (Wolf)entity;
            if (event.getLevel().m_5776_()) {
                return;
            }
            if (!((Boolean)Config.ENABLE_FETCH_GOAL.get()).booleanValue()) {
                return;
            }
            if (!ForgeEvents.hasFetchGoal(wolf)) {
                wolf.f_21345_.m_25352_(2, (Goal)new FetchStickGoal(wolf));
            }
        }

        @SubscribeEvent
        public static void onLivingTick(LivingEvent.LivingTickEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Wolf)) {
                return;
            }
            Wolf wolf = (Wolf)livingEntity;
            if (wolf.m_9236_().f_46443_) {
                return;
            }
            HappinessManager.initializeHappiness(wolf);
            int happiness = HappinessManager.getHappiness(wolf);
            AttributeInstance speedAttr = wolf.m_21051_(Attributes.f_22279_);
            if (speedAttr != null) {
                speedAttr.m_22120_(HappinessManager.HAPPINESS_SPEED_MODIFIER_ID);
                if (happiness < 20) {
                    double speedReduction = HappinessManager.getSadnessSpeedModifier();
                    speedAttr.m_22118_(new AttributeModifier(HappinessManager.HAPPINESS_SPEED_MODIFIER_ID, "happiness_sadness_slowness", speedReduction, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            }
        }

        @SubscribeEvent
        public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
            ServerPlayer sp;
            Player player;
            ItemStack heldItem = event.getItemStack();
            if (!event.getLevel().f_46443_ && heldItem.m_150930_(Items.f_42455_) && (player = event.getEntity()) instanceof ServerPlayer && (sp = (ServerPlayer)player).m_21124_((MobEffect)ModEffects.BONDING.get()) != null) {
                MobEffectInstance inst = sp.m_21124_((MobEffect)ModEffects.BONDING.get());
                int duration = inst != null ? inst.m_19557_() : 0;
                int amplifier = inst != null ? inst.m_19564_() : 0;
                sp.getPersistentData().m_128405_("athisworkshopfetch:reapply_bonding_dur", duration);
                sp.getPersistentData().m_128405_("athisworkshopfetch:reapply_bonding_amp", amplifier);
                sp.getPersistentData().m_128379_("athisworkshopfetch:reapply_bonding", true);
            }
            if (!FetchableItems.isFetchable(heldItem)) {
                return;
            }
            Player player2 = event.getEntity();
            Level level = event.getLevel();
            if (!level.f_46443_) {
                boolean isBone = FetchableItems.isBone(heldItem);
                ThrownStickEntity thrownStick = new ThrownStickEntity((EntityType<? extends ThrownStickEntity>)(isBone ? (EntityType)ModEntities.THROWN_BONE.get() : (EntityType)ModEntities.THROWN_STICK.get()), (LivingEntity)player2, level);
                thrownStick.setThrownItem(heldItem.m_41720_());
                thrownStick.m_6034_(player2.m_20185_(), player2.m_20188_() - 0.1, player2.m_20189_());
                thrownStick.m_5602_((Entity)player2);
                float velocity = (float)((Double)Config.THROW_VELOCITY.get()).doubleValue();
                float inaccuracy = (float)((Double)Config.THROW_INACCURACY.get()).doubleValue();
                thrownStick.m_37251_((Entity)player2, player2.m_146909_(), player2.m_146908_(), 0.0f, velocity, inaccuracy);
                level.m_7967_((Entity)thrownStick);
                if (!player2.m_150110_().f_35937_) {
                    heldItem.m_41774_(1);
                }
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.m_19078_((boolean)level.f_46443_));
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            Entity entity = event.getTarget();
            if (!(entity instanceof Wolf)) {
                return;
            }
            Wolf wolf = (Wolf)entity;
            if (event.getHand() != InteractionHand.MAIN_HAND) {
                return;
            }
            Player player = event.getEntity();
            Level level = event.getLevel();
            if (level.f_46443_) {
                return;
            }
            if (wolf.m_19880_().contains(ModEvents.WOLF_CARRYING_STICK_TAG)) {
                boolean broke;
                ItemStack main = wolf.m_6844_(EquipmentSlot.MAINHAND);
                ItemStack toGive = !main.m_41619_() ? main : FetchableItems.getPrimaryFetchItem();
                boolean isVanillaStick = !main.m_41619_() && main.m_150930_(Items.f_42398_);
                double breakChance = isVanillaStick ? (Double)Config.RETRIEVE_BREAK_CHANCE.get() : 0.0;
                boolean bl = broke = breakChance > 0.0 && level.f_46441_.m_188500_() < breakChance;
                if (broke) {
                    wolf.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    wolf.m_20137_(ModEvents.WOLF_CARRYING_STICK_TAG);
                    wolf.m_21839_(false);
                    wolf.getPersistentData().m_128356_("fetch:last_gave_stick", level.m_46467_());
                    HappinessManager.onStickBreak(wolf);
                    level.m_6263_(null, wolf.m_20185_(), wolf.m_20186_(), wolf.m_20189_(), SoundEvents.f_12018_, SoundSource.NEUTRAL, 1.0f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
                    if (((Boolean)Config.ENABLE_PARTICLE_EFFECTS.get()).booleanValue() && level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, toGive), wolf.m_20185_(), wolf.m_20186_() + (double)wolf.m_20206_() * 0.6, wolf.m_20189_(), 16, 0.15, 0.15, 0.15, 0.02);
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.CONSUME);
                    return;
                }
                if (!player.m_150109_().m_36054_(toGive)) {
                    player.m_36176_(toGive, false);
                }
                wolf.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                wolf.m_20137_(ModEvents.WOLF_CARRYING_STICK_TAG);
                wolf.m_21839_(false);
                wolf.getPersistentData().m_128356_("fetch:last_gave_stick", level.m_46467_());
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
                return;
            }
            long lastGave = wolf.getPersistentData().m_128454_("fetch:last_gave_stick");
            if (level.m_46467_() - lastGave < 20L) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Player p;
            LivingEntity entity = event.getEntity();
            if (entity instanceof Wolf) {
                Entity entity2;
                Wolf wolf = (Wolf)entity;
                if (!entity.m_9236_().f_46443_ && wolf.m_21824_() && (entity2 = event.getSource().m_7639_()) instanceof Player) {
                    Player attacker = (Player)entity2;
                    if (wolf.m_269323_() != null && wolf.m_269323_().equals((Object)attacker)) {
                        HappinessManager.onOwnerAttack(wolf);
                    }
                }
            }
            if (!((Boolean)Config.ENABLE_BONDING.get()).booleanValue()) {
                return;
            }
            if (entity.m_9236_().f_46443_) {
                return;
            }
            MobEffectInstance instance = entity.m_21124_((MobEffect)ModEffects.BONDING.get());
            if (instance == null) {
                BondingData.clearBondPartner((Entity)entity);
                return;
            }
            if (entity.m_19880_().contains(TAG_BONDING_REFLECT)) {
                return;
            }
            double factor = (Double)Config.BONDING_SHARED_DAMAGE_FACTOR.get();
            if (factor <= 0.0) {
                return;
            }
            UUID partnerId = BondingData.getBondPartner((Entity)entity);
            if (partnerId == null) {
                return;
            }
            ServerLevel level = (ServerLevel)entity.m_9236_();
            Entity partnerEntity = level.m_8791_(partnerId);
            if (!(partnerEntity instanceof LivingEntity)) {
                BondingData.clearBondPartner((Entity)entity);
                return;
            }
            LivingEntity partner = (LivingEntity)partnerEntity;
            if (partnerEntity instanceof Wolf) {
                Wolf wolfPartner = (Wolf)partnerEntity;
                if (wolfPartner.m_21827_()) {
                    return;
                }
                int range = (Integer)Config.BONDING_SHARED_DAMAGE_RANGE.get();
                if (range > 0) {
                    double maxSq = (double)range * (double)range;
                    if (entity.m_20280_((Entity)wolfPartner) > maxSq) {
                        return;
                    }
                }
            }
            if (partner.m_21124_((MobEffect)ModEffects.BONDING.get()) == null) {
                BondingData.clearBondPartner((Entity)entity);
                BondingData.clearBondPartner((Entity)partner);
                return;
            }
            if (!partner.m_6084_()) {
                BondingData.clearBondPartner((Entity)entity);
                BondingData.clearBondPartner((Entity)partner);
                return;
            }
            if (partner instanceof Player && ((p = (Player)partner).m_7500_() || p.m_5833_())) {
                return;
            }
            float amount = event.getAmount();
            if (amount <= 0.0f) {
                return;
            }
            float mirrored = (float)((double)amount * factor);
            if (mirrored <= 0.0f) {
                return;
            }
            partner.m_20049_(TAG_BONDING_REFLECT);
            try {
                DamageSource src = entity.m_269291_().m_269425_();
                partner.m_6469_(src, mirrored);
            }
            finally {
                partner.m_20137_(TAG_BONDING_REFLECT);
            }
        }

        private static void breakBond(LivingEntity entity) {
            if (entity.m_9236_().f_46443_) {
                return;
            }
            UUID partnerId = BondingData.getBondPartner((Entity)entity);
            BondingData.clearBondPartner((Entity)entity);
            entity.m_21195_((MobEffect)ModEffects.BONDING.get());
            if (partnerId == null) {
                return;
            }
            Level level = entity.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel level2 = (ServerLevel)level;
            Entity partnerEntity = level2.m_8791_(partnerId);
            if (partnerEntity instanceof LivingEntity) {
                LivingEntity partner = (LivingEntity)partnerEntity;
                BondingData.clearBondPartner((Entity)partner);
                partner.m_21195_((MobEffect)ModEffects.BONDING.get());
            }
        }

        @SubscribeEvent
        public static void onLivingDeath(LivingDeathEvent event) {
            LivingEntity entity = event.getEntity();
            if (BondingData.getBondPartner((Entity)entity) == null && entity.m_21124_((MobEffect)ModEffects.BONDING.get()) == null) {
                return;
            }
            if (entity instanceof Wolf) {
                Wolf wolf = (Wolf)entity;
                if (!entity.m_9236_().f_46443_) {
                    try {
                        ServerLevel serverLevel;
                        Entity partnerEntity;
                        Level level;
                        UUID partnerId;
                        if (wolf.m_21824_() && (partnerId = BondingData.getBondPartner((Entity)wolf)) != null && (level = entity.m_9236_()) instanceof ServerLevel && (partnerEntity = (serverLevel = (ServerLevel)level).m_8791_(partnerId)) instanceof ServerPlayer) {
                            ServerPlayer owner = (ServerPlayer)partnerEntity;
                            boolean ownerBonding = owner.m_21124_((MobEffect)ModEffects.BONDING.get()) != null;
                            boolean wolfBonding = wolf.m_21124_((MobEffect)ModEffects.BONDING.get()) != null;
                            Entity attacker = event.getSource().m_7639_();
                            if (ownerBonding && wolfBonding && attacker instanceof LivingEntity) {
                                owner.m_7292_(new MobEffectInstance((MobEffect)ModEffects.RAGE.get(), 900, 0, false, true, true));
                                long startTick = serverLevel.m_46467_() + 900L;
                                owner.getPersistentData().m_128356_(PENDING_SAD_START, startTick);
                                owner.getPersistentData().m_128405_(PENDING_SAD_DURATION, 5400);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            ForgeEvents.breakBond(entity);
        }

        @SubscribeEvent
        public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
            Player player = event.getEntity();
            if (BondingData.getBondPartner((Entity)player) == null && player.m_21124_((MobEffect)ModEffects.BONDING.get()) == null) {
                return;
            }
            ForgeEvents.breakBond((LivingEntity)player);
        }

        @SubscribeEvent
        public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
            Level amp2;
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Player player = event.player;
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sp = (ServerPlayer)player;
            if (sp.m_9236_().f_46443_) {
                return;
            }
            if (sp.getPersistentData().m_128471_("athisworkshopfetch:reapply_bonding")) {
                sp.getPersistentData().m_128379_("athisworkshopfetch:reapply_bonding", false);
                int dur = sp.getPersistentData().m_128451_("athisworkshopfetch:reapply_bonding_dur");
                int amp2 = sp.getPersistentData().m_128451_("athisworkshopfetch:reapply_bonding_amp");
                if (dur != 0) {
                    ServerLevel level;
                    Entity partnerEntity;
                    Level level2;
                    sp.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BONDING.get(), dur, amp2, false, true, true));
                    UUID partnerId = BondingData.getBondPartner((Entity)sp);
                    if (partnerId != null && (level2 = sp.m_9236_()) instanceof ServerLevel && (partnerEntity = (level = (ServerLevel)level2).m_8791_(partnerId)) instanceof LivingEntity) {
                        LivingEntity partner = (LivingEntity)partnerEntity;
                        partner.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BONDING.get(), dur, amp2, false, true, true));
                    }
                }
            }
            if ((amp2 = sp.m_9236_()) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)amp2;
                BondingManager.syncBond(level, (LivingEntity)sp);
                if (sp.getPersistentData().m_128441_(PENDING_SAD_START)) {
                    long start = sp.getPersistentData().m_128454_(PENDING_SAD_START);
                    if (level.m_46467_() >= start) {
                        int sadDur = sp.getPersistentData().m_128451_(PENDING_SAD_DURATION);
                        if (sadDur <= 0) {
                            sadDur = 5400;
                        }
                        sp.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SADNESS.get(), sadDur, 0, false, true, true));
                        sp.getPersistentData().m_128473_(PENDING_SAD_START);
                        sp.getPersistentData().m_128473_(PENDING_SAD_DURATION);
                    }
                }
            }
        }
    }
}

