/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.fetch.entity;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.athlantes.fetch.Config;

@ParametersAreNonnullByDefault
public class ThrownStickEntity
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<String> DATA_THROWN_ITEM = SynchedEntityData.m_135353_(ThrownStickEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private int lifeTicks = 0;

    public ThrownStickEntity(EntityType<? extends ThrownStickEntity> type, Level level) {
        super(type, level);
    }

    public ThrownStickEntity(EntityType<? extends ThrownStickEntity> type, LivingEntity shooter, Level level) {
        super(type, shooter, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        ResourceLocation stickId = ForgeRegistries.ITEMS.getKey((Object)Items.f_42398_);
        this.f_19804_.m_135372_(DATA_THROWN_ITEM, (Object)(stickId != null ? stickId.toString() : "minecraft:stick"));
    }

    public void setThrownItem(Item item) {
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)item);
        if (itemId != null) {
            this.f_19804_.m_135381_(DATA_THROWN_ITEM, (Object)itemId.toString());
            this.m_37446_(new ItemStack((ItemLike)item));
        }
    }

    public Item getThrownItem() {
        String itemId = (String)this.f_19804_.m_135370_(DATA_THROWN_ITEM);
        ResourceLocation location = ResourceLocation.m_135820_((String)itemId);
        if (location != null && ForgeRegistries.ITEMS.containsKey(location)) {
            return (Item)ForgeRegistries.ITEMS.getValue(location);
        }
        return Items.f_42398_;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifeTicks;
    }

    public int getLifeTicks() {
        return this.lifeTicks;
    }

    @Nonnull
    protected Item m_7881_() {
        return this.getThrownItem();
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        if (!this.m_9236_().f_46443_) {
            ItemStack itemStack = new ItemStack((ItemLike)this.getThrownItem());
            ItemEntity droppedItem = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), itemStack);
            this.m_9236_().m_7967_((Entity)droppedItem);
            this.m_146870_();
        } else if (((Boolean)Config.ENABLE_PARTICLE_EFFECTS.get()).booleanValue()) {
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)this.getThrownItem())), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

