/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.fetch.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.athlantes.fetch.util.FetchableItems;

public class WolfStickLayer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    private static final Field HEAD_FIELD = WolfStickLayer.resolveHeadField();

    public WolfStickLayer(RenderLayerParent<Wolf, WolfModel<Wolf>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Wolf wolf, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack heldItem = wolf.m_6844_(EquipmentSlot.MAINHAND);
        if (!FetchableItems.isFetchable(heldItem)) {
            return;
        }
        poseStack.m_85836_();
        WolfModel model = (WolfModel)this.m_117386_();
        ModelPart head = WolfStickLayer.getHead((WolfModel<Wolf>)model);
        if (head == null) {
            poseStack.m_85849_();
            return;
        }
        head.m_104299_(poseStack);
        boolean baby = wolf.m_6162_();
        double[] positioning = this.getPositioningForItem(heldItem, baby);
        double tx = positioning[0];
        double ty = positioning[1];
        double tz = positioning[2];
        poseStack.m_85837_(tx, ty, tz);
        float[] rotation = this.getRotationForItem(heldItem);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotation[0]));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotation[1]));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation[2]));
        float scale = this.getScaleForItem(heldItem, baby);
        poseStack.m_85841_(scale, scale, scale);
        Minecraft.m_91087_().m_91291_().m_269491_((LivingEntity)wolf, heldItem, ItemDisplayContext.FIXED, false, poseStack, buffer, wolf.m_9236_(), packedLight, OverlayTexture.f_118083_, wolf.m_19879_());
        poseStack.m_85849_();
    }

    private double[] getPositioningForItem(ItemStack item, boolean baby) {
        if (item.m_150930_(Items.f_42500_)) {
            return new double[]{baby ? 0.08 : 0.1, baby ? 0.32 : 0.12, baby ? -0.05 : -0.25};
        }
        if (item.m_150930_(Items.f_42583_)) {
            return new double[]{baby ? 0.04 : 0.06, baby ? 0.28 : 0.08, baby ? 0.02 : -0.2};
        }
        return new double[]{baby ? 0.05 : 0.07, baby ? 0.3 : 0.1, baby ? 0.0 : -0.23};
    }

    private float[] getRotationForItem(ItemStack item) {
        if (item.m_150930_(Items.f_42500_)) {
            return new float[]{110.0f, 15.0f, 30.0f};
        }
        if (item.m_150930_(Items.f_42583_)) {
            return new float[]{95.0f, 5.0f, 35.0f};
        }
        return new float[]{100.0f, 0.0f, 45.0f};
    }

    private float getScaleForItem(ItemStack item, boolean baby) {
        float baseScale;
        float f = baseScale = baby ? 0.3f : 0.6f;
        if (item.m_150930_(Items.f_42500_)) {
            return baseScale * 0.85f;
        }
        if (item.m_150930_(Items.f_42583_)) {
            return baseScale * 1.1f;
        }
        return baseScale;
    }

    private static ModelPart getHead(WolfModel<Wolf> model) {
        Field field = HEAD_FIELD;
        if (field == null) {
            return null;
        }
        try {
            return (ModelPart)field.get(model);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    private static Field resolveHeadField() {
        String[] candidateNames;
        for (String name : candidateNames = new String[]{"f_104107_", "head"}) {
            try {
                Field f = ObfuscationReflectionHelper.findField(WolfModel.class, (String)name);
                f.setAccessible(true);
                return f;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

