/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.fetch.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Field;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.athlantes.fetch.util.HappinessManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WolfTailLayer
extends RenderLayer<Wolf, WolfModel<Wolf>> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"FetchMod");
    private static final Field TAIL_FIELD = WolfTailLayer.resolveTailField();
    private static final Field REAL_TAIL_FIELD = WolfTailLayer.resolveRealTailField();
    private static boolean loggedOnce = false;

    public WolfTailLayer(RenderLayerParent<Wolf, WolfModel<Wolf>> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Wolf wolf, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!wolf.m_21824_()) {
            return;
        }
        float tailAngleDegrees = HappinessManager.getTailAngle(wolf);
        float tailAngleRadians = (float)Math.toRadians(-tailAngleDegrees);
        float baseAngle = -0.12f;
        float finalAngle = baseAngle + tailAngleRadians;
        WolfModel model = (WolfModel)this.m_117386_();
        ModelPart tailPart = WolfTailLayer.getTailPart((WolfModel<Wolf>)model);
        ModelPart realTailPart = WolfTailLayer.getRealTailPart((WolfModel<Wolf>)model);
        if (tailPart != null) {
            tailPart.f_104203_ = finalAngle;
        }
        if (realTailPart != null) {
            realTailPart.f_104203_ = finalAngle;
        }
        if (!(loggedOnce || tailPart == null && realTailPart == null)) {
            LOGGER.info("WolfTailLayer: Successfully applying happiness-based tail angles");
            loggedOnce = true;
        }
    }

    private static Field resolveTailField() {
        String[] candidateNames = new String[]{"tail", "f_104115_", "m_228915_", "f_90116_", "upperTail"};
        for (String name : candidateNames) {
            try {
                Field f = ObfuscationReflectionHelper.findField(WolfModel.class, (String)name);
                f.setAccessible(true);
                LOGGER.info("Successfully resolved tail field with name: {}", (Object)name);
                return f;
            }
            catch (Exception exception) {
            }
        }
        LOGGER.warn("Failed to resolve tail field - trying to find all ModelPart fields");
        try {
            for (Field field : WolfModel.class.getDeclaredFields()) {
                if (field.getType() != ModelPart.class) continue;
                field.setAccessible(true);
                LOGGER.info("Found ModelPart field: {}", (Object)field.getName());
            }
        }
        catch (Exception e) {
            LOGGER.error("Error inspecting WolfModel fields", (Throwable)e);
        }
        return null;
    }

    private static Field resolveRealTailField() {
        String[] candidateNames;
        for (String name : candidateNames = new String[]{"realTail", "lowerTail", "f_104116_", "tail"}) {
            try {
                Field f = ObfuscationReflectionHelper.findField(WolfModel.class, (String)name);
                f.setAccessible(true);
                LOGGER.info("Successfully resolved realTail field with name: {}", (Object)name);
                return f;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static ModelPart getTailPart(WolfModel<Wolf> model) {
        if (TAIL_FIELD == null) {
            return null;
        }
        try {
            return (ModelPart)TAIL_FIELD.get(model);
        }
        catch (IllegalAccessException ignored) {
            return null;
        }
    }

    private static ModelPart getRealTailPart(WolfModel<Wolf> model) {
        if (REAL_TAIL_FIELD == null) {
            return null;
        }
        try {
            return (ModelPart)REAL_TAIL_FIELD.get(model);
        }
        catch (IllegalAccessException ignored) {
            return null;
        }
    }
}

