/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.fetch.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.athlantes.fetch.Config;
import org.athlantes.fetch.ModAdvancements;
import org.athlantes.fetch.effect.ModEffects;
import org.athlantes.fetch.entity.ThrownStickEntity;
import org.athlantes.fetch.util.BondingData;
import org.athlantes.fetch.util.FetchableItems;
import org.athlantes.fetch.util.HappinessManager;

public class FetchStickGoal
extends Goal {
    private final Wolf wolf;
    private ItemEntity targetStick;
    private ThrownStickEntity targetThrownStick;
    private boolean carrying;
    private int carryCount;
    private int carryTicks;
    private int cooldown;
    private double lastTargetDistSq = -1.0;
    private int noProgressTicks = 0;
    private ItemStack carriedItemType = new ItemStack((ItemLike)Items.f_42398_);
    private boolean keepUntilRightClick;
    private int keepCloseTicks;
    private static final int LOW_HAPPINESS_THRESHOLD = 20;
    private static final double LOW_HAPPINESS_WALK_SPEED = 0.6;

    public FetchStickGoal(Wolf wolf) {
        this.wolf = wolf;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    private double getSearchRadius() {
        return ((Integer)Config.FETCH_SEARCH_RADIUS.get()).intValue();
    }

    private double getFetchSpeed() {
        double base = (Double)Config.WOLF_FETCH_SPEED.get();
        int happiness = HappinessManager.getHappiness(this.wolf);
        if (happiness < 20) {
            return Math.min(base, 0.6);
        }
        return base;
    }

    private int getCarryTimeLimit() {
        return (Integer)Config.STICK_CARRY_TIME_LIMIT.get();
    }

    private double getPickupDistance() {
        return 2.25;
    }

    private double getDropDistance() {
        return 1.0;
    }

    private void syncCarryFromEntity() {
        boolean shouldBeCarrying;
        boolean hasTag = this.wolf.m_19880_().contains("fetch:carrying_stick");
        ItemStack main = this.wolf.m_6844_(EquipmentSlot.MAINHAND);
        boolean hasItemInHand = !main.m_41619_() && FetchableItems.isFetchable(main);
        boolean bl = shouldBeCarrying = hasTag || hasItemInHand;
        if (!shouldBeCarrying) {
            if (this.carrying || this.keepUntilRightClick) {
                this.carrying = false;
                this.keepUntilRightClick = false;
                this.keepCloseTicks = 0;
                this.carryTicks = 0;
                this.carryCount = 0;
                this.targetStick = null;
                this.targetThrownStick = null;
                this.wolf.m_21573_().m_26573_();
            }
            return;
        }
        if (!this.carrying) {
            this.carrying = true;
            this.carryTicks = 0;
            this.keepCloseTicks = 0;
            this.carryCount = Math.max(1, main.m_41613_());
        }
    }

    public boolean m_8036_() {
        this.syncCarryFromEntity();
        if (this.carrying) {
            return this.wolf.m_269323_() != null && this.wolf.m_5448_() == null;
        }
        if (this.wolf.m_21827_() || this.wolf.m_5448_() != null || this.wolf.m_269323_() == null) {
            return false;
        }
        this.syncCarryFromEntity();
        if (this.carrying) {
            return true;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        if (((Boolean)Config.PRIORITIZE_THROWN_STICKS.get()).booleanValue()) {
            this.targetThrownStick = this.findThrownStick();
            if (this.targetThrownStick != null) {
                return true;
            }
        }
        this.targetStick = this.findItemStick();
        return this.targetStick != null;
    }

    public boolean m_8045_() {
        if (this.wolf.m_21827_() || this.wolf.m_5448_() != null) {
            return false;
        }
        this.syncCarryFromEntity();
        if (this.carrying) {
            return this.wolf.m_269323_() != null && this.wolf.m_269323_().m_6084_();
        }
        if (this.targetThrownStick != null) {
            return this.targetThrownStick.m_6084_();
        }
        return this.targetStick != null && this.targetStick.m_6084_();
    }

    public void m_8056_() {
        this.carryTicks = 0;
        this.lastTargetDistSq = -1.0;
        this.noProgressTicks = 0;
    }

    public void m_8041_() {
        this.targetStick = null;
        this.targetThrownStick = null;
        this.wolf.m_21573_().m_26573_();
        this.lastTargetDistSq = -1.0;
        this.noProgressTicks = 0;
        if (this.carrying && !this.wolf.m_21827_()) {
            this.carrying = false;
            this.keepUntilRightClick = false;
            this.wolf.m_20137_("fetch:carrying_stick");
            if (!this.wolf.m_9236_().f_46443_) {
                this.wolf.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
    }

    public void m_8037_() {
        this.syncCarryFromEntity();
        LivingEntity owner = this.wolf.m_269323_();
        if (owner == null) {
            return;
        }
        if (this.carrying) {
            if (this.wolf.m_21827_()) {
                this.wolf.m_21839_(false);
            }
            if (!this.wolf.m_9236_().f_46443_) {
                ++this.carryTicks;
                double dist = this.wolf.m_20280_((Entity)owner);
                if (dist > 4096.0) {
                    this.wolf.m_21573_().m_26573_();
                    this.wolf.m_7678_(owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), this.wolf.m_146908_(), this.wolf.m_146909_());
                    return;
                }
                if (dist < this.getDropDistance()) {
                    if (this.carriedItemType != null) {
                        if (((Boolean)Config.BONE_HEALS_ON_DELIVERY.get()).booleanValue() && this.carriedItemType.m_150930_(Items.f_42500_) && this.wolf.m_21223_() < this.wolf.m_21233_()) {
                            this.eatCarriedToHeal((float)((Double)Config.BONE_HEAL_AMOUNT.get()).doubleValue());
                            return;
                        }
                        if (((Boolean)Config.ROTTEN_FLESH_HEALS_ON_DELIVERY.get()).booleanValue() && this.carriedItemType.m_150930_(Items.f_42583_) && this.wolf.m_21223_() < this.wolf.m_21233_()) {
                            this.eatCarriedToHeal((float)((Double)Config.ROTTEN_FLESH_HEAL_AMOUNT.get()).doubleValue());
                            return;
                        }
                    }
                    if (!this.wolf.m_9236_().f_46443_ && ((Boolean)Config.ENABLE_BONDING.get()).booleanValue() && this.carriedItemType != null && this.carriedItemType.m_150930_(Items.f_42500_) && this.wolf.m_21223_() >= this.wolf.m_21233_() && owner instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)owner;
                        boolean wolfAlreadyBonded = this.wolf.m_21124_((MobEffect)ModEffects.BONDING.get()) != null || BondingData.getBondPartner((Entity)this.wolf) != null;
                        boolean playerAlreadyBonded = serverPlayer.m_21124_((MobEffect)ModEffects.BONDING.get()) != null || BondingData.getBondPartner((Entity)serverPlayer) != null;
                        double chance = (Double)Config.BONDING_CHANCE_ON_BONE_DELIVERY.get();
                        if (!wolfAlreadyBonded && !playerAlreadyBonded && chance > 0.0 && this.wolf.m_217043_().m_188500_() < chance) {
                            this.eatCarriedToHeal(0.0f);
                            int duration = (Integer)Config.BONDING_DURATION_TICKS.get();
                            this.wolf.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BONDING.get(), duration, 0, false, true, true));
                            serverPlayer.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BONDING.get(), duration, 0, false, true, true));
                            BondingData.setBondPartner((Entity)this.wolf, serverPlayer.m_20148_());
                            BondingData.setBondPartner((Entity)serverPlayer, this.wolf.m_20148_());
                            ModAdvancements.awardBestFriends(serverPlayer);
                            try {
                                int sadDurW;
                                int sadDur;
                                if (serverPlayer.m_21124_((MobEffect)ModEffects.SADNESS.get()) != null) {
                                    MobEffectInstance sad = serverPlayer.m_21124_((MobEffect)ModEffects.SADNESS.get());
                                    int remaining = sad.m_19557_();
                                    int halved = Math.max(1, remaining / 2);
                                    serverPlayer.m_21195_((MobEffect)ModEffects.SADNESS.get());
                                    serverPlayer.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SADNESS.get(), halved, 0, false, true, true));
                                } else if (serverPlayer.getPersistentData().m_128441_("athisworkshopfetch:pending_sad_start") && (sadDur = serverPlayer.getPersistentData().m_128451_("athisworkshopfetch:pending_sad_duration")) > 0) {
                                    int halved = Math.max(1, sadDur / 2);
                                    serverPlayer.getPersistentData().m_128405_("athisworkshopfetch:pending_sad_duration", halved);
                                }
                                if (this.wolf.m_21124_((MobEffect)ModEffects.SADNESS.get()) != null) {
                                    MobEffectInstance sadW = this.wolf.m_21124_((MobEffect)ModEffects.SADNESS.get());
                                    int remainingW = sadW.m_19557_();
                                    int halvedW = Math.max(1, remainingW / 2);
                                    this.wolf.m_21195_((MobEffect)ModEffects.SADNESS.get());
                                    this.wolf.m_7292_(new MobEffectInstance((MobEffect)ModEffects.SADNESS.get(), halvedW, 0, false, true, true));
                                } else if (this.wolf.getPersistentData().m_128441_("athisworkshopfetch:pending_sad_start") && (sadDurW = this.wolf.getPersistentData().m_128451_("athisworkshopfetch:pending_sad_duration")) > 0) {
                                    int halvedW = Math.max(1, sadDurW / 2);
                                    this.wolf.getPersistentData().m_128405_("athisworkshopfetch:pending_sad_duration", halvedW);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    if (this.keepUntilRightClick) {
                        ++this.keepCloseTicks;
                        double dropRangeSq = this.getDropDistance() * this.getDropDistance();
                        if (this.keepCloseTicks > 20 || dist < dropRangeSq * 0.5) {
                            this.keepUntilRightClick = false;
                            this.keepCloseTicks = 0;
                            this.dropStick(owner);
                        } else {
                            this.wolf.m_21573_().m_26573_();
                        }
                    } else {
                        double keepChance = (Double)Config.KEEP_STICK_CHANCE.get();
                        if (this.wolf.m_217043_().m_188500_() < keepChance) {
                            this.keepUntilRightClick = true;
                            this.keepCloseTicks = 0;
                            this.wolf.m_21573_().m_26573_();
                        } else {
                            this.dropStick(owner);
                        }
                    }
                    return;
                }
                int timeLimit = this.getCarryTimeLimit();
                if (timeLimit > 0 && this.carryTicks > timeLimit) {
                    this.keepUntilRightClick = false;
                    this.dropStick(owner);
                    return;
                }
            }
            if (this.keepUntilRightClick) {
                this.keepCloseTicks = 0;
                this.wolf.m_21573_().m_5624_((Entity)owner, this.getFetchSpeed());
                return;
            }
            this.wolf.m_21573_().m_5624_((Entity)owner, this.getFetchSpeed());
            this.wolf.m_21563_().m_24960_((Entity)owner, 30.0f, 30.0f);
            return;
        }
        if (this.targetThrownStick != null && this.targetThrownStick.m_6084_()) {
            this.wolf.m_21573_().m_5624_((Entity)this.targetThrownStick, this.getFetchSpeed());
            if (!this.wolf.m_9236_().f_46443_ && this.shouldAbandonTarget((Entity)this.targetThrownStick)) {
                this.abandonCurrentTarget();
                return;
            }
            if (this.wolf.m_20280_((Entity)this.targetThrownStick) < this.getPickupDistance() && !this.wolf.m_9236_().f_46443_) {
                this.pickupThrown();
            }
            return;
        }
        if (this.targetStick != null && this.targetStick.m_6084_()) {
            this.wolf.m_21573_().m_5624_((Entity)this.targetStick, this.getFetchSpeed());
            if (!this.wolf.m_9236_().f_46443_ && this.shouldAbandonTarget((Entity)this.targetStick)) {
                this.abandonCurrentTarget();
                return;
            }
            if (this.wolf.m_20280_((Entity)this.targetStick) < this.getPickupDistance() && !this.wolf.m_9236_().f_46443_) {
                this.pickupItem();
            }
        }
    }

    private void abandonCurrentTarget() {
        this.targetStick = null;
        this.targetThrownStick = null;
        this.lastTargetDistSq = -1.0;
        this.noProgressTicks = 0;
        this.cooldown = 40;
        this.wolf.m_21573_().m_26573_();
    }

    private boolean shouldAbandonTarget(Entity target) {
        boolean madeProgress;
        double distSq = this.wolf.m_20280_(target);
        if (this.lastTargetDistSq < 0.0) {
            this.lastTargetDistSq = distSq;
            this.noProgressTicks = 0;
            return false;
        }
        boolean bl = madeProgress = distSq < this.lastTargetDistSq - 0.01;
        if (madeProgress) {
            this.noProgressTicks = 0;
            this.lastTargetDistSq = distSq;
            return false;
        }
        ++this.noProgressTicks;
        if (this.wolf.m_21573_().m_26571_() && distSq > this.getPickupDistance()) {
            return true;
        }
        return this.noProgressTicks > 60;
    }

    private void pickupThrown() {
        Level level;
        ItemStack itemToCarry;
        this.carrying = true;
        this.keepUntilRightClick = false;
        this.carryCount = 1;
        this.carryTicks = 0;
        this.wolf.m_20049_("fetch:carrying_stick");
        this.carriedItemType = itemToCarry = new ItemStack((ItemLike)this.targetThrownStick.getThrownItem());
        this.wolf.m_8061_(EquipmentSlot.MAINHAND, itemToCarry);
        if (((Boolean)Config.ENABLE_PANT_SOUNDS.get()).booleanValue()) {
            this.wolf.m_9236_().m_6263_(null, this.wolf.m_20185_(), this.wolf.m_20186_(), this.wolf.m_20189_(), SoundEvents.f_12622_, SoundSource.NEUTRAL, 0.8f, 0.9f + this.wolf.m_217043_().m_188501_() * 0.2f);
        }
        if (((Boolean)Config.SHOW_CARRY_INDICATOR.get()).booleanValue() && (level = this.wolf.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.wolf.m_20185_(), this.wolf.m_20186_() + (double)this.wolf.m_20206_() * 0.6, this.wolf.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
        }
        this.targetThrownStick.m_146870_();
        this.targetThrownStick = null;
        this.wolf.m_21573_().m_26573_();
    }

    private void pickupItem() {
        Level level;
        this.carrying = true;
        this.keepUntilRightClick = false;
        this.carryCount = this.targetStick.m_32055_().m_41613_();
        this.carryTicks = 0;
        this.wolf.m_20049_("fetch:carrying_stick");
        ItemStack itemToCarry = this.targetStick.m_32055_().m_41777_();
        itemToCarry.m_41764_(1);
        this.carriedItemType = itemToCarry;
        this.wolf.m_8061_(EquipmentSlot.MAINHAND, itemToCarry);
        if (((Boolean)Config.ENABLE_PANT_SOUNDS.get()).booleanValue()) {
            this.wolf.m_9236_().m_6263_(null, this.wolf.m_20185_(), this.wolf.m_20186_(), this.wolf.m_20189_(), SoundEvents.f_12622_, SoundSource.NEUTRAL, 0.8f, 0.9f + this.wolf.m_217043_().m_188501_() * 0.2f);
        }
        if (((Boolean)Config.SHOW_CARRY_INDICATOR.get()).booleanValue() && (level = this.wolf.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.wolf.m_20185_(), this.wolf.m_20186_() + (double)this.wolf.m_20206_() * 0.6, this.wolf.m_20189_(), 5, 0.3, 0.3, 0.3, 0.0);
        }
        this.targetStick.m_146870_();
        this.targetStick = null;
        this.wolf.m_21573_().m_26573_();
    }

    private void dropStick(LivingEntity owner) {
        this.wolf.m_21573_().m_26573_();
        ItemStack itemToDrop = new ItemStack((ItemLike)this.carriedItemType.m_41720_(), Math.max(1, this.carryCount));
        int timeLimit = this.getCarryTimeLimit();
        Vec3 pos = timeLimit > 0 && this.carryTicks > timeLimit ? this.wolf.m_20182_() : owner.m_20182_();
        ItemEntity drop = new ItemEntity(this.wolf.m_9236_(), pos.f_82479_, pos.f_82480_ + 0.3, pos.f_82481_, itemToDrop);
        drop.m_32010_(40);
        drop.m_20334_(0.0, 0.1, 0.0);
        if (!this.wolf.m_9236_().f_46443_) {
            drop.getPersistentData().m_128359_("fetch:dropped_by_wolf_uuid", this.wolf.m_20148_().toString());
            drop.getPersistentData().m_128356_("fetch:dropped_by_wolf_time", this.wolf.m_9236_().m_46467_());
        }
        this.wolf.m_9236_().m_7967_((Entity)drop);
        if (!this.wolf.m_9236_().f_46443_ && owner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            if (FetchableItems.isFetchable(itemToDrop)) {
                ModAdvancements.awardGoodBoy(serverPlayer);
                HappinessManager.onItemDelivery(this.wolf);
            }
        }
        this.wolf.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.wolf.m_20137_("fetch:carrying_stick");
        this.carrying = false;
        this.keepUntilRightClick = false;
        this.keepCloseTicks = 0;
        this.carryTicks = 0;
        this.cooldown = 40;
        this.lastTargetDistSq = -1.0;
        this.noProgressTicks = 0;
    }

    private void eatCarriedToHeal(float healAmount) {
        Level level;
        float missing = this.wolf.m_21233_() - this.wolf.m_21223_();
        if (missing > 0.0f && healAmount > 0.0f) {
            this.wolf.m_5634_(Math.min(healAmount, missing));
        }
        if (this.carriedItemType != null) {
            if (this.carriedItemType.m_150930_(Items.f_42500_)) {
                HappinessManager.onEatBone(this.wolf);
            } else if (this.carriedItemType.m_150930_(Items.f_42583_)) {
                HappinessManager.onEatRottenFlesh(this.wolf);
            }
        }
        if ((level = this.wolf.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.wolf.m_20185_(), this.wolf.m_20186_() + (double)this.wolf.m_20206_() * 0.6, this.wolf.m_20189_(), 6, 0.25, 0.25, 0.25, 0.02);
        }
        this.wolf.m_9236_().m_6263_(null, this.wolf.m_20185_(), this.wolf.m_20186_(), this.wolf.m_20189_(), SoundEvents.f_11912_, SoundSource.NEUTRAL, 0.9f, 0.9f + this.wolf.m_217043_().m_188501_() * 0.2f);
        this.wolf.m_21573_().m_26573_();
        this.wolf.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.wolf.m_20137_("fetch:carrying_stick");
        this.carrying = false;
        this.keepUntilRightClick = false;
        this.carryTicks = 0;
        this.carryCount = 0;
        this.cooldown = 40;
    }

    private ThrownStickEntity findThrownStick() {
        List list = this.wolf.m_9236_().m_6443_(ThrownStickEntity.class, this.wolf.m_20191_().m_82400_(this.getSearchRadius()), Entity::m_6084_);
        if (list.isEmpty()) {
            return null;
        }
        list.sort((a, b) -> {
            int age = Integer.compare(a.getLifeTicks(), b.getLifeTicks());
            return age != 0 ? age : Double.compare(this.wolf.m_20280_((Entity)a), this.wolf.m_20280_((Entity)b));
        });
        return (ThrownStickEntity)((Object)list.get(0));
    }

    private ItemEntity findItemStick() {
        List list = this.wolf.m_9236_().m_6443_(ItemEntity.class, this.wolf.m_20191_().m_82400_(this.getSearchRadius()), e -> FetchableItems.isFetchable(e.m_32055_()) && e.m_6084_() && !e.m_32063_() && !this.wasDroppedByThisWolfRecently((ItemEntity)e));
        if (list.isEmpty()) {
            return null;
        }
        list.sort((a, b) -> Double.compare(this.wolf.m_20280_((Entity)a), this.wolf.m_20280_((Entity)b)));
        return (ItemEntity)list.get(0);
    }

    private boolean wasDroppedByThisWolfRecently(ItemEntity item) {
        if (!item.getPersistentData().m_128441_("fetch:dropped_by_wolf_uuid")) {
            return false;
        }
        String uuid = item.getPersistentData().m_128461_("fetch:dropped_by_wolf_uuid");
        if (!this.wolf.m_20148_().toString().equals(uuid)) {
            return false;
        }
        long droppedAt = item.getPersistentData().m_128454_("fetch:dropped_by_wolf_time");
        long now = this.wolf.m_9236_().m_46467_();
        return now - droppedAt < 200L;
    }
}

