/*
 * Decompiled with CFR 0.152.
 */
package org.athlantes.fetch.util;

import java.util.UUID;
import net.minecraft.world.entity.animal.Wolf;

public class HappinessManager {
    private static final String HAPPINESS_TAG = "fetch:happiness";
    public static final UUID HAPPINESS_SPEED_MODIFIER_ID = UUID.fromString("a1b2c3d4-e5f6-7890-abcd-ef1234567890");
    private static final double SADNESS_SPEED_REDUCTION = -0.25;
    private static final int STICK_BREAK_SADNESS = 20;
    private static final int OWNER_ATTACK_SADNESS = 25;
    private static final int BONE_HAPPINESS = 15;
    private static final int FLESH_HAPPINESS = 12;
    private static final int ITEM_DELIVERY_HAPPINESS = 10;
    private static final int DEFAULT_HAPPINESS = 50;
    private static final int MIN_HAPPINESS = 0;
    private static final int MAX_HAPPINESS = 100;
    private static final float MIN_TAIL_ANGLE = -45.0f;
    private static final float MAX_TAIL_ANGLE = 45.0f;

    public static int getHappiness(Wolf wolf) {
        int happiness = wolf.getPersistentData().m_128451_(HAPPINESS_TAG);
        if (happiness == 0 && !wolf.getPersistentData().m_128441_(HAPPINESS_TAG)) {
            return 50;
        }
        return happiness;
    }

    private static void setHappiness(Wolf wolf, int happiness) {
        int clamped = Math.max(0, Math.min(100, happiness));
        wolf.getPersistentData().m_128405_(HAPPINESS_TAG, clamped);
    }

    public static void increaseHappiness(Wolf wolf, int amount) {
        int current = HappinessManager.getHappiness(wolf);
        HappinessManager.setHappiness(wolf, current + amount);
    }

    public static void decreaseHappiness(Wolf wolf, int amount) {
        int current = HappinessManager.getHappiness(wolf);
        HappinessManager.setHappiness(wolf, current - amount);
    }

    public static void onStickBreak(Wolf wolf) {
        HappinessManager.decreaseHappiness(wolf, 20);
    }

    public static void onOwnerAttack(Wolf wolf) {
        HappinessManager.decreaseHappiness(wolf, 25);
    }

    public static void onEatBone(Wolf wolf) {
        HappinessManager.increaseHappiness(wolf, 15);
    }

    public static void onEatRottenFlesh(Wolf wolf) {
        HappinessManager.increaseHappiness(wolf, 12);
    }

    public static void onItemDelivery(Wolf wolf) {
        HappinessManager.increaseHappiness(wolf, 10);
    }

    public static float getTailAngle(Wolf wolf) {
        int happiness = HappinessManager.getHappiness(wolf);
        return HappinessManager.getTailAngleFromHappiness(happiness);
    }

    public static float getTailAngleFromHappiness(int happiness) {
        float normalized = (float)(happiness - 50) / 50.0f;
        return normalized * 45.0f;
    }

    public static void initializeHappiness(Wolf wolf) {
        if (!wolf.getPersistentData().m_128441_(HAPPINESS_TAG)) {
            HappinessManager.setHappiness(wolf, 50);
        }
    }

    public static double getSadnessSpeedModifier() {
        return -0.25;
    }
}

