/*
 * Decompiled with CFR 0.152.
 */
package com.zoomable.zoomable;

import com.zoomable.zoomable.CameraPull;
import com.zoomable.zoomable.ZoomableConfig;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

public class ZoomableClient
implements ClientModInitializer {
    public static ZoomableConfig CONFIG;
    private static class_304 PULL_BACK;
    private static class_304 PUSH_FORWARD;
    private static class_304 RESET;

    public void onInitializeClient() {
        CONFIG = ZoomableConfig.load();
        try {
            PULL_BACK = ZoomableClient.safeRegister("key.zoomable.zoom_in", 75);
            PUSH_FORWARD = ZoomableClient.safeRegister("key.zoomable.zoom_out", 76);
            RESET = ZoomableClient.safeRegister("key.zoomable.reset_zoom", 79);
        }
        catch (Throwable t) {
            System.err.println("[Zoomable] Keybind init failed (Shift+Scroll still works).");
            t.printStackTrace();
            RESET = null;
            PUSH_FORWARD = null;
            PULL_BACK = null;
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (PULL_BACK != null) {
                while (PULL_BACK.method_1436()) {
                    CameraPull.onScroll(-1.0);
                }
            }
            if (PUSH_FORWARD != null) {
                while (PUSH_FORWARD.method_1436()) {
                    CameraPull.onScroll(1.0);
                }
            }
            if (RESET != null) {
                while (RESET.method_1436()) {
                    CameraPull.reset();
                }
            }
        });
    }

    private static class_304 safeRegister(String key, int defaultKey) {
        try {
            Constructor ctor = class_304.class.getConstructor(String.class, class_3675.class_307.class, Integer.TYPE, String.class);
            class_304 kb = (class_304)ctor.newInstance(key, class_3675.class_307.field_1668, defaultKey, "category.zoomable");
            return KeyBindingHelper.registerKeyBinding((class_304)kb);
        }
        catch (Throwable ctor) {
            try {
                Class<?> catClass = Class.forName("net.minecraft.client.option.KeyBinding$Category");
                Object category = ZoomableClient.findAnyCategory(catClass);
                Constructor ctor2 = class_304.class.getConstructor(String.class, class_3675.class_307.class, Integer.TYPE, catClass);
                Object kbObj = ctor2.newInstance(key, class_3675.class_307.field_1668, defaultKey, category);
                return KeyBindingHelper.registerKeyBinding((class_304)((class_304)kbObj));
            }
            catch (Throwable t) {
                System.err.println("[Zoomable] Couldn't register keybind: " + key);
                t.printStackTrace();
                return null;
            }
        }
    }

    private static Object findAnyCategory(Class<?> catClass) throws Exception {
        try {
            Field f = catClass.getField("MISC");
            return f.get(null);
        }
        catch (Throwable f) {
            ?[] vals;
            for (Field f2 : catClass.getFields()) {
                Object v;
                if (!Modifier.isStatic(f2.getModifiers()) || f2.getType() != catClass || (v = f2.get(null)) == null) continue;
                return v;
            }
            if (catClass.isEnum() && (vals = catClass.getEnumConstants()) != null && vals.length > 0) {
                return vals[0];
            }
            return null;
        }
    }

    public static boolean shouldHandleScroll(class_310 client, long window) {
        String mod;
        if (client.field_1755 != null) {
            return false;
        }
        return switch (mod = CONFIG == null || ZoomableClient.CONFIG.scrollModifier == null ? "SHIFT" : ZoomableClient.CONFIG.scrollModifier.trim().toUpperCase()) {
            case "NONE" -> true;
            case "CTRL" -> {
                if (ZoomableClient.keyDown(window, 341) || ZoomableClient.keyDown(window, 345)) {
                    yield true;
                }
                yield false;
            }
            case "ALT" -> {
                if (ZoomableClient.keyDown(window, 342) || ZoomableClient.keyDown(window, 346)) {
                    yield true;
                }
                yield false;
            }
            default -> ZoomableClient.keyDown(window, 340) || ZoomableClient.keyDown(window, 344);
        };
    }

    private static boolean keyDown(long window, int key) {
        return GLFW.glfwGetKey((long)window, (int)key) == 1;
    }
}

