/*
 * Decompiled with CFR 0.152.
 */
package com.zoomable.zoomable;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ZoomableConfig {
    public String scrollModifier = "SHIFT";
    public boolean cancelHotbarScrollWhenZooming = true;
    public double cameraMaxDistance = 4.0;
    public double cameraStep = 0.9;
    public double cameraSmoothness = 0.35;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static ZoomableConfig load() {
        try {
            Path path = FabricLoader.getInstance().getConfigDir().resolve("zoomable.json");
            if (Files.exists(path, new LinkOption[0])) {
                ZoomableConfig cfg = (ZoomableConfig)GSON.fromJson(Files.readString(path), ZoomableConfig.class);
                return cfg != null ? cfg : new ZoomableConfig();
            }
            ZoomableConfig cfg = new ZoomableConfig();
            Files.writeString(path, (CharSequence)GSON.toJson((Object)cfg), new OpenOption[0]);
            return cfg;
        }
        catch (Exception e) {
            return new ZoomableConfig();
        }
    }
}

